/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.util;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.util.GameTaskQueueManager;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.export.binary.BinaryImporter;
import com.jme.util.resource.ResourceLocator;
import com.jme.util.resource.ResourceLocatorTool;
import com.jme.util.resource.SimpleResourceLocator;
import com.jmex.game.StandardGame;
import com.jmex.game.state.DebugGameState;
import com.jmex.game.state.GameState;
import com.jmex.game.state.GameStateManager;
import com.jmex.game.state.load.LoadingGameState;
import com.jmex.model.collada.ColladaImporter;
import com.jmex.model.converters.AseToJme;
import com.jmex.model.converters.FormatConverter;
import com.jmex.model.converters.MaxToJme;
import com.jmex.model.converters.Md2ToJme;
import com.jmex.model.converters.Md3ToJme;
import com.jmex.model.converters.MilkToJme;
import com.jmex.model.converters.ObjToJme;
import com.jmex.model.converters.X3dToJme;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class ModelLoader {
    private static final Logger logger = Logger.getLogger(ModelLoader.class.getName());
    private static Map<String, ModelLoaderCallable> loaders = new HashMap<String, ModelLoaderCallable>();

    public static void main(String[] stringArray) {
        block14: {
            try {
                JFileChooser jFileChooser = new JFileChooser();
                Preferences preferences = Preferences.userNodeForPackage(ModelLoader.class);
                File file = new File(preferences.get("StartDirectory", "."));
                jFileChooser.setCurrentDirectory(file);
                if (jFileChooser.showOpenDialog(null) != 0) break block14;
                File file2 = jFileChooser.getSelectedFile();
                if (ModelLoader.isValidModelFile(file2)) {
                    preferences.put("StartDirectory", file2.getAbsolutePath());
                    StandardGame standardGame = new StandardGame("Model Loader");
                    try {
                        standardGame.getSettings().clear();
                    }
                    catch (Exception exception) {
                        logger.logp(Level.SEVERE, ModelLoader.class.toString(), "main(args)", "Exception", exception);
                    }
                    standardGame.start();
                    GameTaskQueueManager.getManager().update((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return null;
                        }
                    });
                    DebugGameState debugGameState = new DebugGameState();
                    GameStateManager.getInstance().attachChild((GameState)debugGameState);
                    debugGameState.setActive(true);
                    LoadingGameState loadingGameState = new LoadingGameState();
                    GameStateManager.getInstance().attachChild((GameState)loadingGameState);
                    loadingGameState.setActive(true);
                    loadingGameState.setProgress(0.5f, "Loading Model: " + file2.getName());
                    long l = System.currentTimeMillis();
                    SimpleResourceLocator simpleResourceLocator = new SimpleResourceLocator(file2.getParentFile().toURI());
                    ResourceLocatorTool.addResourceLocator((String)"texture", (ResourceLocator)simpleResourceLocator);
                    ResourceLocatorTool.addResourceLocator((String)"model", (ResourceLocator)simpleResourceLocator);
                    Node node = ModelLoader.loadModel(file2);
                    ModelLoader.outputElapsed(l);
                    if (node != null) {
                        node.updateRenderState();
                        if (file2.getName().toLowerCase().endsWith(".jme")) {
                            loadingGameState.setProgress(1.0f, "Loaded Successfully");
                        } else {
                            loadingGameState.setProgress(0.8f, "Loaded Successfully - Saving");
                            try {
                                BinaryExporter.getInstance().save((Savable)node, ModelLoader.createJMEFile(file2.getAbsoluteFile()));
                                loadingGameState.setProgress(1.0f, "Binary File Written Successfully");
                            }
                            catch (IOException iOException) {
                                logger.logp(Level.SEVERE, ModelLoader.class.toString(), "main(args)", "Exception", iOException);
                                loadingGameState.setProgress(0.9f, "Binary Save Failure");
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    logger.logp(Level.SEVERE, ModelLoader.class.toString(), "main(args)", "Exception", interruptedException);
                                }
                                loadingGameState.setProgress(1.0f);
                            }
                        }
                        debugGameState.getRootNode().attachChild((Spatial)ModelLoader.scale(node));
                        debugGameState.getRootNode().updateRenderState();
                        break block14;
                    }
                    loadingGameState.setProgress(0.9f, "Model Not Loaded");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.logp(Level.SEVERE, ModelLoader.class.toString(), "main(args)", "Exception", interruptedException);
                    }
                    loadingGameState.setProgress(1.0f);
                    break block14;
                }
                JOptionPane.showMessageDialog(null, "Selected file's extension is unknown model type: " + file2.getName());
            }
            catch (Throwable throwable) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                JFrame jFrame = new JFrame();
                jFrame.setTitle("ModelLoader - StackTrace");
                jFrame.setDefaultCloseOperation(3);
                JTextPane jTextPane = new JTextPane();
                jTextPane.setPreferredSize(new Dimension(400, 400));
                jTextPane.setContentType("text/plain");
                jTextPane.setText(stringWriter.getBuffer().toString());
                jFrame.setContentPane(new JScrollPane(jTextPane));
                jFrame.pack();
                jFrame.setLocationRelativeTo(null);
                jFrame.setVisible(true);
            }
        }
    }

    private static File createJMEFile(File file) {
        String string = file.getName();
        if (string.indexOf(46) != -1) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        string = string + ".jme";
        return new File(file.getParentFile(), string);
    }

    private static void outputElapsed(long l) {
        float f = (float)(System.currentTimeMillis() - l) / 1000.0f;
        logger.info("Took " + f + " seconds to load the model.");
    }

    public static Node loadModel(File file) throws Exception {
        return ModelLoader.loadModel(file.getName());
    }

    public static Node loadModel(String string) throws Exception {
        String string2 = ModelLoader.extensionOf(string);
        ModelLoaderCallable modelLoaderCallable = loaders.get(string2);
        if (modelLoaderCallable == null) {
            throw new UnsupportedOperationException("Unknown file type: " + string);
        }
        modelLoaderCallable.setFile(string);
        Future future = GameTaskQueueManager.getManager().update((Callable)modelLoaderCallable);
        return (Node)future.get();
    }

    private static String extensionOf(String string) {
        String string2 = string.toUpperCase();
        int n = string2.lastIndexOf(46);
        String string3 = n >= 0 ? string2.substring(n + 1) : "";
        return string3;
    }

    private static Node scale(Node node) {
        if (node != null) {
            node.updateGeometricState(0.0f, true);
            BoundingVolume boundingVolume = node.getWorldBound();
            if (boundingVolume == null) {
                node.setModelBound((BoundingVolume)new BoundingBox());
                node.updateModelBound();
                node.updateGeometricState(0.0f, true);
                boundingVolume = node.getWorldBound();
            }
            if (boundingVolume != null) {
                Vector3f vector3f = boundingVolume.getCenter();
                BoundingBox boundingBox = new BoundingBox(vector3f, 0.0f, 0.0f, 0.0f);
                boundingBox.mergeLocal(boundingVolume);
                Vector3f vector3f2 = boundingBox.getExtent(null);
                float f = Math.max(Math.max(vector3f2.x, vector3f2.y), vector3f2.z);
                if (f != 0.0f) {
                    Node node2 = new Node("scaled model");
                    node2.attachChild((Spatial)node);
                    node2.setLocalScale(5.0f / f);
                    node = node2;
                }
            }
        }
        return node;
    }

    public static boolean isValidModelFile(File file) {
        return ModelLoader.isValidModelFile(file.getName());
    }

    public static boolean isValidModelFile(String string) {
        return loaders.containsKey(ModelLoader.extensionOf(string));
    }

    static {
        loaders.put("DAE", new DAECallable());
        loaders.put("JME", new JMECallable());
        loaders.put("OBJ", new ModelLoaderCallable(new ObjToJme(), new String[]{"mtllib", "texdir"}));
        loaders.put("3DS", new ModelLoaderCallable(new MaxToJme(), new String[]{"texurl", "texdir"}));
        loaders.put("ASE", new ModelLoaderCallable(new AseToJme()));
        loaders.put("MD2", new ModelLoaderCallable(new Md2ToJme()));
        loaders.put("MD3", new ModelLoaderCallable(new Md3ToJme()));
        loaders.put("MS3D", new ModelLoaderCallable(new MilkToJme()));
        try {
            loaders.put("X3D", new ModelLoaderCallable(new X3dToJme()));
        }
        catch (InstantiationException instantiationException) {
            logger.logp(Level.SEVERE, ModelLoader.class.toString(), "<static>", "InstantiationException", instantiationException);
        }
    }

    private static class DAECallable
    extends ModelLoaderCallable {
        public DAECallable() {
            super(null, null);
        }

        public Node call() throws Exception {
            ColladaImporter.load((InputStream)this.getURL().openStream(), (String)"Model");
            Node node = ColladaImporter.getModel();
            return node;
        }
    }

    private static class JMECallable
    extends ModelLoaderCallable {
        public JMECallable() {
            super(null, null);
        }

        public Node call() throws Exception {
            return (Node)BinaryImporter.getInstance().load(this.getURL());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ModelLoaderCallable
    implements Callable<Node> {
        protected String file;
        protected String[] props;
        protected FormatConverter converter;

        public ModelLoaderCallable(FormatConverter formatConverter) {
            this(formatConverter, null);
        }

        public ModelLoaderCallable(FormatConverter formatConverter, String[] stringArray) {
            this.converter = formatConverter;
            this.setProperties(stringArray);
        }

        public void setProperties(String[] stringArray) {
            this.props = stringArray == null ? new String[]{} : stringArray;
        }

        public void setFile(String string) {
            this.file = string;
        }

        protected URL getURL() {
            return ResourceLocatorTool.locateResource((String)"model", (String)this.file);
        }

        @Override
        public Node call() throws Exception {
            if (this.converter == null) {
                return null;
            }
            URL uRL = this.getURL();
            for (int i = 0; i < this.props.length; ++i) {
                this.converter.setProperty(this.props[i], uRL);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.converter.convert(uRL.openStream(), byteArrayOutputStream);
            Savable savable = BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            if (savable instanceof Node) {
                return (Node)savable;
            }
            Node node = new Node("Imported Model " + this.file);
            node.attachChild((Spatial)savable);
            return node;
        }
    }
}

