/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.converters.maxutils;

import com.jmex.model.converters.maxutils.ChunkHeader;
import com.jmex.model.converters.maxutils.ChunkerClass;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

class FacesChunk
extends ChunkerClass {
    private static final Logger logger = Logger.getLogger(FacesChunk.class.getName());
    int nFaces;
    int[][] faces;
    int[] smoothingGroups;
    ArrayList<String> materialNames;
    ArrayList<int[]> materialIndexes;

    public FacesChunk(DataInput dataInput, ChunkHeader chunkHeader) throws IOException {
        super(dataInput, chunkHeader);
    }

    protected void initializeVariables() throws IOException {
        this.nFaces = this.myIn.readUnsignedShort();
        if (DEBUG || DEBUG_LIGHT) {
            logger.info("Reading faces #=" + this.nFaces);
        }
        this.faces = new int[this.nFaces][];
        this.smoothingGroups = new int[this.nFaces];
        this.materialNames = new ArrayList();
        this.materialIndexes = new ArrayList();
        for (int i = 0; i < this.nFaces; ++i) {
            this.faces[i] = new int[]{this.myIn.readUnsignedShort(), this.myIn.readUnsignedShort(), this.myIn.readUnsignedShort()};
            short s = this.myIn.readShort();
        }
        this.decrHeaderLen(2 + this.nFaces * 8);
    }

    protected boolean processChildChunk(ChunkHeader chunkHeader) throws IOException {
        switch (chunkHeader.type) {
            case 16720: {
                this.readSmoothing();
                return true;
            }
            case 16688: {
                this.readMeshMaterialGroup();
                return true;
            }
        }
        return false;
    }

    private void readMeshMaterialGroup() throws IOException {
        String string = this.readcStr();
        int n = this.myIn.readUnsignedShort();
        int[] nArray = new int[n];
        if (DEBUG || DEBUG_LIGHT) {
            logger.info("Material " + string + " is applied to " + n + " faces");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.myIn.readUnsignedShort();
        }
        this.materialIndexes.add(nArray);
        this.materialNames.add(string);
    }

    private void readSmoothing() throws IOException {
        for (int i = 0; i < this.nFaces; ++i) {
            this.smoothingGroups[i] = this.myIn.readInt();
        }
    }
}

