/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.videotools;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.SimpleCommandExecuter;
import jp.sourceforge.akjrcp.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.ui.param.ParamBoolean;
import jp.sourceforge.akjrcp.ui.param.ParamRadioGroup;
import jp.sourceforge.akjrcp.ui.param.ParamText;
import jp.sourceforge.akjrcp.ui.param.ParamTextArea;
import jp.sourceforge.akjrcp.util.ExecutingControler;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import jp.sourceforge.akjrcp.util.StatusBarUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class MplexViewer
extends ViewPart {
    public static Log log = LogFactory.getLog(MplexViewer.class);
    public static final String ID = MplexViewer.class.getName();
    private ParamBoolean vbr;
    private ParamRadioGroup format;
    private FileDirChoicer inputVideoFileChooser;
    private FileDirChoicer inputAudioFile1Chooser;
    private FileDirChoicer inputAudioFile2Chooser;
    private FileDirChoicer outputFileChooser;
    private MplexExecute mplexExecute;

    public void createPartControl(Composite parent) {
        this.mplexExecute = new MplexExecute();
        parent.setLayout((Layout)new GridLayout(1, false));
        FileSelected selectedListener = new FileSelected();
        this.inputVideoFileChooser = new FileDirChoicer(parent, 2048, 0, "video");
        this.inputVideoFileChooser.setLayoutData(new GridData(768));
        this.inputVideoFileChooser.addFileListChangeListener(selectedListener);
        this.inputVideoFileChooser.setFilterExtensions(new String[]{"*.m2v;*.m1v"});
        this.inputVideoFileChooser.addFileListChangeListener(new AudoFileSet());
        this.inputAudioFile1Chooser = new FileDirChoicer(parent, 2048, 0, "audio 1", true);
        this.inputAudioFile1Chooser.setLayoutData(new GridData(768));
        this.inputAudioFile1Chooser.addFileListChangeListener(selectedListener);
        this.inputAudioFile1Chooser.setFilterExtensions(new String[]{"*.mp2;*.m2a;*.ac3;*.lpcm"});
        this.inputAudioFile2Chooser = new FileDirChoicer(parent, 2048, 0, "audio 2", true);
        this.inputAudioFile2Chooser.setLayoutData(new GridData(768));
        this.inputAudioFile2Chooser.addFileListChangeListener(selectedListener);
        this.inputAudioFile2Chooser.setFilterExtensions(new String[]{"*.mp2;*.m2a;*.ac3;*.lpcm"});
        Composite s2 = this.createSplitComposite(parent, 1, false, new GridData(768));
        this.format = new ParamRadioGroup(s2, 0, "f", "format", new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}, new String[]{"Generic MPEG1(0)", "VCD(1)", "user-rate VCD(2)", "Generic MPEG2(3)", "SVCD(4)", "user-rate SVCD(5)", "CD Stills(6)", "SVCD Stills(7)", "DVD with NAV sectors(8)", " DVD(9)"}, 5);
        this.format.setValue("8");
        this.vbr = new ParamBoolean(s2, 0, "V", "vbr");
        this.outputFileChooser = new FileDirChoicer(parent, 2048, 2, "output");
        this.outputFileChooser.setLayoutData(new GridData(768));
        this.outputFileChooser.setFilterExtensions(new String[]{"*.vob"});
        this.outputFileChooser.addFileListChangeListener(selectedListener);
        this.mplexExecute.addControl((Control)this.inputVideoFileChooser);
        this.mplexExecute.addControl((Control)this.outputFileChooser);
        this.mplexExecute.addControl((Control)this.inputAudioFile1Chooser);
        this.mplexExecute.addControl((Control)this.inputAudioFile2Chooser);
        this.mplexExecute.addControl((Control)this.format);
        this.mplexExecute.addControl((Control)this.vbr);
        new ExecutingControler.ExecutingControlButton(parent, 0, this.mplexExecute, "Mux Video && Aduio", "Cancel");
    }

    public void setFocus() {
    }

    private Composite createSplitComposite(Composite parent, int split, boolean same, Object data) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(split, same));
        if (data != null) {
            composite.setLayoutData(data);
        }
        return composite;
    }

    private ParamTextArea createGridTextAreaGroup(Composite parent, String key, String label, Object data) {
        ParamTextArea text = new ParamTextArea(parent, 0, key, label, -1);
        text.setLayoutData(data);
        return text;
    }

    private ParamText createLabeldText(Composite parent, String key, String label, Object data) {
        ParamText text = new ParamText(parent, 0, key, label, 0);
        if (data != null) {
            text.setLayoutData(data);
        }
        return text;
    }

    public class AudoFileSet
    implements FileDirChoicer.FileStatusChangeListener {
        public void addList(FileDirChoicer.FileStatusChangeEvent event) {
            String path = event.getFilePath();
            if (!path.equals("")) {
                String[] extensions = new String[]{"ac3", "mp2", "m2a", "lpcm"};
                int i = 0;
                while (i < extensions.length) {
                    String audioPath = FileNameUtils.getChangedExtensionName(new File(path), extensions[i], true);
                    if (new File(audioPath).exists()) {
                        MplexViewer.this.inputAudioFile1Chooser.setFilePath(audioPath);
                        break;
                    }
                    ++i;
                }
                String exportPath = FileNameUtils.getChangedExtensionName(new File(path), "vob");
                if (!new File(exportPath).exists()) {
                    MplexViewer.this.outputFileChooser.setFilePath(exportPath);
                }
            }
            MplexViewer.this.mplexExecute.updateControlSwitch();
        }

        public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
        }
    }

    public class MplexExecute
    extends ExecutingControler {
        private String inputVideoFileChooser_value;
        private String inputAudioFile1Chooser_value;
        private String inputAudioFile2Chooser_value;
        private String outputFileChooser_value;
        private boolean vbr_value;
        private String format_value;

        public void afterExecute() {
        }

        public void beforeExecute() {
            this.vbr_value = MplexViewer.this.vbr.getBoolean();
            this.format_value = MplexViewer.this.format.getValue();
            this.inputVideoFileChooser_value = MplexViewer.this.inputVideoFileChooser.getAbsoluteFilePath();
            this.outputFileChooser_value = MplexViewer.this.outputFileChooser.getAbsoluteFilePath();
            this.inputAudioFile1Chooser_value = MplexViewer.this.inputAudioFile1Chooser.getAbsoluteFilePath();
            this.inputAudioFile2Chooser_value = MplexViewer.this.inputAudioFile2Chooser.getAbsoluteFilePath();
        }

        public boolean canExecute() {
            if (!MplexViewer.this.inputVideoFileChooser.getAbsoluteFilePath().equals("") && !MplexViewer.this.outputFileChooser.getAbsoluteFilePath().equals("")) {
                return !MplexViewer.this.inputAudioFile1Chooser.getAbsoluteFilePath().equals("") || !MplexViewer.this.inputAudioFile2Chooser.getAbsoluteFilePath().equals("");
            }
            return false;
        }

        public void cancelExecuting() {
        }

        public void inExecute() {
            String mplexPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("videotools.path_mplex");
            if (mplexPath.equals("")) {
                StatusBarUtils.showStatusBar("mplex.exe is not setted in VideoTools setting");
                return;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(mplexPath);
            list.add("-f");
            list.add(this.format_value);
            if (this.vbr_value) {
                list.add("-V");
            }
            list.add("-o");
            list.add(this.outputFileChooser_value);
            list.add(this.inputVideoFileChooser_value);
            if (!this.inputAudioFile1Chooser_value.equals("")) {
                list.add(this.inputAudioFile1Chooser_value);
            }
            if (!this.inputAudioFile2Chooser_value.equals("")) {
                list.add(this.inputAudioFile2Chooser_value);
            }
            String[] commands = list.toArray(new String[list.size()]);
            FFMpegUtils.toPrintCommand(commands);
            Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("####\n");
            Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(String.valueOf(FFMpegUtils.toPrintCommand(commands)) + "\n");
            SimpleCommandExecuter executer = new SimpleCommandExecuter(commands);
            executer.setPrinter(Akj_betasPlugin.getDefault().getProcessPrinter());
            executer.execute();
        }
    }

    public class FileSelected
    implements FileDirChoicer.FileStatusChangeListener {
        public void addList(FileDirChoicer.FileStatusChangeEvent event) {
            MplexViewer.this.mplexExecute.updateControlSwitch();
        }

        public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
            MplexViewer.this.mplexExecute.updateControlSwitch();
        }
    }
}

