/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util.directorybased;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import jp.sourceforge.akjrcp.potrace.FreehepUtils;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import jp.sourceforge.akjrcp.util.directorybased.DirectoryBasedCommand;
import jp.sourceforge.akjrcp.util.image.ImageUtils;

public class PostScriptToImageCommand
implements DirectoryBasedCommand {
    private File srcName;
    private File destName;
    private String imageType;
    private int width;
    private int height;
    BufferedImage bgImage;
    private float lineTransparent = 1.0f;
    private float imageTransparent = 1.0f;
    private int backgroundColor = 0xFFFFFF;
    private int blur = 1;

    public float getImageTransparent() {
        return this.imageTransparent;
    }

    public void setImageTransparent(float imageTransparent) {
        this.imageTransparent = imageTransparent;
    }

    public float getLineTransparent() {
        return this.lineTransparent;
    }

    public void setLineTransparent(float lineTransparent) {
        this.lineTransparent = lineTransparent;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public BufferedImage getImage() {
        return this.bgImage;
    }

    public void setImage(BufferedImage image) {
        this.bgImage = image;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public PostScriptToImageCommand(File srcName, File destName, String imageType) {
        this.srcName = srcName;
        this.destName = destName;
        this.imageType = imageType;
    }

    public int exec() throws IOException {
        if (this.srcName == null || this.destName == null) {
            return -1;
        }
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setBackground(new Color(this.backgroundColor));
        g2.clearRect(0, 0, this.width, this.height);
        if (this.bgImage != null) {
            g2.setComposite(AlphaComposite.getInstance(3, this.imageTransparent));
            if (this.blur > 1) {
                g2.drawImage((Image)ImageUtils.getBluredImage(this.bgImage, this.blur), -this.blur, -this.blur, null);
            } else {
                g2.drawImage((Image)this.bgImage, 0, 0, null);
            }
        }
        g2.setComposite(AlphaComposite.getInstance(3, this.lineTransparent));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        FreehepUtils.drawPostScript(g2, image.getWidth(), image.getHeight(), this.srcName);
        if (this.imageType.toLowerCase().equals("jpg") || this.imageType.toLowerCase().equals("jpeg")) {
            ImageUtils.writeJpegWithQuality(image, this.destName, 1.0f);
        } else {
            ImageIO.write((RenderedImage)image, this.imageType, this.destName);
        }
        return 0;
    }

    public Process getProcess() {
        return null;
    }

    public void setProcessPrinter(ProcessPrinter processPrinter) {
        try {
            processPrinter.printOutput("postscript to " + this.imageType + " from " + this.srcName + " to " + this.destName + "\r\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getBlur() {
        return this.blur;
    }

    public void setBlur(int blur) {
        this.blur = blur;
    }
}

