/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util.directorybased;

import java.io.IOException;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import jp.sourceforge.akjrcp.util.directorybased.DirectoryBasedCommand;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectoryBasedRuntimeCommand
implements DirectoryBasedCommand {
    public static Log log = LogFactory.getLog(DirectoryBasedRuntimeCommand.class);
    private String[] commandString;
    private String name;
    Process process;
    ProcessPrinter processPrinter;
    private long waitForCloseStream = 10000L;

    public DirectoryBasedRuntimeCommand(String name, String[] commands) {
        this.name = name;
        this.commandString = commands;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getCommandString() {
        return this.commandString;
    }

    public void setCommandString(String[] commandString) {
        this.commandString = commandString;
    }

    public int exec() throws IOException {
        if (this.processPrinter != null) {
            this.processPrinter.printOutput(String.valueOf(FFMpegUtils.toPrintCommand(this.getCommandString())) + "\r\n");
        }
        this.process = Runtime.getRuntime().exec(this.getCommandString());
        ProcessMonitor monitor = new ProcessMonitor(this.process, this.processPrinter);
        monitor.startMonitor();
        try {
            this.process.waitFor();
            long c = System.currentTimeMillis();
            while (System.currentTimeMillis() < c + this.waitForCloseStream) {
                if (!monitor.isErrorClosed() || !monitor.isInputClosed()) {
                    log.warn((Object)"wait:input reading");
                    Thread.sleep(100L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.process.exitValue();
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcessPrinter(ProcessPrinter processPrinter) {
        this.processPrinter = processPrinter;
    }
}

