/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.ui.URLBasedExecuterListener;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import jp.sourceforge.akjrcp.util.YoutubeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class YoutubeDLExecuter {
    public static Log log = LogFactory.getLog(YoutubeDLExecuter.class);
    private URLBasedExecuterListener executeListener;
    private String exportDir;
    private File exportFile;
    private Process process;
    private boolean cancelling;
    private File currentOutputFile;
    private boolean renameFile;
    private boolean insertMeta;
    private String youtubeDLPath;
    private String pythonPath;
    private int waitsecond = 15000;
    private static Pattern progressPattern = Pattern.compile("^Retrieving video data:\\s*(.*)%.*");
    private int result;
    private String user;
    private String password;

    public boolean isCancelling() {
        return this.cancelling;
    }

    public void setCancelling(boolean cancelling) {
        this.cancelling = cancelling;
    }

    public boolean isRenameFile() {
        return this.renameFile;
    }

    public void setRenameFile(boolean renameFile) {
        this.renameFile = renameFile;
    }

    public String getYoutubeDLPath() {
        return this.youtubeDLPath;
    }

    public void setYoutubeDLPath(String youtubeDLPath) {
        this.youtubeDLPath = youtubeDLPath;
    }

    public void execute(URL[] urls) {
        if (this.executeListener != null) {
            this.executeListener.beforeConvert();
        }
        int i = 0;
        while (i < urls.length) {
            this.execute(urls[i]);
            if (i != urls.length - 1) {
                try {
                    Thread.sleep(this.waitsecond);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (this.executeListener != null) {
            this.executeListener.afterConvert();
        }
    }

    private void execute(URL url) {
        if (this.cancelling) {
            log.info((Object)("cancel " + url));
            return;
        }
        this.inExecute(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        log.info((Object)"called cancel");
        YoutubeDLExecuter youtubeDLExecuter = this;
        synchronized (youtubeDLExecuter) {
            System.out.println("cancell:" + System.currentTimeMillis());
            this.cancelling = true;
        }
        if (this.process != null) {
            this.process.destroy();
            log.info((Object)("maybe destroyed:" + this.process));
        }
        if (this.currentOutputFile != null) {
            this.currentOutputFile.delete();
        }
    }

    public String[] toCommand(URL url) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.pythonPath != null) {
            list.add(this.pythonPath);
        }
        list.add(this.youtubeDLPath);
        String key = YoutubeUtils.getId(url);
        if (key == null) {
            log.info((Object)("key is null:" + url));
            return null;
        }
        if (this.exportDir == null) {
            log.info((Object)("export dir=null:" + url));
        }
        if (this.user != null && this.password != null) {
            list.add("-u");
            list.add(this.user);
            list.add("-p");
            list.add(this.password);
        }
        list.add("-o");
        if (this.exportFile != null) {
            list.add(this.exportFile.getAbsolutePath());
            this.currentOutputFile = this.exportFile;
        } else if (this.renameFile) {
            String title = YoutubeUtils.getTitle(url);
            if (title.equals("Broadcast Yourself")) {
                title = key;
            }
            String path = String.valueOf(this.exportDir) + "\\" + YoutubeUtils.fixFileName(title) + ".flv";
            this.currentOutputFile = new File(path);
            list.add(path);
        } else {
            String path = String.valueOf(this.exportDir) + "\\" + key + ".flv";
            this.currentOutputFile = new File(path);
            list.add(path);
        }
        String wwwUrl = YoutubeUtils.toWWWUrl(url.toString());
        log.info((Object)("wwwurl:" + wwwUrl));
        list.add(wwwUrl);
        return list.toArray(new String[list.size()]);
    }

    public static String toDebugArray(String[] array, String password) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = password != null && !password.equals("") && array[i].equals(password) ? String.valueOf(v) + "\"*****\" " : String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        return String.valueOf(v) + "\n";
    }

    private void inExecute(URL url) {
        block19: {
            if (this.cancelling) {
                log.info((Object)("cancel " + url));
                return;
            }
            try {
                String[] commands = this.toCommand(url);
                if (commands == null) {
                    log.warn((Object)"null command");
                    return;
                }
                if (this.executeListener != null) {
                    this.executeListener.startConvert(url);
                }
                Runtime runtime = Runtime.getRuntime();
                ErrorCatchProcessPrinter printer = new ErrorCatchProcessPrinter();
                try {
                    printer.printOutput(YoutubeDLExecuter.toDebugArray(commands, this.password));
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                log.info((Object)("start process:" + this.process + "," + YoutubeDLExecuter.toDebugArray(commands, this.password)));
                this.process = runtime.exec(commands);
                System.out.println("process:" + System.currentTimeMillis() + "," + this.cancelling);
                ProcessMonitor monitor = new ProcessMonitor(this.process, printer);
                monitor.startMonitor();
                try {
                    if (!this.cancelling) {
                        this.process.waitFor();
                        this.result = this.process.exitValue();
                        if (this.result != 0) {
                            if (this.result == 1) {
                                log.info((Object)("exit-value:" + this.result));
                            } else {
                                printer.printError("[error] " + this.result + "\n");
                                if (this.result == -1073741819) {
                                    log.warn((Object)("exit-value:" + this.result + "maybe memory error"));
                                } else {
                                    log.warn((Object)("exit-value:" + this.result));
                                }
                            }
                        }
                        break block19;
                    }
                    log.info((Object)("finally cancel " + url));
                    return;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                this.process.destroy();
                if (this.executeListener != null) {
                    this.executeListener.faildConvert(url, e1.getMessage());
                }
                return;
            }
        }
        if (this.executeListener != null) {
            if (this.result == 0) {
                this.executeListener.endConvert(url);
            } else {
                this.executeListener.faildConvert(url, "" + this.result);
            }
        }
        this.process = null;
    }

    public URLBasedExecuterListener getExecuteListener() {
        return this.executeListener;
    }

    public void setExecuteListener(URLBasedExecuterListener executeListener) {
        this.executeListener = executeListener;
    }

    public String getExportDir() {
        return this.exportDir;
    }

    public void setExportDir(String exportDir) {
        this.exportDir = exportDir;
    }

    public File getCurrentOutputFile() {
        return this.currentOutputFile;
    }

    public void setCurrentOutputFile(File currentOutputFile) {
        this.currentOutputFile = currentOutputFile;
    }

    public String getPythonPath() {
        return this.pythonPath;
    }

    public void setPythonPath(String pythonPath) {
        this.pythonPath = pythonPath;
    }

    public static boolean isProgressLine(String line) {
        return line.startsWith("Retrieving");
    }

    public static int getProgressPersent(String line) {
        Matcher matcher = progressPattern.matcher(line.replaceAll("\n", ""));
        if (matcher.matches()) {
            int value = (int)Double.parseDouble(matcher.group(1));
            return value;
        }
        System.out.println("not mutch");
        return 0;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public void setExportFile(File exportFile) {
        this.exportFile = exportFile;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public class TestMonitor
    implements DirectryBasedExecuterListener {
        public void beforeConvert() {
        }

        public void afterConvert() {
        }

        public void startConvert(File file) {
        }

        public void endConvert(File file) {
        }

        public void faildConvert(File file, String message) {
            System.out.println("faild:" + file);
        }

        public void printProcess(String line) {
        }

        public boolean askOverwrite(File output) {
            return false;
        }
    }

    public class ErrorCatchProcessPrinter
    implements ProcessPrinter {
        public void printOutput(String output) throws IOException {
            this.print(output);
        }

        public void printError(String error) throws IOException {
            this.print(error);
        }

        private void print(String line) throws IOException {
            if (YoutubeDLExecuter.this.executeListener != null) {
                YoutubeDLExecuter.this.executeListener.printProcess(line);
            }
            log.debug((Object)line);
        }
    }
}

