/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import java.io.File;
import java.util.List;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFileInfomation;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegInput;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.ui.GenericParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericParametersFFMpegPreference
extends FFMpegPreference {
    public static Log log = LogFactory.getLog(GenericParametersFFMpegPreference.class);
    public static final String EXTENSION = "EXTENSION";
    public static final String TWO_PASS_ENCODE = "TWO_PASS_ENCODE";
    public static final String MAX_FRAME_RATE = "MAX_FRAME_RATE";
    public static final String AFTER_ACTION = "AFTER_ACTION";
    public static final String[] SYSTEM_KEYS = new String[]{"EXTENSION", "TWO_PASS_ENCODE", "MAX_FRAME_RATE", "AFTER_ACTION"};
    private GenericParameters genericParameters;

    public GenericParametersFFMpegPreference(GenericParameters setting) {
        this.setGenericParameters(setting);
        this.setFormat(setting.getParameters().get("f"));
        this.setVideoCodec(setting.getParameters().get("vcodec"));
        this.setAudioCodec(setting.getParameters().get("acodec"));
        this.setExtension(setting.getParameters().get(EXTENSION));
        if (setting.getParameters().get("vn") != null) {
            this.setEnableVideo(false);
        }
        if (setting.getParameters().get("an") != null) {
            this.setEnableAudio(false);
        }
    }

    public void addLastOptions(FFMpegInput[] input, List params) {
        if (this.genericParameters != null) {
            String maxValue = this.genericParameters.getParameters().get(MAX_FRAME_RATE);
            String rate = this.genericParameters.getParameters().get("r");
            if (maxValue != null && rate == null) {
                double maxFrameRate = Double.parseDouble(maxValue);
                FFMpegFileInfomation info = GenericParametersFFMpegPreference.getVideoInfomation(this.getFfmpegPath(), input);
                if (info != null) {
                    if (info.getVideoRate() > 0.0) {
                        log.warn((Object)("rate:" + maxFrameRate + "," + info.getVideoRate()));
                        double r = Math.min(maxFrameRate, info.getVideoRate());
                        log.info((Object)("maxrate:set rate " + r));
                        this.genericParameters.getParameters().put("r", "" + r);
                    } else {
                        log.warn((Object)"video rate is 0 and cant set maxframerate");
                        System.out.println(info.getText());
                    }
                } else {
                    log.warn((Object)"info null and cant set maxframerate");
                }
            }
            String[] args = this.genericParameters.toArgParams();
            String tmpSize = null;
            int i = 0;
            while (i < args.length) {
                boolean skip = false;
                if (args[i].equals("-f") && this.getFormat() != null && this.getFormat().equals(args[i + 1])) {
                    ++i;
                    skip = true;
                }
                if (this.getGeneration() == 2) {
                    if (args[i].equals("-acodec")) {
                        args[i + 1] = GenericParametersFFMpegPreference.toSuiteAudioCodec(args[i + 1], this.getGeneration());
                    }
                    if (args[i].equals("-vcodec")) {
                        args[i + 1] = GenericParametersFFMpegPreference.toSuiteVideoCodec(args[i + 1], this.getGeneration());
                    }
                }
                if (args[i].equals("-s")) {
                    tmpSize = args[i + 1];
                    ++i;
                    skip = true;
                }
                if (!skip) {
                    params.add(args[i]);
                }
                ++i;
            }
            if (tmpSize != null) {
                params.add("-s");
                params.add(tmpSize);
            }
        } else {
            log.warn((Object)"genericParameters=null");
        }
    }

    public static FFMpegFileInfomation getVideoInfomation(String ffmpegPath, FFMpegInput[] inputs) {
        int i = inputs.length - 1;
        while (i >= 0) {
            FLVInfomation info = new FFMpegFLVParser(ffmpegPath).parseFile(new File(inputs[i].getPath()));
            if (info != null && info.isHaveVideo()) {
                return info;
            }
            --i;
        }
        return null;
    }

    public GenericParameters getGenericParameters() {
        return this.genericParameters;
    }

    public void setGenericParameters(GenericParameters genericParameters) {
        this.genericParameters = genericParameters;
    }

    public boolean isTwoPassEncode() {
        if (this.genericParameters != null) {
            String twopass = this.genericParameters.getParameters().get(TWO_PASS_ENCODE);
            return twopass != null;
        }
        log.info((Object)"twopass is not in map");
        return super.isTwoPassEncode();
    }

    public String getExtension() {
        String ext;
        if (this.genericParameters != null && (ext = this.genericParameters.getParameters().get(EXTENSION)) != null) {
            return ext;
        }
        log.info((Object)"extension is not in map");
        return super.getExtension();
    }

    public int getGuessVideoBitrate(FFMpegFileInfomation info) {
        int ret;
        block7: {
            ret = 0;
            String bValue = this.genericParameters.getParameters().get("b");
            if (bValue != null) {
                try {
                    if (bValue.toLowerCase().endsWith("k")) {
                        ret = (int)Double.parseDouble(bValue.substring(0, bValue.length() - 1));
                        break block7;
                    }
                    if (bValue.toLowerCase().endsWith("m")) {
                        ret = (int)Double.parseDouble(bValue.substring(0, bValue.length() - 1)) * 1024;
                        break block7;
                    }
                    ret = (int)Double.parseDouble(bValue) / 1024;
                }
                catch (Exception exception) {
                    log.warn((Object)("wrong b or br:" + bValue));
                }
            } else if (info != null) {
                ret = info.getVideoBitrate();
            }
        }
        return ret;
    }

    public int getGuessAudioBitrate(FFMpegFileInfomation info) {
        int ret;
        block7: {
            ret = 0;
            String bValue = this.genericParameters.getParameters().get("ab");
            if (bValue != null) {
                try {
                    if (bValue.toLowerCase().endsWith("k")) {
                        ret = (int)Double.parseDouble(bValue.substring(0, bValue.length() - 1));
                        break block7;
                    }
                    if (bValue.toLowerCase().endsWith("m")) {
                        ret = (int)Double.parseDouble(bValue.substring(0, bValue.length() - 1)) * 1024;
                        break block7;
                    }
                    ret = (int)Double.parseDouble(bValue) / 1024;
                }
                catch (Exception exception) {
                    log.warn((Object)("wrong b or br:" + bValue));
                }
            } else if (info != null) {
                ret = info.getAudioBitrate();
            }
        }
        return ret;
    }
}

