/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import java.io.File;
import jp.sourceforge.akjrcp.ui.Messages;

public abstract class AbstractBasicFileApplication {
    private boolean needSave;
    private File file;
    private String fileExtension;
    protected String defaultFileName = Messages.getString("noname");
    protected String headFileSaveMessage = Messages.getString("file");
    protected String tailFileSaveMessage = Messages.getString("isnt_saved_are_you");
    protected String fileSaveTitle = Messages.getString("confirm_filesave");
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String defaultExtension) {
        this.fileExtension = defaultExtension;
    }

    public String fixFileExtension(String path) {
        if (this.getFileExtension() == null) {
            return path;
        }
        if (path.toLowerCase().endsWith("." + this.getFileExtension().toLowerCase())) {
            return path;
        }
        return String.valueOf(path) + "." + this.getFileExtension();
    }

    public String getDefaultFileName() {
        return this.defaultFileName;
    }

    public void setDefaultFileName(String defaultFileName) {
        this.defaultFileName = defaultFileName;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileSaveTitle() {
        return this.fileSaveTitle;
    }

    public void setFileSaveTitle(String fileSaveTitle) {
        this.fileSaveTitle = fileSaveTitle;
    }

    public String getHeadFileSaveMessage() {
        return this.headFileSaveMessage;
    }

    public void setHeadFileSaveMessage(String headFileSaveMessage) {
        this.headFileSaveMessage = headFileSaveMessage;
    }

    public String getTailFileSaveMessage() {
        return this.tailFileSaveMessage;
    }

    public void setTailFileSaveMessage(String tailFileSaveMessage) {
        this.tailFileSaveMessage = tailFileSaveMessage;
    }

    public boolean isNeedSave() {
        return this.needSave;
    }

    public void setNeedSave(boolean bool) {
        boolean old = this.needSave;
        this.needSave = bool;
        if (this.needSave != old) {
            this.saveStatusChanged();
        }
    }

    public void openFile(File currentFile) {
        int result;
        if (this.isNeedSave() && ((result = this.askSave()) == 0 ? !this.saveFile() : result == 2)) {
            return;
        }
        if (currentFile != null) {
            if (this.isStandardFile(currentFile)) {
                this.file = currentFile;
                this.execOpen();
                this.needSave = false;
            } else {
                this.execOpenSubFile(currentFile);
            }
            if (this.file != null) {
                this.needSave = false;
            }
        }
        this.saveStatusChanged();
    }

    public void openFile() {
        int result;
        if (this.isNeedSave() && ((result = this.askSave()) == 0 ? !this.saveFile() : result == 2)) {
            return;
        }
        File currentFile = this.execChooseOpenFile();
        if (currentFile != null) {
            if (this.isStandardFile(currentFile)) {
                this.file = currentFile;
                this.execOpen();
                this.needSave = false;
            } else {
                this.execOpenSubFile(currentFile);
            }
            if (this.file != null) {
                this.needSave = false;
            }
        }
        this.saveStatusChanged();
    }

    protected void execOpenSubFile(File file) {
    }

    protected boolean isStandardFile(File file) {
        return true;
    }

    protected abstract void execOpen();

    protected abstract File execChooseOpenFile();

    protected abstract void execSave();

    protected abstract void saveStatusChanged();

    protected abstract File execChooseSaveFile();

    public String getFileName() {
        if (this.file == null) {
            return this.defaultFileName;
        }
        return this.file.getName();
    }

    public int askSave() {
        return this.executeAskSave(this.fileSaveTitle, String.valueOf(this.headFileSaveMessage) + this.getFileName() + this.tailFileSaveMessage);
    }

    protected abstract int executeAskSave(String var1, String var2);

    public boolean saveFile() {
        if (this.file == null) {
            this.file = this.execChooseSaveFile();
        }
        if (this.file != null) {
            this.execSave();
            this.needSave = false;
            this.saveStatusChanged();
            return true;
        }
        return false;
    }

    public boolean saveAsFile() {
        File tmpFile = this.execChooseSaveFile();
        if (tmpFile != null) {
            this.file = tmpFile;
            this.execSave();
            this.needSave = false;
            this.saveStatusChanged();
            return true;
        }
        return false;
    }

    public void newFile() {
        int result;
        if (this.isNeedSave() && ((result = this.askSave()) == 0 ? !this.saveFile() : result == 2)) {
            return;
        }
        this.execNew();
        this.file = null;
        this.needSave = false;
        this.saveStatusChanged();
    }

    protected abstract void execNew();

    protected abstract void execExit();
}

