/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.subtitle;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class TimeSpinner
extends Composite {
    private Spinner hourSpinner;
    private Spinner minuteSpinner;
    private Spinner secondSpinner;
    private Spinner millisecondSpinner;

    public TimeSpinner(Composite arg0, int arg1) {
        super(arg0, arg1);
        this.setLayout((Layout)new GridLayout(7, false));
        this.hourSpinner = new Spinner((Composite)this, 0);
        this.hourSpinner.setSelection(0);
        this.hourSpinner.setMaximum(999);
        Label label = new Label((Composite)this, 0);
        label.setText(":");
        label.setToolTipText("hour");
        this.minuteSpinner = new Spinner((Composite)this, 0);
        this.minuteSpinner.setSelection(0);
        this.minuteSpinner.setMaximum(60);
        Label label2 = new Label((Composite)this, 0);
        label2.setText(":");
        label2.setToolTipText("minute");
        this.secondSpinner = new Spinner((Composite)this, 0);
        this.secondSpinner.setSelection(0);
        this.secondSpinner.setMaximum(60);
        Label label3 = new Label((Composite)this, 0);
        label3.setText(".");
        label3.setToolTipText("second");
        this.millisecondSpinner = new Spinner((Composite)this, 0);
        this.millisecondSpinner.setSelection(0);
        this.millisecondSpinner.setMaximum(1000);
        SpinnerModified spinnerModified = new SpinnerModified();
        this.hourSpinner.addModifyListener((ModifyListener)spinnerModified);
        this.minuteSpinner.addModifyListener((ModifyListener)spinnerModified);
        this.secondSpinner.addModifyListener((ModifyListener)spinnerModified);
        this.millisecondSpinner.addModifyListener((ModifyListener)spinnerModified);
    }

    public void init() {
        this.hourSpinner.setSelection(0);
        this.minuteSpinner.setSelection(0);
        this.secondSpinner.setSelection(0);
        this.millisecondSpinner.setSelection(0);
    }

    public void setTime(long millisecond) {
        long hour_millisecond = 3600000L;
        int minute_millisecond = 60000;
        int second_millisecond = 1000;
        int hour = (int)(millisecond / hour_millisecond);
        long remain = millisecond % hour_millisecond;
        int minute = (int)(remain / (long)minute_millisecond);
        int second = (int)((remain %= (long)minute_millisecond) / (long)second_millisecond);
        this.hourSpinner.setSelection(hour);
        this.minuteSpinner.setSelection(minute);
        this.secondSpinner.setSelection(second);
        this.millisecondSpinner.setSelection((int)(remain %= (long)second_millisecond));
    }

    public long getTime() {
        long result = this.millisecondSpinner.getSelection();
        result += (long)(this.secondSpinner.getSelection() * 1000);
        result += (long)(this.minuteSpinner.getSelection() * 60 * 1000);
        return result += (long)(this.hourSpinner.getSelection() * 60 * 60 * 1000);
    }

    public class SpinnerModified
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            Spinner spinner = (Spinner)e.getSource();
            if (spinner != TimeSpinner.this.hourSpinner) {
                if (spinner == TimeSpinner.this.minuteSpinner) {
                    if (spinner.getSelection() == 60) {
                        spinner.setSelection(0);
                        TimeSpinner.this.hourSpinner.setSelection(TimeSpinner.this.hourSpinner.getSelection() + 1);
                    }
                } else if (spinner == TimeSpinner.this.secondSpinner) {
                    if (spinner.getSelection() == 60) {
                        spinner.setSelection(0);
                        TimeSpinner.this.minuteSpinner.setSelection(TimeSpinner.this.minuteSpinner.getSelection() + 1);
                    }
                } else if (spinner == TimeSpinner.this.millisecondSpinner && spinner.getSelection() == 1000) {
                    spinner.setSelection(0);
                    TimeSpinner.this.secondSpinner.setSelection(TimeSpinner.this.secondSpinner.getSelection() + 1);
                }
            }
        }
    }
}

