/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.snack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.snack.AbstractParser;
import jp.sourceforge.akjrcp.snack.Formant;
import jp.sourceforge.akjrcp.snack.SmallFormant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormantParser
extends AbstractParser {
    public static Log log = LogFactory.getLog(FormantParser.class);
    private String columnSeparator = ",";

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public static void normalize(SmallFormant[] formants, int size) {
        SmallFormant[] replace = new SmallFormant[formants.length];
        int j = 0;
        while (j < formants.length) {
            int f1 = 0;
            int f2 = 0;
            int f3 = 0;
            int f4 = 0;
            int index = 0;
            int i = -size;
            while (i <= size) {
                if (j + i >= 0 && j + i < formants.length) {
                    f1 = (short)(f1 + formants[j + i].getF1());
                    f2 = (short)(f2 + formants[j + i].getF2());
                    f3 = (short)(f3 + formants[j + i].getF3());
                    f4 = (short)(f4 + formants[j + i].getF4());
                    ++index;
                }
                ++i;
            }
            replace[j] = new SmallFormant();
            replace[j].setF1(f1 / index);
            replace[j].setF2(f2 / index);
            replace[j].setF3(f3 / index);
            replace[j].setF4(f4 / index);
            ++j;
        }
        log.trace((Object)("normalized:" + formants.length));
        System.arraycopy(replace, 0, formants, 0, formants.length);
    }

    public static void normalize(Formant[] formants, int size) {
        Formant[] replace = new Formant[formants.length];
        int j = 0;
        while (j < formants.length) {
            double f1 = 0.0;
            double f2 = 0.0;
            double f3 = 0.0;
            double f4 = 0.0;
            double b1 = 0.0;
            double b2 = 0.0;
            double b3 = 0.0;
            double b4 = 0.0;
            int index = 0;
            int i = -size;
            while (i <= size) {
                if (j + i >= 0 && j + i < formants.length) {
                    f1 += formants[j + i].getF1();
                    f2 += formants[j + i].getF2();
                    f3 += formants[j + i].getF3();
                    f4 += formants[j + i].getF4();
                    b1 += formants[j + i].getB1();
                    b2 += formants[j + i].getB2();
                    b3 += formants[j + i].getB3();
                    b4 += formants[j + i].getB4();
                    ++index;
                }
                ++i;
            }
            replace[j] = new Formant();
            replace[j].setF1(f1 / (double)index);
            replace[j].setF2(f2 / (double)index);
            replace[j].setF3(f3 / (double)index);
            replace[j].setF4(f4 / (double)index);
            replace[j].setB1(b1 / (double)index);
            replace[j].setB2(b2 / (double)index);
            replace[j].setB3(b3 / (double)index);
            replace[j].setB4(b4 / (double)index);
            ++j;
        }
        System.arraycopy(replace, 0, formants, 0, formants.length);
        replace = null;
    }

    public Object parse(Reader reader) throws IOException {
        String line;
        ArrayList<Formant> result = new ArrayList<Formant>();
        BufferedReader breader = new BufferedReader(reader);
        while ((line = breader.readLine()) != null) {
            String[] values = null;
            values = line.startsWith("(") && line.endsWith(")") ? line.substring(1, line.length() - 1).split(",") : line.split(this.columnSeparator);
            if (values == null || values.length != 8) continue;
            Formant formant = new Formant();
            formant.setF1(Double.parseDouble(values[0]));
            formant.setF2(Double.parseDouble(values[1]));
            formant.setF3(Double.parseDouble(values[2]));
            formant.setF4(Double.parseDouble(values[3]));
            formant.setB1(Double.parseDouble(values[4]));
            formant.setB2(Double.parseDouble(values[5]));
            formant.setB3(Double.parseDouble(values[6]));
            formant.setB4(Double.parseDouble(values[7]));
            result.add(formant);
        }
        breader.close();
        return result.toArray(new Formant[result.size()]);
    }
}

