/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.psp;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegGenericParameters;
import jp.sourceforge.akjrcp.psp.PSPMovieSetting;
import jp.sourceforge.akjrcp.psp.PSPMovieSettingTableViewer;
import jp.sourceforge.akjrcp.ui.GenericParameters;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class PSPMovieSettingEditor
extends FieldEditor {
    private Button upButton;
    private Button downButton;
    private Button topButton;
    private Button bottomButton;
    private Button exportButton;
    private PSPMovieSettingTableViewer table;
    private Label label;
    private Composite menus;

    public PSPMovieSettingEditor(String key, String description, Composite parent) {
        super(key, description, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    private Table getTable(Composite parent) {
        if (this.table == null) {
            this.table = new PSPMovieSettingTableViewer(parent);
        }
        return this.table.getTable();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label label = this.getLabel(parent);
        GridData ld = new GridData();
        ld.horizontalSpan = numColumns;
        label.setLayoutData((Object)ld);
        Composite fill = new Composite(parent, 0);
        GridData gd1 = new GridData(768);
        gd1.horizontalSpan = numColumns;
        fill.setLayoutData((Object)gd1);
        fill.setLayout((Layout)new GridLayout(2, false));
        FixComposite composite = new FixComposite(fill, 0);
        composite.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(768);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData(gd);
        this.getTable(composite);
        Composite menus = this.getMenus(fill);
        menus.setLayoutData((Object)new GridData());
    }

    private Label getLabel(Composite parent) {
        if (this.label == null) {
            this.label = new Label(parent, 0);
            this.label.setText(this.getLabelText());
        }
        return this.label;
    }

    private Composite getMenus(Composite parent) {
        if (this.menus == null) {
            this.menus = new Composite(parent, 0);
            this.menus.setLayout((Layout)new GridLayout());
            this.topButton = this.createButton(this.menus, Messages.getString("pspmoviesetting.top"));
            this.upButton = this.createButton(this.menus, Messages.getString("pspmoviesetting.up"));
            this.downButton = this.createButton(this.menus, Messages.getString("pspmoviesetting.down"));
            this.bottomButton = this.createButton(this.menus, Messages.getString("pspmoviesetting.bottom"));
            this.exportButton = this.createButton(this.menus, Messages.getString("export"));
        }
        return this.menus;
    }

    public Button createButton(Composite p, String label) {
        Button bt = new Button(p, 0);
        bt.setText(label);
        bt.addSelectionListener((SelectionListener)new ButtonSelect());
        bt.setLayoutData((Object)new GridData());
        return bt;
    }

    protected void doLoad() {
        PSPMovieSetting[] settings = PSPMovieSettingTableViewer.toPSPMovieSettings(this.getPreferenceStore().getString(this.getPreferenceName()));
        int i = 0;
        while (i < settings.length) {
            this.table.getMovieSettingList().add(settings[i]);
            ++i;
        }
        this.table.refresh();
    }

    protected void doLoadDefault() {
    }

    private void saveStore() {
        this.setPresentsDefaultValue(false);
        PSPMovieSetting[] infos = this.table.getMovieSettingList().toArray(new PSPMovieSetting[0]);
        this.getPreferenceStore().setValue(this.getPreferenceName(), PSPMovieSettingEditor.toStoreString(infos));
    }

    public static String toGenericStoreString(PSPMovieSetting[] settings) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < settings.length) {
            FFMpegGenericParameters parameters = new FFMpegGenericParameters();
            parameters.setName("PSP " + settings[i].getComment());
            if (settings[i].getVideoCodec() == 0) {
                parameters.setVideoCodec("xvid");
            } else {
                parameters.setVideoCodec("h264");
            }
            parameters.set("MAX_FRAME_RATE", "30");
            parameters.setExtension("mp4");
            parameters.setFormat("psp");
            parameters.setAudioCodec("aac");
            parameters.setFlags(new String[]{"bitexact"});
            parameters.setCoder("1");
            parameters.setVideoSize(settings[i].getWidth(), settings[i].getHeight());
            parameters.setVideoBitrate(settings[i].getVideoBitrate());
            parameters.setAudioBitrate(settings[i].getAudioBitrate());
            parameters.setAudioChannel(settings[i].getAudioChannel());
            parameters.setAudioRate(settings[i].getAudioRate());
            if (settings[i].getVideoCodec() == 1) {
                parameters.setLevel(21);
            } else {
                parameters.setVtag("mp4v");
            }
            if (settings[i].getVideoSize().equals("368x272")) {
                parameters.setLevel(30);
            } else if (settings[i].getVideoSize().equals("720x480")) {
                parameters.setLevel(30);
            } else if (settings[i].getVideoSize().equals("480x272")) {
                parameters.setLevel(30);
            } else if (settings[i].getVideoSize().equals("352x480")) {
                parameters.setLevel(30);
            }
            if (settings[i].getVideoCodec() == 1) {
                if (settings[i].getVideoBitrate() >= 768 && settings[i].getVideoBitrate() < 1536) {
                    parameters.setMaxRate(4000);
                    parameters.setBufSize(4000);
                } else if (settings[i].getVideoBitrate() >= 1536) {
                    parameters.setMaxRate(10000);
                    parameters.setBufSize(10000);
                }
            }
            if (settings[i].isHighQuality()) {
                parameters.set("refs", "3");
                parameters.set("loop", "1");
                parameters.set("deblockalpha", "0");
                parameters.set("deblockbeta", "0");
                parameters.set("partitions", "partp8x8+partb8x8");
                parameters.set("me", "umh");
                parameters.set("subq", "6");
                parameters.set("brdo", "1");
                parameters.set("me_range", "21");
                parameters.set("chroma", "1");
                parameters.set("slice", "2");
                parameters.set("g", "250");
                parameters.set("keyint_min", "25");
                parameters.set("sc_threshold", "40");
                parameters.set("rc_eq", "blurCplx^(1-qComp)");
                parameters.set("qcomp", "0.60");
                parameters.set("qmin", "7");
                parameters.set("qmax", "35");
            }
            buffer.append(String.valueOf(GenericParameters.parametersToCsv(parameters)) + "\r\n");
            ++i;
        }
        return buffer.toString();
    }

    public static String toStoreString(PSPMovieSetting[] settings) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < settings.length) {
            buffer.append(String.valueOf(PSPMovieSettingTableViewer.toStoreString(settings[i])) + "\n");
            ++i;
        }
        return buffer.toString();
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 2;
    }

    public class FixComposite
    extends Composite {
        public FixComposite(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return new Point(480, 300);
        }
    }

    public class ButtonSelect
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            int index = PSPMovieSettingEditor.this.table.getTable().getSelectionIndex();
            if (e.widget == PSPMovieSettingEditor.this.topButton) {
                PSPMovieSetting setting = (PSPMovieSetting)PSPMovieSettingEditor.this.table.getMovieSettingList().get(index);
                PSPMovieSettingEditor.this.table.getMovieSettingList().remove(setting);
                PSPMovieSettingEditor.this.table.getMovieSettingList().add(0, setting);
                PSPMovieSettingEditor.this.table.refresh();
            } else if (e.widget == PSPMovieSettingEditor.this.upButton) {
                PSPMovieSetting setting = (PSPMovieSetting)PSPMovieSettingEditor.this.table.getMovieSettingList().get(index);
                PSPMovieSettingEditor.this.table.getMovieSettingList().remove(setting);
                PSPMovieSettingEditor.this.table.getMovieSettingList().add(Math.max(0, index - 1), setting);
                PSPMovieSettingEditor.this.table.refresh();
            } else if (e.widget == PSPMovieSettingEditor.this.downButton) {
                PSPMovieSetting setting = (PSPMovieSetting)PSPMovieSettingEditor.this.table.getMovieSettingList().get(index);
                PSPMovieSettingEditor.this.table.getMovieSettingList().remove(setting);
                PSPMovieSettingEditor.this.table.getMovieSettingList().add(Math.min(PSPMovieSettingEditor.this.table.getMovieSettingList().size(), index + 1), setting);
                PSPMovieSettingEditor.this.table.refresh();
            } else if (e.widget == PSPMovieSettingEditor.this.bottomButton) {
                PSPMovieSetting setting = (PSPMovieSetting)PSPMovieSettingEditor.this.table.getMovieSettingList().get(index);
                PSPMovieSettingEditor.this.table.getMovieSettingList().remove(setting);
                PSPMovieSettingEditor.this.table.getMovieSettingList().add(PSPMovieSettingEditor.this.table.getMovieSettingList().size(), setting);
                PSPMovieSettingEditor.this.table.refresh();
            } else if (e.widget == PSPMovieSettingEditor.this.exportButton) {
                PSPMovieSetting[] settings = PSPMovieSettingEditor.this.table.getMovieSettingList().toArray(new PSPMovieSetting[0]);
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.csv"});
                String path = dialog.open();
                if (path != null) {
                    String text = PSPMovieSettingEditor.toGenericStoreString(settings);
                    try {
                        FileUtils.writeStringToFile((File)new File(path), (String)text);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            PSPMovieSettingEditor.this.saveStore();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

