/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.audiotools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.audiotools.SubtitleDialog;
import jp.sourceforge.akjrcp.audiotools.WaveFormFigureCanvasAudioPlayer;
import jp.sourceforge.akjrcp.audiotools.spectrogram.SpectrogramListFigure;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegCommandUtil;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.SimpleCommandExecuter;
import jp.sourceforge.akjrcp.snack.ESPS;
import jp.sourceforge.akjrcp.snack.Formant;
import jp.sourceforge.akjrcp.snack.FormantExecuter;
import jp.sourceforge.akjrcp.snack.FormantFigure;
import jp.sourceforge.akjrcp.snack.PitchExecuter;
import jp.sourceforge.akjrcp.snack.PitchViewFigure;
import jp.sourceforge.akjrcp.snack.SmallFormant;
import jp.sourceforge.akjrcp.snack.SpectrogramExecuter;
import jp.sourceforge.akjrcp.snack.SpectrogramListener;
import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import jp.sourceforge.akjrcp.subtitle.SubUtils;
import jp.sourceforge.akjrcp.subtitle.srt.SRTList;
import jp.sourceforge.akjrcp.subtitle.srt.SRTParser;
import jp.sourceforge.akjrcp.ui.LayoutBuilder;
import jp.sourceforge.akjrcp.ui.ProgressMonitor;
import jp.sourceforge.akjrcp.ui.WidgetBuilder;
import jp.sourceforge.akjrcp.ui.draw2d.FileImageCache;
import jp.sourceforge.akjrcp.ui.draw2d.SubtitleListFigure;
import jp.sourceforge.akjrcp.ui.draw2d.WaveFormFigureCanvas;
import jp.sourceforge.akjrcp.util.ClipboardUtil;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import jp.sourceforge.akjrcp.util.JapaneseUtils;
import jp.sourceforge.akjrcp.util.ProgressMonitorUtils;
import jp.sourceforge.akjrcp.util.StatusBarUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.util.StatusLineContributionItem;
import org.eclipse.ui.part.ViewPart;
import org.jpn.xucker.commons.audio.AudioProgressListener;
import org.jpn.xucker.commons.audio.WaveUtils;

public class WaveFormViewer
extends ViewPart {
    public static Log log = LogFactory.getLog(WaveFormViewer.class);
    public static final String ID = WaveFormViewer.class.getName();
    public WaveFormFigureCanvas waveInfoCanvas;
    private double splitFrame = 0.001;
    private FormantFigure formantFigure;
    private WaveFormFigureCanvasAudioPlayer waveFormFigureCanvasAudioPlayer;
    private boolean opening;
    private StandardSubObject lastSubtitle;
    private long lastSelectSubTime;
    private StatusLineContributionItem fileInfo;
    private Button decrese_leftButton;
    private Button decrese_rightButton;
    private Button move_leftButton;
    private Button move_rightButton;
    private boolean subtitleModified = false;
    public static WaveFormViewer self;
    MenuControler popUpMenuControler;
    private String subtitlePath = null;
    IProgressMonitor monitor;
    private boolean cancelOpenFile;
    private File audioFile;
    int imageWidth = 80;
    int imageHeight = 512;
    int howManyImagesMakePer1sec = 2;
    private int minPitch = 60;
    private int maxPitch = 1000;
    private double pitchTime = 0.015625;
    private PitchViewFigure pitchViewFigure;
    private SpectrogramListFigure spectrogramListFigure;
    private FileImageCache imageCache;
    private Label zoomLabel;
    private SubtitleListFigure srtFigure;
    private PitchExecuter pitchExecuter;
    private SpectrogramExecuter spectrogramExecuter;
    private FormantExecuter formantExecuter;
    private Button openWavButton;
    private Button newSrtButton;
    private Button editSrtButton;
    private Button deleteSrtButton;
    private Text srtText;
    private StatusLineContributionItem selectionInfo;
    private Group srtPanel;
    private Button expand_rightButton;
    private Button expand_leftButton;
    private Button saveSrt;
    private PitchViewFigure.PitchMemoryFigure pitchMemoryFigure;

    public void zoomUp() {
        this.waveInfoCanvas.zoomUp();
        this.syncZoom();
    }

    public void zoomDown() {
        this.waveInfoCanvas.zoomDown();
        this.syncZoom();
    }

    public void syncZoom() {
        this.zoomLabel.setText("x " + this.waveInfoCanvas.getZoom());
        this.srtFigure.setScale(this.waveInfoCanvas.getZoom(), 1.0);
        this.pitchViewFigure.setScale(this.waveInfoCanvas.getZoom(), 1.0);
        int totalsizelof1sec = this.imageWidth * this.howManyImagesMakePer1sec;
        double pixelSecond = 1.0 / (double)totalsizelof1sec;
        double baseZoom = pixelSecond / this.splitFrame;
        this.spectrogramListFigure.setZoom(baseZoom * this.waveInfoCanvas.getZoom(), 1.0);
        this.formantFigure.setWzoom(this.spectrogramListFigure.getWzoom());
        this.waveInfoCanvas.redraw();
    }

    protected void subtitleMix() {
        WaveFormFigureCanvas.TimeSelection select = this.waveInfoCanvas.getSelection();
        Object[] subs = this.srtFigure.containSubtitles(select);
        Arrays.sort(subs);
        long min = 0L;
        long max = 0L;
        String text = "";
        int i = 0;
        while (i < subs.length) {
            if (i == 0) {
                min = subs[i].getStartTime();
                max = subs[i].getEndTime();
            } else {
                min = Math.min(min, subs[i].getStartTime());
                max = Math.max(max, subs[i].getEndTime());
            }
            text = String.valueOf(text) + subs[i].getText();
            this.srtFigure.getStandardSubObjectList().remove(subs[i]);
            ++i;
        }
        StandardSubObject mixed = new StandardSubObject();
        mixed.setText(text);
        mixed.setStartTime(min);
        mixed.setEndTime(max);
        this.srtFigure.getStandardSubObjectList().add(mixed);
        this.srtFigure.rerect();
        this.lastSubtitle = null;
        this.srtFigure.repaint();
        this.setSubtitleModified(true);
    }

    public void createPartControl(Composite parent) {
        self = this;
        parent.setLayout((Layout)new GridLayout());
        Composite panels = new Composite(parent, 0);
        panels.setLayoutData((Object)new GridData(768));
        panels.setLayout((Layout)new GridLayout(6, false));
        Group controlPanel = new Group(panels, 0);
        controlPanel.setText(Messages.getString("waveformview.control"));
        controlPanel.setLayout((Layout)new GridLayout());
        this.openWavButton = new Button((Composite)controlPanel, 0);
        this.openWavButton.setText(Messages.getString("waveformview.open"));
        this.openWavButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (WaveFormViewer.this.opening) {
                    WaveFormViewer.this.cancelOpenFile();
                } else {
                    WaveFormViewer.this.openFile();
                }
                WaveFormViewer.this.setFocus();
            }
        });
        Button zoomUp = new Button((Composite)controlPanel, 0);
        zoomUp.setText(Messages.getString("waveformview.zoomUp"));
        zoomUp.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.zoomUp();
                WaveFormViewer.this.setFocus();
            }
        });
        this.zoomLabel = new Label((Composite)controlPanel, 0);
        GridData labelData = new GridData();
        labelData.widthHint = 65;
        this.zoomLabel.setLayoutData((Object)labelData);
        Button zoomDown = new Button((Composite)controlPanel, 0);
        zoomDown.setText(Messages.getString("waveformview.zoomDown"));
        zoomDown.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.zoomDown();
                WaveFormViewer.this.setFocus();
            }
        });
        Group playerPanel = new Group(panels, 0);
        playerPanel.setText(Messages.getString("waveformview.player"));
        playerPanel.setLayout((Layout)new GridLayout(1, false));
        Button playAudio = new Button((Composite)playerPanel, 0);
        playAudio.setText(Messages.getString("waveformview.play"));
        playAudio.setToolTipText("waveformview.play_tooltip");
        playAudio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.waveFormFigureCanvasAudioPlayer.play();
                WaveFormViewer.this.setFocus();
            }
        });
        Button stopAudio = new Button((Composite)playerPanel, 0);
        stopAudio.setText(Messages.getString("waveformview.stop"));
        stopAudio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.waveFormFigureCanvasAudioPlayer.stop();
                WaveFormViewer.this.setFocus();
            }
        });
        Group showPanel = new Group(panels, 0);
        showPanel.setText(Messages.getString("waveformview.show"));
        showPanel.setLayout((Layout)new GridLayout(2, false));
        Button visibleWave = new Button((Composite)showPanel, 2);
        visibleWave.setText(Messages.getString("waveformview.wave"));
        visibleWave.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.waveInfoCanvas.getFlowFigure().setVisible(((Button)e.getSource()).getSelection());
                WaveFormViewer.this.setFocus();
            }
        });
        visibleWave.setSelection(true);
        Button visibleSpectram = new Button((Composite)showPanel, 2);
        visibleSpectram.setText(Messages.getString("waveformview.spectram"));
        visibleSpectram.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.spectrogramListFigure.setVisible(((Button)e.getSource()).getSelection());
                WaveFormViewer.this.setFocus();
            }
        });
        visibleSpectram.setSelection(true);
        Button visiblePitch = new Button((Composite)showPanel, 2);
        visiblePitch.setText(Messages.getString("waveformview.pitch"));
        visiblePitch.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.pitchViewFigure.setVisible(((Button)e.getSource()).getSelection());
                WaveFormViewer.this.setFocus();
            }
        });
        visiblePitch.setSelection(true);
        Button visibleFormant = new Button((Composite)showPanel, 2);
        visibleFormant.setText(Messages.getString("waveformview.formant"));
        visibleFormant.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.formantFigure.setVisible(((Button)e.getSource()).getSelection());
                WaveFormViewer.this.setFocus();
            }
        });
        visibleFormant.setSelection(true);
        Button visibleSrt = new Button((Composite)showPanel, 2);
        visibleSrt.setText(Messages.getString("waveformview.srt"));
        visibleSrt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.srtFigure.setVisible(((Button)e.getSource()).getSelection());
                WaveFormViewer.this.setFocus();
            }
        });
        visibleSrt.setSelection(true);
        this.srtPanel = new Group(panels, 0);
        this.srtPanel.setText(Messages.getString("waveformview.srt"));
        this.srtPanel.setLayout((Layout)new GridLayout(4, false));
        Composite srtActions = new Composite((Composite)this.srtPanel, 0);
        srtActions.setLayout((Layout)new GridLayout());
        this.newSrtButton = new Button(srtActions, 0);
        this.newSrtButton.setEnabled(false);
        this.newSrtButton.setText(Messages.getString("waveformview.new"));
        this.newSrtButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.subtitleNewSelection(WaveFormViewer.this.srtText.getText());
                WaveFormViewer.this.setFocus();
            }
        });
        this.editSrtButton = new Button(srtActions, 0);
        this.editSrtButton.setEnabled(false);
        this.editSrtButton.setText(Messages.getString("waveformview.edit"));
        this.editSrtButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.subtitleTextUpdate();
                WaveFormViewer.this.setFocus();
            }
        });
        this.deleteSrtButton = new Button(srtActions, 0);
        this.deleteSrtButton.setEnabled(false);
        this.deleteSrtButton.setText(Messages.getString("waveformview.delete"));
        this.deleteSrtButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.subtitleDelete();
                WaveFormViewer.this.setFocus();
            }
        });
        this.srtText = new Text((Composite)this.srtPanel, 770);
        this.srtText.setLayoutData((Object)new GridData(1808));
        Composite srtActions2 = new Composite((Composite)this.srtPanel, 0);
        srtActions2.setLayout((Layout)new GridLayout());
        Button loadSRT = new Button(srtActions2, 0);
        loadSRT.setText(Messages.getString("waveformview.load"));
        loadSRT.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.loadSRT();
                WaveFormViewer.this.setFocus();
            }
        });
        this.saveSrt = new Button(srtActions2, 0);
        this.saveSrt.setText(Messages.getString("waveformview.save"));
        this.saveSrt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.saveSRT();
                WaveFormViewer.this.setFocus();
            }
        });
        this.saveSrt.setEnabled(false);
        Button saveAsSrt = new Button(srtActions2, 0);
        saveAsSrt.setText(Messages.getString("waveformview.save_as"));
        saveAsSrt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.saveAsSRT();
                WaveFormViewer.this.setFocus();
            }
        });
        Composite srtMoves = WidgetBuilder.createGridLayoutComposite((Composite)this.srtPanel, 0, 3, false);
        WidgetBuilder.createLabel(srtMoves, Messages.getString("waveformview.action_expand"));
        this.expand_leftButton = WidgetBuilder.createButton(srtMoves, Messages.getString("waveformview.arrow_left"));
        this.expand_leftButton.setToolTipText(Messages.getString("waveformview.action_expand_tooltip_left"));
        this.expand_leftButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                int v = -1;
                if ((e.stateMask & 0x20000) > 0) {
                    v *= 10;
                }
                WaveFormViewer.this.selectionExpand(v);
                WaveFormViewer.this.setFocus();
            }
        });
        this.expand_leftButton.setEnabled(false);
        this.expand_rightButton = WidgetBuilder.createButton(srtMoves, Messages.getString("waveformview.arrow_right"));
        this.expand_rightButton.setToolTipText(Messages.getString("waveformview.action_expand_tooltip_right"));
        this.expand_rightButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                int v = 1;
                if ((e.stateMask & 0x20000) > 0) {
                    v *= 10;
                }
                WaveFormViewer.this.selectionExpand(v);
                WaveFormViewer.this.setFocus();
            }
        });
        this.expand_rightButton.setEnabled(false);
        WidgetBuilder.createLabel(srtMoves, Messages.getString("waveformview.action_decrese"));
        this.decrese_leftButton = WidgetBuilder.createButton(srtMoves, Messages.getString("waveformview.arrow_right"));
        this.decrese_leftButton.setToolTipText(Messages.getString("waveformview.action_decrese_tooltip_left"));
        this.decrese_leftButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                int v = -1;
                if ((e.stateMask & 0x20000) > 0) {
                    v *= 10;
                }
                WaveFormViewer.this.selectionDecrese(v);
                WaveFormViewer.this.setFocus();
            }
        });
        this.decrese_leftButton.setEnabled(false);
        this.decrese_rightButton = WidgetBuilder.createButton(srtMoves, Messages.getString("waveformview.arrow_left"));
        this.decrese_rightButton.setToolTipText(Messages.getString("waveformview.action_decrese_tooltip_right"));
        this.decrese_rightButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                int v = 1;
                if ((e.stateMask & 0x20000) > 0) {
                    v *= 10;
                }
                WaveFormViewer.this.selectionDecrese(v);
                WaveFormViewer.this.setFocus();
            }
        });
        this.decrese_rightButton.setEnabled(false);
        WidgetBuilder.createLabel(srtMoves, Messages.getString("waveformview.action_move"));
        this.move_leftButton = WidgetBuilder.createButton(srtMoves, Messages.getString("waveformview.arrow_left"));
        this.move_leftButton.setToolTipText(Messages.getString("waveformview.action_move_tooltip_left"));
        this.move_leftButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                int v = -1;
                if ((e.stateMask & 0x20000) > 0) {
                    v *= 10;
                }
                WaveFormViewer.this.selectionMove(v);
                WaveFormViewer.this.setFocus();
            }
        });
        this.move_leftButton.setEnabled(false);
        this.move_rightButton = WidgetBuilder.createButton(srtMoves, Messages.getString("waveformview.arrow_right"));
        this.move_rightButton.setToolTipText(Messages.getString("waveformview.action_move_tooltip_right"));
        this.move_rightButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                int v = 1;
                if ((e.stateMask & 0x20000) > 0) {
                    v *= 10;
                }
                WaveFormViewer.this.selectionMove(v);
                WaveFormViewer.this.setFocus();
            }
        });
        this.move_rightButton.setEnabled(false);
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new FillLayout());
        this.waveInfoCanvas = new WaveFormFigureCanvas(base);
        this.waveInfoCanvas.setSplitFrame(this.splitFrame);
        this.waveInfoCanvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                WaveFormViewer.this.waveInfoCanvas.resize();
                WaveFormViewer.this.setFocus();
            }
        });
        this.waveInfoCanvas.zoomUp();
        this.zoomLabel.setText("x " + this.waveInfoCanvas.getZoom());
        ArrayList<StandardSubObject> list = new ArrayList<StandardSubObject>();
        this.srtFigure = new SubtitleListFigure(this.getSite().getShell(), 100, 100, this.waveInfoCanvas.getSplitFrame());
        this.srtFigure.setScale(this.waveInfoCanvas.getZoom(), 1.0);
        this.srtFigure.setStandardSubObjectList(list);
        this.srtFigure.rerect();
        this.waveInfoCanvas.getInFigure().add(this.srtFigure);
        this.pitchViewFigure = new PitchViewFigure(0, 0, this.waveInfoCanvas.getSplitFrame());
        this.pitchViewFigure.setScale(this.waveInfoCanvas.getZoom(), 1.0);
        this.pitchViewFigure.setEspsTime(this.pitchTime);
        this.waveInfoCanvas.getInFigure().add(this.pitchViewFigure);
        Group keyPadGroup = new Group(panels, 0);
        GridLayout layout = LayoutBuilder.makeGridLayoutNoMargin(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        keyPadGroup.setLayout((Layout)layout);
        this.createKeyPads((Composite)keyPadGroup);
        this.imageCache = new FileImageCache();
        this.imageCache.setMaxSize(300);
        this.spectrogramListFigure = new SpectrogramListFigure();
        this.waveInfoCanvas.getInFigure().add((IFigure)this.spectrogramListFigure, 0);
        this.formantFigure = new FormantFigure();
        WaveFormFigureCanvas.EmptyFigure container = new WaveFormFigureCanvas.EmptyFigure();
        container.setLayoutManager((LayoutManager)new FlowLayout());
        container.add((IFigure)this.formantFigure);
        this.waveInfoCanvas.getInFigure().add((IFigure)this.formantFigure);
        this.waveInfoCanvas.getForegroundFigure().setLayoutManager((LayoutManager)new StackLayout());
        this.pitchMemoryFigure = new PitchViewFigure.PitchMemoryFigure();
        this.waveInfoCanvas.getForegroundFigure().add((IFigure)this.pitchMemoryFigure);
        this.waveInfoCanvas.setMouseDoubleClickListener(new WaveFormFigureCanvas.MouseDoubleClickListener(){

            public void mouseDoubleClicked(long millisecond) {
                StandardSubObject srt = WaveFormViewer.this.srtFigure.intersectItem(millisecond);
                if (srt != null) {
                    WaveFormViewer.this.lastSubtitle = srt;
                    WaveFormViewer.this.lastSelectSubTime = System.currentTimeMillis();
                }
            }
        });
        this.waveInfoCanvas.setTimeSelectionListener(new WaveFormFigureCanvas.TimeSelectionListener(){

            public void timeSelectionChanged(WaveFormFigureCanvas.TimeSelection selection) {
                if (selection.getStart() == 0L && selection.getEnd() == 0L) {
                    boolean selectSubtitle = false;
                    if (WaveFormViewer.this.lastSubtitle != null) {
                        long time = System.currentTimeMillis() - WaveFormViewer.this.lastSelectSubTime;
                        if (time < 110L) {
                            WaveFormViewer.this.waveInfoCanvas.setSelectRealValue(WaveFormViewer.this.lastSubtitle.getStartTime(), WaveFormViewer.this.lastSubtitle.getEndTime());
                            selectSubtitle = true;
                        } else {
                            WaveFormViewer.this.lastSubtitle = null;
                        }
                    }
                    if (selectSubtitle) {
                        WaveFormViewer.this.selectionChangedSubtitle();
                    } else {
                        WaveFormViewer.this.selectionChangedNone();
                    }
                } else {
                    WaveFormViewer.this.selectionChangedSelection();
                }
                WaveFormViewer.this.selectionChanged();
            }
        });
        this.waveInfoCanvas.addKeyListener(new KeyActions());
        IViewSite viewSite = this.getViewSite();
        IActionBars actionBars = viewSite.getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        this.selectionInfo = new StatusLineContributionItem("selectionInfo");
        manager.add((IContributionItem)this.selectionInfo);
        this.fileInfo = new StatusLineContributionItem("fileInfo");
        manager.add((IContributionItem)this.fileInfo);
        this.createPopupMenu();
        this.waveFormFigureCanvasAudioPlayer = new WaveFormFigureCanvasAudioPlayer(this.getSite().getShell(), this.waveInfoCanvas);
        new DropMonitor(parent);
    }

    private void createKeyPads(Composite parent) {
        InputKey inputKey = new InputKey();
        Composite group1 = new Composite(parent, 0);
        GridLayout layout = LayoutBuilder.makeGridLayoutNoMargin(25, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        group1.setLayout((Layout)layout);
        Color startColor = ColorConstants.red;
        String[] startKeys = JapaneseUtils.splitSmallCharacter("\u3042\u304b\u3055\u305f\u306a\u306f\u307e\u3084\u3089\u308f\u304c\u3056\u3060\u3070\u3071\u304d\u3083\u304e\u3083\u3057\u3083\u3058\u3083\u3061\u3083\u3062\u3083\u3072\u3083\u3073\u3083\u3061\u3083\u3058\u3083\u3072\u3083\u3073\u3083\u3074\u3083\u307f\u3083\u308a\u3083\u3075\u3041\u306b\u3083\u30fc\u3041");
        int i = 0;
        while (i < startKeys.length) {
            ++i;
        }
        String keys1 = "\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084 \u3086 \u3088\u3089\u308a\u308b\u308c\u308d\u308f \u3092 \u3093\u304c\u304e\u3050\u3052\u3054\u3056\u3058\u305a\u305c\u305e\u3060\u3061\u305a\u3067\u3069\u3070\u3073\u3076\u3079\u307c\u3071\u3074\u3077\u3079\u307d";
        String[] keys = JapaneseUtils.splitSmallCharacter(keys1);
        int i2 = 0;
        while (i2 < keys.length) {
            Button bt = new Button(group1, 0);
            bt.setText(keys[i2]);
            int j = 0;
            while (j < startKeys.length) {
                if (startKeys[j].equals(keys[i2])) {
                    bt.setBackground(startColor);
                }
                ++j;
            }
            bt.addSelectionListener((SelectionListener)inputKey);
            ++i2;
        }
        String key2 = "\u304d\u3083\u304d\u3085\u304d\u3087\u304e\u3083\u304e\u3085\u304e\u3087\u3057\u3083\u3057\u3085\u3057\u3087\u3058\u3083\u3058\u3085\u3058\u3087\u3061\u3083\u3061\u3085\u3061\u3087\u3062\u3083\u3062\u3085\u3062\u3087\u306b\u3083\u306b\u3085\u306b\u3087\u3075\u3041\u3075\u3043\u3075\u3085\u3072\u3083\u3072\u3085\u3072\u3087\u3073\u3083\u3073\u3085\u3073\u3087\u3074\u3083\u3074\u3085\u3074\u3087\u307f\u3083\u307f\u3085\u307f\u3087\u308a\u3083\u308a\u3085\u308a\u3087\u30fc";
        Composite group2 = new Composite(parent, 0);
        GridLayout layout2 = LayoutBuilder.makeGridLayoutNoMargin(19, false);
        layout2.horizontalSpacing = 0;
        layout2.verticalSpacing = 0;
        group2.setLayout((Layout)layout2);
        String[] keys2 = JapaneseUtils.splitSmallCharacter(key2);
        int i3 = 0;
        while (i3 < keys2.length) {
            Button bt = new Button(group2, 0);
            bt.setText(keys2[i3]);
            bt.addSelectionListener((SelectionListener)inputKey);
            int j = 0;
            while (j < startKeys.length) {
                if (startKeys[j].equals(keys2[i3])) {
                    bt.setBackground(startColor);
                }
                ++j;
            }
            ++i3;
        }
    }

    private void createPopupMenu() {
        this.popUpMenuControler = new MenuControler();
        this.popUpMenuControler.createPushMenu(this.waveInfoCanvas.getPopUpMenu(), Messages.getString("waveformview.mix_subtitle")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.subtitleMix();
            }
        });
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.mix_subtitle"), false);
        this.popUpMenuControler.createSeparateMenu(this.waveInfoCanvas.getPopUpMenu());
        this.popUpMenuControler.createPushMenu(this.waveInfoCanvas.getPopUpMenu(), Messages.getString("waveformview.split_subtitle")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.subtitleSplit();
            }
        });
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.split_subtitle"), false);
        this.popUpMenuControler.createSeparateMenu(this.waveInfoCanvas.getPopUpMenu());
        this.popUpMenuControler.createPushMenu(this.waveInfoCanvas.getPopUpMenu(), Messages.getString("waveformview.select_before")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.subtitleSelectBefore();
            }
        });
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.select_before"), false);
        this.popUpMenuControler.createPushMenu(this.waveInfoCanvas.getPopUpMenu(), Messages.getString("waveformview.select_about")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.subtitleSelectAbout();
            }
        });
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.select_about"), false);
        this.popUpMenuControler.createPushMenu(this.waveInfoCanvas.getPopUpMenu(), Messages.getString("waveformview.select_after")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.subtitleSelectAfter();
            }
        });
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.select_after"), false);
        this.popUpMenuControler.createSeparateMenu(this.waveInfoCanvas.getPopUpMenu());
        this.popUpMenuControler.createPushMenu(this.waveInfoCanvas.getPopUpMenu(), Messages.getString("waveformview.select_all")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.selectAll();
            }
        });
        this.popUpMenuControler.createSeparateMenu(this.waveInfoCanvas.getPopUpMenu());
        this.popUpMenuControler.createPushMenu(this.waveInfoCanvas.getPopUpMenu(), Messages.getString("waveformview.normalize_subtitle")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.subtitleNormalize();
            }
        });
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.normalize_subtitle"), false);
        this.popUpMenuControler.createSeparateMenu(this.waveInfoCanvas.getPopUpMenu());
        this.popUpMenuControler.createPushMenu(this.waveInfoCanvas.getPopUpMenu(), Messages.getString("waveformview.subtitle_copy_text")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WaveFormViewer.this.subtitleCopyText();
            }
        });
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.subtitle_copy_text"), false);
    }

    protected void subtitleNormalize() {
        if (this.lastSubtitle != null) {
            int index = -1;
            Object[] subs = this.srtFigure.getStandardSubObjectList().toArray(new StandardSubObject[0]);
            Arrays.sort(subs);
            int i = 0;
            while (i < subs.length) {
                if (subs[i] == this.lastSubtitle) {
                    index = i;
                }
                ++i;
            }
            if (index != -1) {
                long start = subs[index].getStartTime();
                int j = 0;
                while (j < subs.length) {
                    if (j != index && subs[index].intersect(subs[j].getStartTime(), subs[j].getEndTime())) {
                        System.out.println("intersect");
                        if (subs[j].getStartTime() < subs[index].getStartTime() && subs[j].getEndTime() > start) {
                            if (start <= subs[index].getEndTime()) {
                                start = subs[j].getEndTime();
                                System.out.println("start-changed");
                                this.setSubtitleModified(true);
                            } else {
                                log.warn((Object)"cant normalized subs:");
                            }
                        } else {
                            System.out.println(subs[index]);
                            System.out.println(subs[j]);
                        }
                    }
                    ++j;
                }
                subs[index].setStartTime(start);
                long end = subs[index].getEndTime();
                int j2 = 0;
                while (j2 < subs.length) {
                    if (index != j2 && subs[j2].getStartTime() > subs[index].getStartTime() && subs[index].intersect(subs[j2].getStartTime(), subs[j2].getEndTime()) && subs[j2].getStartTime() < end) {
                        if (end >= subs[index].getStartTime()) {
                            end = subs[j2].getStartTime();
                            System.out.println("end-changed");
                            this.setSubtitleModified(true);
                        } else {
                            log.warn((Object)"cant normalized subs:");
                        }
                    }
                    ++j2;
                }
                subs[index].setEndTime(end);
                this.srtFigure.rerect();
                this.srtFigure.repaint();
            }
        } else {
            WaveFormFigureCanvas.TimeSelection select = this.waveInfoCanvas.getSelection();
            Object[] contains = this.srtFigure.containSubtitles(select);
            Arrays.sort(contains);
            Object[] subs = this.srtFigure.getStandardSubObjectList().toArray(new StandardSubObject[0]);
            Arrays.sort(subs);
            int i = 0;
            while (i < contains.length) {
                long start = contains[i].getStartTime();
                int j = 0;
                while (j < subs.length) {
                    if (contains[i] != subs[j] && contains[i].intersect(subs[j].getStartTime(), subs[j].getEndTime()) && subs[j].getStartTime() < contains[i].getStartTime() && subs[j].getEndTime() > start) {
                        if (start <= contains[i].getEndTime()) {
                            start = subs[j].getEndTime();
                            this.setSubtitleModified(true);
                        } else {
                            log.warn((Object)"cant normalized subs:");
                        }
                    }
                    ++j;
                }
                contains[i].setStartTime(start);
                ++i;
            }
            this.srtFigure.rerect();
            this.lastSubtitle = null;
            this.srtFigure.repaint();
        }
    }

    protected void subtitleSelectBefore() {
        long current = this.waveInfoCanvas.getCurrentRealValue();
        StandardSubObject[] subs = this.srtFigure.getStandardSubObjectList().toArray(new StandardSubObject[0]);
        StandardSubObject before = null;
        long min = 600000L;
        int i = 0;
        while (i < subs.length) {
            if (subs[i].getEndTime() < current && current - subs[i].getEndTime() < min) {
                before = subs[i];
                min = current - subs[i].getEndTime();
            }
            ++i;
        }
        if (before != null) {
            this.waveInfoCanvas.setSelectRealValue(before.getEndTime(), current);
            this.newSrtButton.setEnabled(true);
        }
    }

    protected void subtitleSelectAbout() {
        long current = this.waveInfoCanvas.getCurrentRealValue();
        StandardSubObject[] subs = this.srtFigure.getStandardSubObjectList().toArray(new StandardSubObject[0]);
        StandardSubObject before = null;
        long min = 3600000L;
        int i = 0;
        while (i < subs.length) {
            if (subs[i].getEndTime() < current && current - subs[i].getEndTime() < min) {
                before = subs[i];
                min = current - subs[i].getEndTime();
            }
            ++i;
        }
        StandardSubObject after = null;
        long min2 = 3600000L;
        int i2 = 0;
        while (i2 < subs.length) {
            if (subs[i2].getStartTime() > current && subs[i2].getStartTime() - current < min2) {
                after = subs[i2];
                min2 = subs[i2].getStartTime() - current;
            }
            ++i2;
        }
        if (min != 0L && before != null && min2 != 0L && after != null) {
            this.waveInfoCanvas.setSelectRealValue(before.getEndTime(), after.getStartTime());
            this.newSrtButton.setEnabled(true);
        }
    }

    protected void subtitleSelectAfter() {
        long current = this.waveInfoCanvas.getCurrentRealValue();
        StandardSubObject[] subs = this.srtFigure.getStandardSubObjectList().toArray(new StandardSubObject[0]);
        StandardSubObject after = null;
        long min = 3600000L;
        int i = 0;
        while (i < subs.length) {
            if (subs[i].getStartTime() > current && subs[i].getStartTime() - current < min) {
                after = subs[i];
                min = subs[i].getStartTime() - current;
            }
            ++i;
        }
        if (min != 0L && after != null) {
            this.waveInfoCanvas.setSelectRealValue(current, after.getStartTime());
            this.newSrtButton.setEnabled(true);
        }
    }

    protected void subtitleNewTime() {
    }

    protected void subtitleInsertText() {
    }

    protected void subtitleCopyText() {
        WaveFormFigureCanvas.TimeSelection select = this.waveInfoCanvas.getSelection();
        Object[] subs = this.srtFigure.containSubtitles(select);
        Arrays.sort(subs);
        String text = "";
        int i = 0;
        while (i < subs.length) {
            text = String.valueOf(text) + subs[i].getText();
            ++i;
        }
        ClipboardUtil.setClipboard(null, text);
    }

    protected void subtitleEditTime() {
        SubtitleDialog dialog = new SubtitleDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("log.title"), null, 0, new String[]{"OK", Messages.getString("cancel")}, 1);
        int ret = dialog.open();
        System.out.println(ret);
        this.setSubtitleModified(true);
    }

    protected void subtitleExpandBack() {
    }

    protected void subtitleExpandForward() {
    }

    protected void subtitleNoOverwrap() {
    }

    protected void subtitleCutArea() {
    }

    protected void subtitleSplit(int i) {
    }

    protected void subtitleSplit() {
        if (this.lastSubtitle == null) {
            return;
        }
        String text = this.lastSubtitle.getText();
        if (text.length() < 2) {
            return;
        }
        String[] chars = JapaneseUtils.splitSmallCharacter(text);
        double perTime = (this.lastSubtitle.getEndTime() - this.lastSubtitle.getStartTime()) / (long)chars.length;
        double current = this.lastSubtitle.getStartTime();
        int i = 0;
        while (i < chars.length) {
            StandardSubObject sub = new StandardSubObject();
            sub.setText(chars[i]);
            sub.setStartTime((long)current);
            sub.setEndTime((long)(current + perTime));
            this.srtFigure.getStandardSubObjectList().add(sub);
            current += perTime;
            ++i;
        }
        this.srtFigure.getStandardSubObjectList().remove(this.lastSubtitle);
        this.srtFigure.rerect();
        this.lastSubtitle = null;
        this.srtFigure.repaint();
        this.setSubtitleModified(true);
    }

    private void selectAll() {
        this.waveInfoCanvas.selectAll();
        this.selectionChangedSelection();
    }

    private void selectionExpand(int increse) {
        if (this.lastSubtitle != null) {
            if (increse > 0) {
                this.lastSubtitle.setEndTime(this.lastSubtitle.getEndTime() + (long)increse);
            } else {
                this.lastSubtitle.setStartTime(this.lastSubtitle.getStartTime() + (long)increse);
            }
            this.selectionChanged();
            this.waveInfoCanvas.setSelectRealValue(this.lastSubtitle.getStartTime(), this.lastSubtitle.getEndTime());
            this.srtFigure.rerect(this.lastSubtitle);
            this.srtFigure.repaint();
            this.setSubtitleModified(true);
        } else {
            WaveFormFigureCanvas.TimeSelection selection = this.waveInfoCanvas.getSelection();
            if (selection != null) {
                if (increse > 0) {
                    this.waveInfoCanvas.setSelectRealValue(selection.getStart(), selection.getEnd() + (long)increse);
                } else {
                    this.waveInfoCanvas.setSelectRealValue(selection.getStart() + (long)increse, selection.getEnd());
                }
                this.selectionChanged();
                this.setSubtitleModified(true);
            }
        }
    }

    private void selectionDecrese(int reduce) {
        if (this.lastSubtitle != null) {
            if (reduce > 0) {
                this.lastSubtitle.setEndTime(this.lastSubtitle.getEndTime() - (long)reduce);
            } else {
                this.lastSubtitle.setStartTime(this.lastSubtitle.getStartTime() - (long)reduce);
            }
            this.selectionChanged();
            this.waveInfoCanvas.setSelectRealValue(this.lastSubtitle.getStartTime(), this.lastSubtitle.getEndTime());
            this.srtFigure.rerect(this.lastSubtitle);
            this.srtFigure.repaint();
            this.setSubtitleModified(true);
        } else {
            WaveFormFigureCanvas.TimeSelection selection = this.waveInfoCanvas.getSelection();
            if (selection != null) {
                if (reduce > 0) {
                    this.waveInfoCanvas.setSelectRealValue(selection.getStart(), selection.getEnd() - (long)reduce);
                } else {
                    this.waveInfoCanvas.setSelectRealValue(selection.getStart() - (long)reduce, selection.getEnd());
                }
                this.selectionChanged();
                this.setSubtitleModified(true);
            }
        }
    }

    private void selectionMove(int move) {
        if (this.lastSubtitle != null) {
            if (move > 0) {
                this.lastSubtitle.setStartTime(this.lastSubtitle.getStartTime() + (long)move);
                this.lastSubtitle.setEndTime(this.lastSubtitle.getEndTime() + (long)move);
            } else {
                this.lastSubtitle.setStartTime(this.lastSubtitle.getStartTime() + (long)move);
                this.lastSubtitle.setEndTime(this.lastSubtitle.getEndTime() + (long)move);
            }
            this.selectionChanged();
            this.waveInfoCanvas.setSelectRealValue(this.lastSubtitle.getStartTime(), this.lastSubtitle.getEndTime());
            this.srtFigure.rerect(this.lastSubtitle);
            this.srtFigure.repaint();
            this.setSubtitleModified(true);
        } else {
            WaveFormFigureCanvas.TimeSelection selection = this.waveInfoCanvas.getSelection();
            if (selection != null) {
                this.waveInfoCanvas.setSelectRealValue(selection.getStart() + (long)move, selection.getEnd() + (long)move);
                this.selectionChanged();
                this.setSubtitleModified(true);
            }
        }
    }

    public void selectionChanged() {
        WaveFormFigureCanvas.TimeSelection selection = this.waveInfoCanvas.getSelection();
        if (selection == null) {
            long value = this.waveInfoCanvas.getCurrentRealValue();
            this.selectionInfo.setText("* (" + FFMpegUtils.toMillisecondLabel(value) + " - *)");
        } else {
            long diff = selection.getEnd() - selection.getStart();
            String label = "";
            label = String.valueOf(label) + FFMpegUtils.toMillisecondLabel(diff) + " (" + FFMpegUtils.toMillisecondLabel(selection.getStart()) + " - " + FFMpegUtils.toMillisecondLabel(selection.getEnd()) + ")";
            this.selectionInfo.setText(label);
        }
    }

    protected void subtitleDelete() {
        if (this.lastSubtitle != null) {
            this.srtFigure.remove(this.lastSubtitle);
            this.lastSubtitle = null;
            this.newSrtButton.setEnabled(true);
            this.editSrtButton.setEnabled(false);
            this.deleteSrtButton.setEnabled(false);
            this.expand_leftButton.setEnabled(false);
            this.expand_rightButton.setEnabled(false);
            this.decrese_leftButton.setEnabled(false);
            this.decrese_rightButton.setEnabled(false);
            this.move_leftButton.setEnabled(false);
            this.move_rightButton.setEnabled(false);
            this.setSubtitleModified(true);
        }
    }

    protected void subtitleTextUpdate() {
        if (this.lastSubtitle != null) {
            this.lastSubtitle.setText(this.srtText.getText());
            this.srtFigure.repaint();
            this.setSubtitleModified(true);
        }
    }

    protected void subtitleNewSelection(String newText) {
        WaveFormFigureCanvas.TimeSelection selection = this.waveInfoCanvas.getSelection();
        if (selection != null) {
            StandardSubObject srt = new StandardSubObject();
            srt.setText(newText);
            srt.setStartTime(selection.getStart());
            srt.setEndTime(selection.getEnd());
            this.srtFigure.add(srt);
            this.lastSubtitle = srt;
            this.selectionChangedSubtitle();
            this.setSubtitleModified(true);
        }
    }

    protected void saveAsSRT() {
        String path;
        File srt;
        FileDialog fileDialog = new FileDialog(this.getSite().getShell(), 8192);
        fileDialog.setFilterExtensions(new String[]{"*.srt"});
        if (this.audioFile != null && !(srt = new File(FileNameUtils.getChangedExtensionName(this.audioFile, "srt", true))).exists()) {
            fileDialog.setFileName(srt.getAbsolutePath());
        }
        if ((path = fileDialog.open()) != null) {
            try {
                SubUtils.saveAsSrt(this.srtFigure.getStandardSubObjectList(), (File)new File(path));
                this.subtitlePath = path;
                this.srtPanel.setText(String.valueOf(Messages.getString("waveformview.srt")) + ":" + FileNameUtils.getRemovedExtensionName(new File(path).getName()));
                this.setSubtitleModified(false);
            }
            catch (IOException e) {
                log.warn((Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected void saveSRT() {
        if (this.subtitlePath == null) {
            this.saveAsSRT();
        } else {
            try {
                SubUtils.saveAsSrt(this.srtFigure.getStandardSubObjectList(), (File)new File(this.subtitlePath));
                this.setSubtitleModified(false);
            }
            catch (IOException e) {
                log.warn((Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected void saveImage() {
    }

    protected void loadSRT() {
        FileDialog fileDialog = new FileDialog(this.getSite().getShell());
        fileDialog.setFilterExtensions(new String[]{"*.srt"});
        String path = fileDialog.open();
        if (path != null) {
            this.loadSRT(new File(path));
        }
    }

    protected void loadSRT(File file) {
        SRTParser parser = new SRTParser();
        try {
            SRTList list = parser.parse((Reader)new FileReader(file));
            List subList = list.convertStandardSubtitleDataList();
            this.srtFigure.setStandardSubObjectList(subList);
            this.srtFigure.repaint();
            this.subtitlePath = file.getAbsolutePath();
            this.srtPanel.setText(String.valueOf(Messages.getString("waveformview.srt")) + ":" + FileNameUtils.getRemovedExtensionName(file.getName()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void openFile() {
        FileDialog fileDialog = new FileDialog(this.getSite().getShell());
        fileDialog.setFilterExtensions(new String[]{"*.wav"});
        String path = fileDialog.open();
        if (path != null) {
            if (FileNameUtils.isWaveFile(path)) {
                this.openFile(new File(path));
            } else if (!new File(path).exists() && new File(String.valueOf(path) + ".wav").exists()) {
                this.openFile(new File(String.valueOf(path) + ".wav"));
            }
        }
    }

    public void cancelOpenFile() {
        this.cancelOpenFile = true;
        if (this.waveInfoCanvas.getCanceller() != null) {
            this.waveInfoCanvas.getCanceller().setCanceld(true);
        }
        if (this.pitchExecuter != null) {
            this.pitchExecuter.cancel();
        }
        this.monitor.setCanceled(true);
        this.spectrogramExecuter.cancel();
        this.formantExecuter.cancel();
    }

    private void parsePitchView(File file) {
        ESPS[] espses = this.loadESPS(file);
        if (espses != null) {
            this.pitchViewFigure.setEspses(espses);
        }
    }

    private void parseWaveFormView(File file) {
        this.waveInfoCanvas.loadWave(file);
        int sampleRate = this.waveInfoCanvas.getSampleRate();
        System.out.println("samplerate:" + sampleRate);
        int maxPitch = sampleRate / 20;
        this.pitchViewFigure.setMaxPitch(maxPitch);
        this.pitchMemoryFigure.setMaxPitch(maxPitch);
        this.pitchMemoryFigure.repaint();
        this.formantFigure.setSampleRate(sampleRate);
    }

    public void initializeViews() {
        this.waveInfoCanvas.setSelectRealValue(0L, 0L);
        this.srtFigure.setStandardSubObjectList(new ArrayList<StandardSubObject>());
        this.waveInfoCanvas.removeAll();
        this.pitchViewFigure.setEspses(null);
        this.spectrogramListFigure.removeAll();
        this.imageCache.removeAll();
        this.formantFigure.setFormants(null);
        this.waveInfoCanvas.redraw();
    }

    public void openFile(File file) {
        this.subtitlePath = null;
        this.lastSubtitle = null;
        this.audioFile = file;
        StatusBarUtils.showStatusBar("open");
        this.opening = true;
        this.cancelOpenFile = false;
        this.openWavButton.setText(Messages.getString("waveformview.cancel"));
        this.initializeViews();
        this.fileInfo.setText(String.valueOf(Messages.getString("waveformview.audio_file")) + ":" + FileNameUtils.getRemovedExtensionName(file.getName()));
        if (!this.cancelOpenFile) {
            this.parseWaveFormView(file);
            if (this.cancelOpenFile) {
                return;
            }
            this.waveFormFigureCanvasAudioPlayer.setAudioFile(file);
            File srt = new File(FileNameUtils.getChangedExtensionName(file, "srt", true));
            if (srt.exists()) {
                this.loadSRT(srt);
            }
            this.monitor = ProgressMonitorUtils.getProgressMonitor();
            this.monitor.setCanceled(false);
            new BackgroundOpen(file).start();
        }
    }

    private void parseSpectramAndFormant(File file) {
        File[] splits;
        block31: {
            log.trace((Object)"parseSpectramAndFormant");
            String tmpdirPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("videotools.ascii_tmpdir");
            if (tmpdirPath.equals("")) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printError("spectram:tmpdir not found\n");
                log.warn((Object)"spectramfolder not found");
                return;
            }
            if (!FileNameUtils.isAsciiFileName(tmpdirPath)) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printError("spectram:tmpdir is invalid\n");
                log.warn((Object)"spectramfolder not found");
                return;
            }
            File tmpdir = new File(tmpdirPath);
            Shell shell = this.getSite().getShell();
            String spectramImageDir = Akj_betasPlugin.getDefault().getPreferenceStore().getString("audiotools.path_spectram_images");
            if (spectramImageDir.equals("") || !new File(spectramImageDir).exists()) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printError("spectram:spectramfolder not found\n");
                log.warn((Object)"spectramfolder not found");
                return;
            }
            try {
                FileUtils.cleanDirectory((File)new File(spectramImageDir));
            }
            catch (IOException e1) {
                log.warn((Object)e1.getMessage());
                e1.printStackTrace();
            }
            String spectramPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("audiotools.path_spectram");
            if (spectramPath.equals("")) {
                log.warn((Object)"spectramPath not found");
                return;
            }
            File baseFolder = new File(spectramImageDir);
            double persampleBy1Pixel = 0.0;
            int spectrogramLength = 0;
            int totalsizelof1sec = this.imageWidth * this.howManyImagesMakePer1sec;
            double pixelSecond = 1.0 / (double)totalsizelof1sec;
            System.out.println("pixelSecond:" + pixelSecond);
            AudioFormat format = null;
            int samplerate = 0;
            try {
                AudioInputStream input = AudioSystem.getAudioInputStream(file);
                format = input.getFormat();
                spectrogramLength = (int)input.getFrameLength();
                samplerate = (int)format.getSampleRate();
                persampleBy1Pixel = (double)samplerate / (double)totalsizelof1sec;
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            double baseZoom = pixelSecond / this.splitFrame;
            System.out.println("baseZoom " + baseZoom + ",wavezoom=" + this.waveInfoCanvas.getZoom() + "persampleBy1Pixel " + persampleBy1Pixel);
            int basicSplitDuration = 60000;
            SplitMonitor spMonitor = new SplitMonitor(this.monitor);
            splits = null;
            try {
                splits = WaveUtils.splitFile((File)file, (int)basicSplitDuration, (int)this.imageHeight, (boolean)true, (AudioProgressListener)spMonitor, (File)tmpdir);
                int i = 0;
                while (i < splits.length) {
                    splits[i].deleteOnExit();
                    ++i;
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            if (splits == null || this.monitor.isCanceled()) {
                log.warn((Object)"splits==null or cancelde");
                return;
            }
            double offset = (double)this.imageHeight / persampleBy1Pixel;
            if (offset % 1.0 > 0.0) {
                offset = (int)offset + 1;
            }
            log.trace((Object)("offset:" + offset));
            this.getSite().getShell().getDisplay().syncExec((Runnable)new SpectroGramZoomChange(baseZoom * this.waveInfoCanvas.getZoom()));
            this.getSite().getShell().getDisplay().syncExec((Runnable)new InitializeSpectramFigure(this.imageWidth, this.imageHeight, (int)((double)spectrogramLength / persampleBy1Pixel), this.imageCache, baseFolder));
            this.getSite().getShell().getDisplay().syncExec((Runnable)new ReValidateFigure((IFigure)this.spectrogramListFigure));
            if (this.cancelOpenFile) {
                return;
            }
            int imageCount = spectrogramLength / samplerate * this.howManyImagesMakePer1sec;
            ProgressMonitorUtils.beginMonitor(this.monitor, String.valueOf(Messages.getString("waveformview.making_spectragram")) + file.getName(), imageCount, true);
            this.spectrogramExecuter = new SpectrogramExecuter();
            this.spectrogramExecuter.setSpectrogramExePath(spectramPath);
            try {
                this.spectrogramExecuter.createSpectrogramImage(splits, spectramImageDir, samplerate, this.imageWidth, this.imageHeight, persampleBy1Pixel, 0, 0, new SpectragramMonitor(), new SpectramImageSaved());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ProgressMonitorUtils.doneMonitor(this.monitor, true);
            int perFormant = 10;
            long audioLength = WaveUtils.countAudioMillisecond((File)file);
            int lastSplitDuration = (int)(audioLength % (long)basicSplitDuration);
            int splitSize = (int)audioLength / basicSplitDuration;
            if (audioLength % (long)basicSplitDuration > 0L) {
                ++splitSize;
            }
            int works = splitSize;
            ArrayList<SmallFormant> formantList = new ArrayList<SmallFormant>();
            this.formantExecuter = new FormantExecuter();
            String formantPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("audiotools.path_formant");
            this.formantExecuter.setFormantExePath(formantPath);
            this.formantFigure.setOffsetX(-6.0);
            ProgressMonitorUtils.beginMonitor(this.monitor, "Open File " + file.getName(), works, true);
            long formantStart = System.currentTimeMillis();
            formantList.removeAll(formantList);
            if (!formantPath.equals("")) {
                try {
                    int j = 0;
                    while (j < splits.length) {
                        int splitDuration = basicSplitDuration;
                        if (j == splits.length - 1) {
                            splitDuration = lastSplitDuration;
                        }
                        log.trace((Object)("splitDuration:" + splitDuration + "ms"));
                        ProgressMonitorUtils.subtaskMonitor(this.monitor, "parse formant " + (j + 1) + "/" + splits.length, true);
                        if (this.monitor.isCanceled()) {
                            return;
                        }
                        Formant[] formants = this.formantExecuter.getFormants(splits[j].getAbsolutePath(), 0, -this.imageHeight);
                        log.trace((Object)("formant-length:" + formants.length));
                        log.trace((Object)("formant-parse-time:" + (System.currentTimeMillis() - formantStart)));
                        int collectSize = splitDuration / perFormant;
                        log.trace((Object)("collect-size:" + collectSize));
                        int cfr_ignored_0 = formants.length;
                        if (formants.length > 0) {
                            int diff = formants.length - collectSize;
                            int i = 0;
                            while (i < collectSize) {
                                int index = i + diff;
                                if (index < 0) {
                                    index = diff * -1;
                                    log.warn((Object)"lack-formant:copy one");
                                }
                                SmallFormant smallFormant = new SmallFormant(formants[index]);
                                formantList.add(smallFormant);
                                ++i;
                            }
                        }
                        formants = null;
                        System.gc();
                        ProgressMonitorUtils.workedMonitor(this.monitor, 1, true);
                        if (this.monitor.isCanceled()) {
                            return;
                        }
                        ++j;
                    }
                    ProgressMonitorUtils.doneMonitor(this.monitor, true);
                    if (formantList.size() > 0) {
                        log.trace((Object)("formant-size:" + formantList.size()));
                        shell.getDisplay().syncExec((Runnable)new SetFormantData(formantList.toArray(new SmallFormant[formantList.size()]), spectrogramLength));
                        break block31;
                    }
                    log.debug((Object)"SetAudioData:something null");
                }
                catch (IOException iOException) {
                    log.warn((Object)"parse formant faild");
                }
            } else {
                log.warn((Object)"formantPath not found");
            }
        }
        int i = 0;
        while (i < splits.length) {
            splits[i].delete();
            ++i;
        }
    }

    public void setFormantData(SmallFormant[] formants, long spectrogramLength) {
        this.formantFigure.setFormants(formants);
        this.formantFigure.setWzoom(this.spectrogramListFigure.getWzoom());
        log.trace((Object)"formant-resize:");
        this.formantFigure.resize();
        double pixelMillisecond = 2.5;
        SmallFormant.toMillisecond(formants);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this);
        this.updateDraw();
    }

    public void updateDraw() {
        log.warn((Object)"repaint");
    }

    public void setFocus() {
        this.waveInfoCanvas.setFocus();
    }

    public ESPS[] loadESPS(File waveFile) {
        File input;
        String pitch2ExePath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("audiotools.path_pitch2");
        if (pitch2ExePath.equals("")) {
            Akj_betasPlugin.getDefault().getProcessPrinter().printError("pitch2.exe is not setted in OtherTools setting\n");
            StatusBarUtils.showStatusBar("pitch2.exe is not setted in OtherTools setting");
            return null;
        }
        String tmpDirChooser_value = Akj_betasPlugin.getDefault().getPreferenceStore().getString("videotools.ascii_tmpdir");
        if (tmpDirChooser_value.equals("") || !FileNameUtils.isAsciiFileName(tmpDirChooser_value)) {
            Akj_betasPlugin.getDefault().getProcessPrinter().printError("load pitch:tmpdir wrong\n");
            return null;
        }
        AudioFileFormat format = null;
        try {
            format = AudioSystem.getAudioFileFormat(waveFile);
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (format == null) {
            log.warn((Object)"wrong wave");
            return null;
        }
        File tmp = null;
        if (FileNameUtils.isAsciiFileName(waveFile.getAbsolutePath()) && (int)format.getFormat().getSampleRate() == 48000) {
            input = waveFile;
        } else {
            if (!new File(tmpDirChooser_value).exists()) {
                log.warn((Object)"tmp dir not found");
                return null;
            }
            tmp = input = new File(tmpDirChooser_value, String.valueOf(System.currentTimeMillis()) + ".wav");
            tmp.deleteOnExit();
            try {
                if ((int)format.getFormat().getSampleRate() == 48000) {
                    FileUtils.copyFile((File)waveFile, (File)input);
                } else {
                    String ffmpeg = FFMpegUI.getFFmpegOrPureFFMpeg();
                    if (ffmpeg == null) {
                        log.warn((Object)"no ffmpeg and copy");
                        FileUtils.copyFile((File)waveFile, (File)input);
                    } else {
                        SimpleCommandExecuter executer = new SimpleCommandExecuter(FFMpegCommandUtil.makeWaveSampleRateChangeCommand(ffmpeg, waveFile.getAbsolutePath(), input.getAbsolutePath(), 48000));
                        executer.setPrinter(Akj_betasPlugin.getDefault().getProcessPrinter());
                        executer.execute();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.warn((Object)"faild");
                return null;
            }
        }
        this.pitchExecuter = new PitchExecuter();
        this.pitchExecuter.setPitch2ExePath(pitch2ExePath);
        ESPS[] esps = null;
        try {
            String[] commands = this.pitchExecuter.getCommands(input.getAbsolutePath(), 0, 0, this.minPitch, this.maxPitch, this.pitchTime);
            log.info((Object)FFMpegUtils.toPrintCommand(commands));
            Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("###\n" + FFMpegUtils.toPrintCommand(commands) + "\n");
            esps = this.pitchExecuter.getESPS(input.getAbsolutePath(), 0, 0, this.minPitch, this.maxPitch, this.pitchTime);
            if (tmp != null) {
                tmp.delete();
            }
        }
        catch (IOException e) {
            StatusBarUtils.showStatusBar("faild:" + waveFile.getName());
            Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(String.valueOf(e.getMessage()) + "\n");
            e.printStackTrace();
        }
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("###\n");
        return esps;
    }

    public boolean isSubtitleModified() {
        return this.subtitleModified;
    }

    public void setSubtitleModified(boolean subtitleModified) {
        this.subtitleModified = subtitleModified;
        this.saveSrt.setEnabled(subtitleModified);
        if (subtitleModified) {
            File f = new File(String.valueOf(System.getProperty("user.home")) + "\\" + "workspace\\autobackup.srt");
            try {
                SubUtils.saveAsSrt(this.srtFigure.getStandardSubObjectList(), (File)f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void selectionChangedSelection() {
        this.lastSubtitle = null;
        this.srtText.setText("");
        this.newSrtButton.setEnabled(true);
        this.editSrtButton.setEnabled(false);
        this.deleteSrtButton.setEnabled(false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.mix_subtitle"), true);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.split_subtitle"), false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.subtitle_copy_text"), true);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.select_before"), false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.select_about"), false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.select_after"), false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.normalize_subtitle"), true);
    }

    private void selectionChangedNone() {
        this.srtText.setText("");
        this.newSrtButton.setEnabled(false);
        this.editSrtButton.setEnabled(false);
        this.deleteSrtButton.setEnabled(false);
        this.expand_leftButton.setEnabled(false);
        this.expand_rightButton.setEnabled(false);
        this.decrese_leftButton.setEnabled(false);
        this.decrese_rightButton.setEnabled(false);
        this.move_leftButton.setEnabled(false);
        this.move_rightButton.setEnabled(false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.mix_subtitle"), false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.split_subtitle"), false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.subtitle_copy_text"), false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.select_before"), true);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.select_about"), true);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.select_after"), true);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.normalize_subtitle"), false);
    }

    private void selectionChangedSubtitle() {
        this.srtText.setText(this.lastSubtitle.getText());
        this.newSrtButton.setEnabled(false);
        this.editSrtButton.setEnabled(true);
        this.deleteSrtButton.setEnabled(true);
        this.expand_leftButton.setEnabled(true);
        this.expand_rightButton.setEnabled(true);
        this.decrese_leftButton.setEnabled(true);
        this.decrese_rightButton.setEnabled(true);
        this.move_leftButton.setEnabled(true);
        this.move_rightButton.setEnabled(true);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.mix_subtitle"), false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.split_subtitle"), true);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.subtitle_copy_text"), false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.select_before"), false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.select_about"), false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.select_after"), false);
        this.popUpMenuControler.setEnabled(Messages.getString("waveformview.normalize_subtitle"), true);
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public DropMonitor(Composite controler) {
            Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
            int operations = 3;
            DropTarget target2 = new DropTarget((Control)controler, operations);
            target2.setTransfer(types);
            target2.addDropListener((DropTargetListener)this);
        }

        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            String[] files = (String[])event.data;
            int i = 0;
            while (i < files.length) {
                File file = new File(files[i]);
                if (file.isFile() && file.getName().toLowerCase().endsWith(".wav")) {
                    WaveFormViewer.this.openFile(file);
                    break;
                }
                ++i;
            }
        }
    }

    public class InputKey
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            String text = ((Button)e.getSource()).getText();
            if (WaveFormViewer.this.lastSubtitle != null) {
                WaveFormViewer.this.lastSubtitle.setText(text);
                WaveFormViewer.this.srtText.setText(text);
                WaveFormViewer.this.setSubtitleModified(true);
                WaveFormViewer.this.srtFigure.repaint();
            } else if (WaveFormViewer.this.waveInfoCanvas.getSelection() != null) {
                WaveFormViewer.this.subtitleNewSelection(text);
                WaveFormViewer.this.setSubtitleModified(true);
            }
            WaveFormViewer.this.setFocus();
        }
    }

    public class MenuControler {
        private Map<String, MenuItem> itemMap = new HashMap<String, MenuItem>();

        public MenuItem createPushMenu(Menu parent, String label) {
            return this.createPushMenu(parent, label, label);
        }

        public MenuItem createPushMenu(Menu parent, String label, String key) {
            MenuItem item = WidgetBuilder.createPushMenu(parent, label);
            this.itemMap.put(key, item);
            return item;
        }

        public MenuItem createSeparateMenu(Menu parent) {
            return WidgetBuilder.createSeparateMenu(parent);
        }

        public MenuItem getMenuItem(String key) {
            return this.itemMap.get(key);
        }

        public void setEnabled(String key, boolean bool) {
            MenuItem item = this.getMenuItem(key);
            if (item != null) {
                item.setEnabled(bool);
            }
        }
    }

    public class KeyActions
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
            char cfr_ignored_0 = e.character;
            if (e.keyCode == 32 || e.character == '\u3000') {
                WaveFormViewer.this.waveFormFigureCanvasAudioPlayer.play();
            } else if (e.keyCode == 0x1000003) {
                if ((e.stateMask & 0x40000) != 0 && (e.stateMask & 0x20000) != 0) {
                    WaveFormViewer.this.selectionDecrese(-1);
                } else if ((e.stateMask & 0x40000) != 0) {
                    WaveFormViewer.this.selectionMove(-1);
                } else if ((e.stateMask & 0x20000) != 0) {
                    WaveFormViewer.this.selectionExpand(-1);
                }
            } else if (e.keyCode == 0x1000004) {
                if ((e.stateMask & 0x40000) != 0 && (e.stateMask & 0x20000) != 0) {
                    WaveFormViewer.this.selectionDecrese(1);
                } else if ((e.stateMask & 0x40000) != 0) {
                    WaveFormViewer.this.selectionMove(1);
                } else if ((e.stateMask & 0x20000) != 0) {
                    WaveFormViewer.this.selectionExpand(1);
                }
            } else if (e.keyCode == 127) {
                if (WaveFormViewer.this.lastSubtitle != null) {
                    WaveFormViewer.this.subtitleDelete();
                }
            } else if ((e.stateMask & 0x40000) != 0) {
                if (e.keyCode == 97) {
                    WaveFormViewer.this.selectAll();
                } else if (e.keyCode == 100) {
                    WaveFormViewer.this.subtitleNewSelection(WaveFormViewer.this.srtText.getText());
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    public class FinishedOpenedFile
    implements Runnable {
        public void run() {
            WaveFormViewer.this.openWavButton.setText(Messages.getString("waveformview.open"));
            WaveFormViewer.this.opening = false;
            WaveFormViewer.this.monitor.done();
            if (WaveFormViewer.this.cancelOpenFile) {
                StatusBarUtils.showStatusBar(Messages.getString("waveformview.cancelled"));
            }
        }
    }

    public class RepaintFigure
    implements Runnable {
        private IFigure figure;

        public RepaintFigure(IFigure figure) {
            this.figure = figure;
        }

        public void run() {
            this.figure.repaint();
        }
    }

    public class ReValidateFigure
    implements Runnable {
        private IFigure figure;

        public ReValidateFigure(IFigure figure) {
            this.figure = figure;
        }

        public void run() {
            this.figure.revalidate();
        }
    }

    public class AddFigure
    implements Runnable {
        private Figure targetFigure;
        private Figure addFigure;

        public AddFigure(Figure targetFigure, Figure addFigure) {
            this.targetFigure = targetFigure;
            this.addFigure = addFigure;
        }

        public void run() {
            this.targetFigure.add((IFigure)this.addFigure);
        }
    }

    public class SpectramImageSaved
    implements SpectrogramListener {
        public void imageSaved(String path) {
            WaveFormViewer.this.getSite().getShell().getDisplay().syncExec((Runnable)new ReValidateFigure((IFigure)WaveFormViewer.this.spectrogramListFigure));
        }
    }

    public class BackgroundOpen
    extends Thread {
        private File file;

        public BackgroundOpen(File file) {
            this.file = file;
        }

        public void run() {
            if (!WaveFormViewer.this.cancelOpenFile) {
                WaveFormViewer.this.parsePitchView(this.file);
                WaveFormViewer.this.getSite().getShell().getDisplay().syncExec((Runnable)new RepaintFigure(WaveFormViewer.this.pitchViewFigure));
            }
            if (!WaveFormViewer.this.cancelOpenFile) {
                WaveFormViewer.this.parseSpectramAndFormant(this.file);
            }
            WaveFormViewer.this.getSite().getShell().getDisplay().syncExec((Runnable)new FinishedOpenedFile());
        }
    }

    public class SpectragramMonitor
    implements ProgressMonitor {
        public boolean isCanceled() {
            return false;
        }

        public void worked(int v) {
            ProgressMonitorUtils.workedMonitor(WaveFormViewer.this.monitor, v);
        }
    }

    public class SpectroGramZoomChange
    implements Runnable {
        private double zoom;

        public SpectroGramZoomChange(double zoom) {
            this.zoom = zoom;
        }

        public void run() {
            WaveFormViewer.this.spectrogramListFigure.setZoom(this.zoom, 1.0);
        }
    }

    public class InitializeSpectramFigure
    implements Runnable {
        private int imageWidth;
        private int compositeHeight;
        private int totalPixelSize;
        private FileImageCache imageCache;
        private File baseFolder;

        public InitializeSpectramFigure(int imageWidth, int compositeHeight, int totalPixelSize, FileImageCache imageCache, File baseFolder) {
            this.imageWidth = imageWidth;
            this.compositeHeight = compositeHeight;
            this.totalPixelSize = totalPixelSize;
            this.imageCache = imageCache;
            this.baseFolder = baseFolder;
        }

        public void run() {
            WaveFormViewer.this.spectrogramListFigure.init(this.imageWidth, this.compositeHeight, this.totalPixelSize, this.imageCache, this.baseFolder);
        }
    }

    public class SetFormantData
    extends Thread {
        private SmallFormant[] formants;
        private long spectrogramLength;

        public SetFormantData(SmallFormant[] formants, long spectrogramLength) {
            this.spectrogramLength = spectrogramLength;
            this.formants = formants;
        }

        public void run() {
            WaveFormViewer.this.setFormantData(this.formants, this.spectrogramLength);
        }
    }

    public class SplitMonitor
    implements AudioProgressListener {
        IProgressMonitor monitor;

        public SplitMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void worked(int arg0) {
            ProgressMonitorUtils.workedMonitor(this.monitor, 1, true);
        }

        public boolean isStopped() {
            return this.monitor.isCanceled();
        }

        public void setStopped(boolean arg0) {
        }
    }
}

