/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.audio;

import jp.sourceforge.akjrcp.audio.Messages;
import jp.sourceforge.akjrcp.audio.MpegAudioFormatUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WavAudioSettingComposite
extends Composite {
    public static final String FRAMERATE = "FRAMERATE";
    public static final String CHANNEL = "CHANNEL";
    public static final int SAME_SOURCE = -1;
    private String preferenceKey;
    private IPreferenceStore preferenceStore;
    private CCombo frameRate;
    private CCombo channel;

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void setPreferenceKey(String preferenceKey) {
        this.preferenceKey = preferenceKey;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.preferenceStore = store;
        if (this.preferenceStore.contains(String.valueOf(this.preferenceKey) + "." + FRAMERATE)) {
            int fr = this.preferenceStore.getInt(String.valueOf(this.preferenceKey) + "." + FRAMERATE);
            this.setFrameRate(fr);
        }
        if (this.preferenceStore.contains(String.valueOf(this.preferenceKey) + "." + CHANNEL)) {
            int ch = this.preferenceStore.getInt(String.valueOf(this.preferenceKey) + "." + CHANNEL);
            System.out.println("channel:" + ch);
            this.setChannel(ch);
        }
    }

    public void updateStoreValue(String value, CCombo combo) {
        int s = combo.getItemCount();
        int i = 0;
        while (i < s) {
            if (value.equals(combo.getItem(i))) {
                combo.select(i);
                return;
            }
            ++i;
        }
        combo.select(0);
    }

    public void updateFramerate(int[] framerates) {
        int oldbitrate = this.getFramerate();
        this.frameRate.removeAll();
        this.frameRate.add(Messages.getString("MP3AudioSettingComposite.same_source"));
        int i = 0;
        while (i < framerates.length) {
            this.frameRate.add("" + framerates[i]);
            ++i;
        }
        this.updateStoreValue("" + oldbitrate, this.frameRate);
    }

    public int toStoredValue(CCombo combo) {
        String value = "";
        value = combo.getSelectionIndex() <= 0 ? "-1" : (combo != this.channel ? combo.getItem(combo.getSelectionIndex()) : "" + combo.getSelectionIndex());
        return Integer.parseInt(value);
    }

    public void setChannel(int ch) {
        if (ch > 0) {
            this.channel.select(ch);
        } else {
            this.channel.select(0);
        }
    }

    public int getChannel() {
        if (this.channel.getSelectionIndex() == 0) {
            return -1;
        }
        return this.channel.getSelectionIndex();
    }

    public void setFrameRate(int framerate) {
        this.updateStoreValue("" + framerate, this.frameRate);
    }

    public int getFramerate() {
        if (this.frameRate.getSelectionIndex() <= 0) {
            return -1;
        }
        return Integer.parseInt(this.frameRate.getItem(this.frameRate.getSelectionIndex()));
    }

    public void setEnabled(boolean bool) {
        super.setEnabled(bool);
        this.frameRate.setEnabled(bool);
        this.channel.setEnabled(bool);
    }

    public WavAudioSettingComposite(Composite parent, int style, boolean horizontal, String preferenceKey) {
        super(parent, style);
        this.preferenceKey = preferenceKey;
        if (horizontal) {
            this.setLayout((Layout)new RowLayout());
        } else {
            this.setLayout((Layout)new GridLayout(3, false));
        }
        Label label4 = new Label((Composite)this, 0);
        label4.setText(Messages.getString("MP3AudioSettingComposite.convertframerate"));
        this.frameRate = new CCombo((Composite)this, 8);
        this.frameRate.add(Messages.getString("MP3AudioSettingComposite.same_source"));
        Label label41 = new Label((Composite)this, 0);
        label41.setText("hz");
        this.updateFramerate(MpegAudioFormatUtil.all_framerate);
        this.setFrameRate(44100);
        Label label5 = new Label((Composite)this, 0);
        label5.setText(Messages.getString("MP3AudioSettingComposite.convertchannel"));
        this.channel = new CCombo((Composite)this, 8);
        this.channel.add(Messages.getString("MP3AudioSettingComposite.same_source"));
        this.channel.add(Messages.getString("monoral"));
        this.channel.add(Messages.getString("stereo"));
        this.channel.select(2);
        ValueChanged valueChanged = new ValueChanged();
        this.frameRate.addSelectionListener((SelectionListener)valueChanged);
        this.channel.addSelectionListener((SelectionListener)valueChanged);
        this.pack();
    }

    public class ValueChanged
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == WavAudioSettingComposite.this.frameRate) {
                if (WavAudioSettingComposite.this.preferenceStore != null) {
                    WavAudioSettingComposite.this.preferenceStore.setValue(String.valueOf(WavAudioSettingComposite.this.preferenceKey) + "." + WavAudioSettingComposite.FRAMERATE, WavAudioSettingComposite.this.toStoredValue(WavAudioSettingComposite.this.frameRate));
                }
            } else if (e.getSource() == WavAudioSettingComposite.this.channel && WavAudioSettingComposite.this.preferenceStore != null) {
                WavAudioSettingComposite.this.preferenceStore.setValue(String.valueOf(WavAudioSettingComposite.this.preferenceKey) + "." + WavAudioSettingComposite.CHANNEL, WavAudioSettingComposite.this.toStoredValue(WavAudioSettingComposite.this.channel));
            }
        }
    }
}

