/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.standalone.ScriptedCommand;

public class RemoveSiteCommand
extends ScriptedCommand {
    private IConfiguredSite csite;
    private File sitePath;

    public RemoveSiteCommand(String toSite) throws Exception {
        block8: {
            if (toSite != null) {
                this.sitePath = new File(toSite);
                if (!this.sitePath.getName().equals("eclipse")) {
                    this.sitePath = new File(this.sitePath, "eclipse");
                }
                if (!this.sitePath.exists()) {
                    throw new Exception(String.valueOf(Messages.Standalone_noSite) + toSite);
                }
                IConfiguredSite[] csites = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites();
                int i = 0;
                while (i < csites.length) {
                    File f = new File(csites[i].getSite().getURL().getFile());
                    if (f.equals(this.sitePath)) {
                        this.csite = csites[i];
                        break;
                    }
                    ++i;
                }
                if (this.csite == null) {
                    throw new Exception(String.valueOf(Messages.Standalone_noConfiguredSite) + toSite);
                }
                break block8;
            }
            throw new Exception(Messages.Standalone_noSite3);
        }
    }

    public boolean run(IProgressMonitor monitor) {
        IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
        if (status != null) {
            UpdateCore.log(status);
            return false;
        }
        try {
            this.getConfiguration().removeConfiguredSite(this.csite);
            this.getConfiguration().getConfiguredSites();
            SiteManager.getLocalSite().save();
            return true;
        }
        catch (CoreException e) {
            UpdateCore.log(e);
            return false;
        }
    }
}

