/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.internal.menus.IMenuContribution;
import org.eclipse.ui.internal.menus.IMenuService;
import org.eclipse.ui.internal.menus.MenuAuthority;
import org.eclipse.ui.internal.menus.MenuContribution;
import org.eclipse.ui.internal.menus.MenuElement;
import org.eclipse.ui.internal.menus.SActionSet;
import org.eclipse.ui.internal.menus.SGroup;
import org.eclipse.ui.internal.menus.SItem;
import org.eclipse.ui.internal.menus.SMenu;
import org.eclipse.ui.internal.menus.SMenuLayout;
import org.eclipse.ui.internal.menus.SWidget;

public final class WindowMenuService
implements IMenuService {
    private final MenuAuthority menuAuthority;
    private final IMenuService parent;

    public WindowMenuService(IMenuService parent, Window window) {
        if (parent == null) {
            throw new NullPointerException("The parent service must not be null");
        }
        if (window == null) {
            throw new NullPointerException("The window must not be null");
        }
        this.menuAuthority = new MenuAuthority(window);
        this.parent = parent;
    }

    public final void addSourceProvider(ISourceProvider provider) {
        this.menuAuthority.addSourceProvider(provider);
    }

    public final IMenuContribution contributeMenu(MenuElement menuElement) {
        return this.contributeMenu(menuElement, null);
    }

    public final IMenuContribution contributeMenu(MenuElement menuElement, Expression expression) {
        MenuContribution contribution = new MenuContribution(menuElement, expression, this);
        this.menuAuthority.contributeMenu(contribution);
        return contribution;
    }

    public final void dispose() {
        this.menuAuthority.dispose();
    }

    public final SActionSet getActionSet(String actionSetId) {
        return this.parent.getActionSet(actionSetId);
    }

    public final SActionSet[] getDefinedActionSets() {
        return this.parent.getDefinedActionSets();
    }

    public final SGroup[] getDefinedGroups() {
        return this.parent.getDefinedGroups();
    }

    public final SItem[] getDefinedItems() {
        return this.parent.getDefinedItems();
    }

    public final SMenu[] getDefinedMenus() {
        return this.parent.getDefinedMenus();
    }

    public final SWidget[] getDefinedWidgets() {
        return this.parent.getDefinedWidgets();
    }

    public final SGroup getGroup(String groupId) {
        return this.parent.getGroup(groupId);
    }

    public final SItem getItem(String itemId) {
        return this.parent.getItem(itemId);
    }

    public final SMenuLayout getLayout() {
        return this.parent.getLayout();
    }

    public final SMenu getMenu(String menuId) {
        return this.parent.getMenu(menuId);
    }

    public final SWidget getWidget(String widgetId) {
        return this.parent.getWidget(widgetId);
    }

    public final void readRegistry() {
        this.parent.readRegistry();
    }

    public final void removeContribution(IMenuContribution contribution) {
        if (contribution.getMenuService() == this) {
            this.menuAuthority.removeContribution(contribution);
        }
    }

    public final void removeContributions(Collection contributions) {
        Iterator contributionItr = contributions.iterator();
        while (contributionItr.hasNext()) {
            IMenuContribution contribution = (IMenuContribution)contributionItr.next();
            this.removeContribution(contribution);
        }
    }

    public final void removeSourceProvider(ISourceProvider provider) {
        this.menuAuthority.removeSourceProvider(provider);
    }
}

