/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import jp.sourceforge.akjrcp.ui.AbstractParamItem;
import jp.sourceforge.akjrcp.ui.Messages;
import jp.sourceforge.akjrcp.util.ColorUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ParamColor
extends AbstractParamItem {
    private String key;
    private String label;
    private Label labelItem;
    private String value = "";
    private Label colorLabel;
    private RGB rgb;
    private Composite self = this;

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public void setToolTipText(String text) {
        this.labelItem.setToolTipText(text);
        this.colorLabel.setToolTipText(text);
    }

    public String getValue() {
        if (this.rgb == null) {
            return "";
        }
        return ColorUtils.rgbToHex(this.rgb);
    }

    private void updateColor(String hex) {
        this.value = hex;
        this.rgb = ColorUtils.hexToRGB(hex);
        this.updateColor();
    }

    private void updateColor() {
        if (this.rgb == null) {
            this.colorLabel.setText("  X  ");
            this.colorLabel.setBackground(null);
        } else {
            System.out.println(this.rgb);
            this.colorLabel.setText("     ");
            this.colorLabel.setBackground(new Color(null, this.rgb));
        }
    }

    public void setValue(String value) {
        this.updateColor(value);
        this.value = value;
    }

    public ParamColor(Composite parent, int style, String key, String label) {
        super(parent, style);
        this.key = key;
        this.label = label;
        this.setLayout((Layout)new GridLayout(2, false));
        this.labelItem = new Label((Composite)this, 0);
        this.labelItem.setText(label);
        Composite colorItems = new Composite((Composite)this, 0);
        colorItems.setLayout((Layout)new GridLayout(3, false));
        this.colorLabel = new Label(colorItems, 2048);
        this.colorLabel.setText("  X  ");
        Button colorButton = new Button(colorItems, 0);
        colorButton.setText(Messages.getString("choose_color"));
        colorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RGB newrgb;
                ColorDialog dialog = new ColorDialog(ParamColor.this.self.getShell());
                if (ParamColor.this.rgb != null) {
                    dialog.setRGB(ParamColor.this.rgb);
                }
                if ((newrgb = dialog.open()) != null) {
                    Color bg = ParamColor.this.colorLabel.getBackground();
                    if (bg != null) {
                        bg.dispose();
                    }
                    ParamColor.this.rgb = newrgb;
                    ParamColor.this.updateColor();
                }
            }
        });
        colorButton.addSelectionListener((SelectionListener)new AbstractParamItem.SelectionCheck());
        Button resetButton = new Button(colorItems, 0);
        resetButton.setText(Messages.getString("reset_color"));
        resetButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ParamColor.this.rgb = null;
                ParamColor.this.updateColor();
            }
        });
        resetButton.addSelectionListener((SelectionListener)new AbstractParamItem.SelectionCheck());
    }

    public boolean isModified() {
        String oldValue = this.getValue();
        return !oldValue.equals(this.value);
    }

    public RGB getRgb() {
        return this.rgb;
    }

    public void setRgb(RGB rgb) {
        this.rgb = rgb;
    }
}

