/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class EditableFileList
extends TableViewer {
    public static Log log = LogFactory.getLog(EditableFileList.class);
    protected ArrayList fileList = new ArrayList();
    private MenuItem moveTop;
    private MenuItem moveBottom;
    private MenuItem moveUp;
    private MenuItem moveDown;
    private MenuItem removeFile;
    protected FilenameFilter filenameFilter;
    private MenuItem addfile;

    public void removeFile() {
        log.info((Object)"remove");
        File[] files = this.getSelectionFiles();
        int i = 0;
        while (i < files.length) {
            this.fileList.remove(files[0]);
            ++i;
        }
    }

    public void moveUp() {
        File[] files = this.getSelectionFiles();
        if (files.length == 1) {
            int index = this.fileList.indexOf(files[0]);
            this.fileList.remove(files[0]);
            this.fileList.add(Math.max(0, index - 1), files[0]);
        }
    }

    public void moveDown() {
        File[] files = this.getSelectionFiles();
        if (files.length == 1) {
            int index = this.fileList.indexOf(files[0]);
            this.fileList.remove(files[0]);
            this.fileList.add(Math.min(this.fileList.size(), index + 1), files[0]);
        }
    }

    public void moveTop() {
        File[] files = this.getSelectionFiles();
        if (files.length == 1) {
            this.fileList.remove(files[0]);
            this.fileList.add(0, files[0]);
        }
    }

    public void moveBottom() {
        File[] files = this.getSelectionFiles();
        if (files.length == 1) {
            this.fileList.remove(files[0]);
            this.fileList.add(files[0]);
        }
    }

    public EditableFileList(Composite parent, int style) {
        super(parent, style);
        this.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.setContentProvider((IContentProvider)new ViewContentProvider());
        MenuSelection selection = new MenuSelection();
        Menu menu1 = new Menu((Control)this.getTable());
        this.getTable().setMenu(menu1);
        this.addfile = new MenuItem(menu1, 8);
        this.addfile.setText(Messages.getString("FileListTable.addfile"));
        this.addfile.addSelectionListener((SelectionListener)selection);
        new MenuItem(menu1, 2);
        this.moveTop = new MenuItem(menu1, 8);
        this.moveTop.setText(Messages.getString("FileListTable.moveTop"));
        this.moveTop.addSelectionListener((SelectionListener)selection);
        this.moveBottom = new MenuItem(menu1, 8);
        this.moveBottom.setText(Messages.getString("FileListTable.moveBottom"));
        this.moveBottom.addSelectionListener((SelectionListener)selection);
        this.moveUp = new MenuItem(menu1, 8);
        this.moveUp.setText(Messages.getString("FileListTable.moveUp"));
        this.moveUp.addSelectionListener((SelectionListener)selection);
        this.moveDown = new MenuItem(menu1, 8);
        this.moveDown.setText(Messages.getString("FileListTable.moveDown"));
        this.moveDown.addSelectionListener((SelectionListener)selection);
        new MenuItem(menu1, 2);
        this.removeFile = new MenuItem(menu1, 8);
        this.removeFile.setText(Messages.getString("FileListTable.removeFile"));
        this.removeFile.addSelectionListener((SelectionListener)selection);
        this.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 127) {
                    EditableFileList.this.removeFile();
                    EditableFileList.this.refresh(true);
                }
            }
        });
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        int operations = 3;
        DropTarget target2 = new DropTarget((Control)this.getTable(), operations);
        target2.setTransfer(types);
        target2.addDropListener((DropTargetListener)new DropMonitor());
        this.getTable().setLinesVisible(true);
    }

    public void addDragAndDropFile(String path) {
        File file = new File(path);
        if (this.filenameFilter != null) {
            if (this.filenameFilter.accept(file.getParentFile(), file.getName())) {
                this.addFile(file);
            }
        } else {
            this.addFile(file);
        }
    }

    public EditableFileList(Composite parent) {
        super(parent);
        this.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.setContentProvider((IContentProvider)new ViewContentProvider());
    }

    protected void addFile(File file) {
        this.fileList.add(file);
        this.refresh(true);
    }

    public FilenameFilter getFilenameFilter() {
        return this.filenameFilter;
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filenameFilter = filenameFilter;
    }

    public File[] getFileList() {
        return this.fileList.toArray(new File[0]);
    }

    public File[] getSelectionFiles() {
        ISelection selection = this.getSelection();
        return ((IStructuredSelection)selection).toList().toArray(new File[0]);
    }

    public class MenuSelection
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() != EditableFileList.this.addfile) {
                if (e.getSource() == EditableFileList.this.moveTop) {
                    EditableFileList.this.moveTop();
                } else if (e.getSource() == EditableFileList.this.moveBottom) {
                    EditableFileList.this.moveBottom();
                } else if (e.getSource() == EditableFileList.this.moveUp) {
                    EditableFileList.this.moveUp();
                } else if (e.getSource() == EditableFileList.this.moveDown) {
                    EditableFileList.this.moveDown();
                } else if (e.getSource() == EditableFileList.this.removeFile) {
                    EditableFileList.this.removeFile();
                }
            }
            EditableFileList.this.refresh(true);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            String[] files = (String[])event.data;
            int i = 0;
            while (i < files.length) {
                EditableFileList.this.addDragAndDropFile(files[i]);
                ++i;
            }
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return EditableFileList.this.fileList.toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return ((File)obj).getAbsolutePath();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

