/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.ProgressReadListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProgressProcessMonitor {
    Log log = LogFactory.getLog(ProgressProcessMonitor.class);
    Process process;
    boolean monitor;
    private boolean monitorInput = true;
    private boolean monitorError = true;
    private ProgressReadListener progressReadListener;
    InputStream inputReader;
    InputStream errorReader;

    public ProgressProcessMonitor(Process process) {
        this.process = process;
    }

    public ProgressReadListener getProgressReadListener() {
        return this.progressReadListener;
    }

    public void setProgressReadListener(ProgressReadListener progressReadListener) {
        this.progressReadListener = progressReadListener;
    }

    public void startMonitor() {
        this.monitor = true;
        if (this.monitorError) {
            new ErrorMonitor().start();
        }
        if (this.monitorInput) {
            new InputMonitor().start();
        }
    }

    public void stop() {
        try {
            this.inputReader.close();
            this.errorReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isMonitorInput() {
        return this.monitorInput;
    }

    public void setMonitorInput(boolean monitorInput) {
        this.monitorInput = monitorInput;
    }

    public boolean isMonitorError() {
        return this.monitorError;
    }

    public void setMonitorError(boolean monitorError) {
        this.monitorError = monitorError;
    }

    public class ErrorMonitor
    extends Thread {
        public void run() {
            ProgressProcessMonitor.this.errorReader = ProgressProcessMonitor.this.process.getErrorStream();
            StringBuffer buffer = new StringBuffer();
            try {
                String error;
                int b;
                while ((b = ProgressProcessMonitor.this.errorReader.read()) != -1) {
                    if ((char)b == '\n') {
                        error = buffer.toString();
                        if (FFMpegUtils.isProgressString(error) && ProgressProcessMonitor.this.progressReadListener != null) {
                            ProgressProcessMonitor.this.progressReadListener.progress(error);
                        }
                        buffer = new StringBuffer();
                        continue;
                    }
                    if ((char)b == '\r') {
                        error = buffer.toString();
                        if (FFMpegUtils.isProgressString(error) && ProgressProcessMonitor.this.progressReadListener != null) {
                            ProgressProcessMonitor.this.progressReadListener.progress(error);
                        }
                        buffer = new StringBuffer();
                        continue;
                    }
                    buffer.append((char)b);
                }
                ProgressProcessMonitor.this.errorReader.close();
                if (buffer.length() > 0 && FFMpegUtils.isProgressString(error = buffer.toString()) && ProgressProcessMonitor.this.progressReadListener != null) {
                    ProgressProcessMonitor.this.progressReadListener.progress(error);
                }
            }
            catch (IOException e) {
                try {
                    ProgressProcessMonitor.this.errorReader.close();
                    ProgressProcessMonitor.this.inputReader.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        }
    }

    public class InputMonitor
    extends Thread {
        public void run() {
            ProgressProcessMonitor.this.inputReader = ProgressProcessMonitor.this.process.getInputStream();
            byte[] tmp = new byte[10240];
            BufferedInputStream binput = new BufferedInputStream(ProgressProcessMonitor.this.inputReader);
            try {
                while (binput.read(tmp) != -1) {
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

