/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.SiteBookmark;

public class LocalSiteSelector {
    static String lastLocation = null;

    public static SiteBookmark getLocaLSite(Shell parent, SiteBookmark[] siteBookmarks) {
        DirectoryDialog dialog = new DirectoryDialog(parent);
        dialog.setMessage(UpdateUIMessages.LocalSiteSelector_dialogMessage);
        dialog.setFilterPath(lastLocation);
        String dir = dialog.open();
        SiteBookmark siteBookmark = null;
        while (dir != null && siteBookmark == null) {
            File dirFile = new File(dir);
            if (LocalSiteSelector.isDirSite(dirFile)) {
                if (!LocalSiteSelector.isDuplicate(dirFile, siteBookmarks)) {
                    siteBookmark = LocalSiteSelector.createDirSite(dirFile);
                    lastLocation = dir;
                    continue;
                }
                MessageDialog.openInformation((Shell)parent, (String)UpdateUIMessages.LocalSiteSelector_dirInfoTitle, (String)UpdateUIMessages.LocalSiteSelector_dirDuplicateDefinition);
                dialog.setFilterPath(dir);
                dir = dialog.open();
                continue;
            }
            MessageDialog.openInformation((Shell)parent, (String)UpdateUIMessages.LocalSiteSelector_dirInfoTitle, (String)UpdateUIMessages.LocalSiteSelector_dirInfoMessage);
            dialog.setFilterPath(dir);
            dir = dialog.open();
        }
        return siteBookmark;
    }

    public static SiteBookmark getLocaLZippedSite(Shell parent, SiteBookmark[] siteBookmarks) {
        FileDialog dialog = new FileDialog(parent);
        dialog.setText(UpdateUIMessages.LocalSiteSelector_dialogMessagezip);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        SiteBookmark siteBookmark = null;
        String zip = dialog.open();
        while (zip != null && siteBookmark == null) {
            File zipF = new File(zip);
            if (LocalSiteSelector.isZipSite(zipF)) {
                siteBookmark = LocalSiteSelector.createZipSite(zipF);
                if (!LocalSiteSelector.isDuplicate(siteBookmark.getURL(), siteBookmarks)) continue;
                MessageDialog.openInformation((Shell)parent, (String)UpdateUIMessages.LocalSiteSelector_zipInfoTitle, (String)UpdateUIMessages.LocalSiteSelector_zipDuplicateDefinition);
                siteBookmark = null;
                zip = dialog.open();
                continue;
            }
            MessageDialog.openInformation((Shell)parent, (String)UpdateUIMessages.LocalSiteSelector_zipInfoTitle, (String)UpdateUIMessages.LocalSiteSelector_zipInfoMessage);
            zip = dialog.open();
        }
        return siteBookmark;
    }

    static boolean isZipSite(File file) {
        if (!file.getName().toLowerCase().endsWith(".zip") && !file.getName().toLowerCase().endsWith(".jar")) {
            return false;
        }
        ZippedSiteValidator validator = new ZippedSiteValidator(file);
        BusyIndicator.showWhile((Display)UpdateUI.getActiveWorkbenchShell().getDisplay(), (Runnable)validator);
        return validator.isValid();
    }

    static boolean isDirSite(File dir) {
        File siteXML = new File(dir, "site.xml");
        File featuresDir = new File(dir, "features");
        File pluginsDir = new File(dir, "plugins");
        return siteXML.exists() || featuresDir.exists() && featuresDir.isDirectory() && pluginsDir.exists() && pluginsDir.isDirectory();
    }

    static SiteBookmark createZipSite(File file) {
        try {
            URL fileURL = new URL("file", null, file.getAbsolutePath());
            URL url = new URL("jar:" + fileURL.toExternalForm().replace('\\', '/') + "!/");
            SiteBookmark site = new SiteBookmark(file.getName(), url, false);
            site.setLocal(true);
            return site;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static SiteBookmark createDirSite(File file) {
        try {
            URL url = file.toURL();
            String parent = file.getParent();
            parent = parent == null ? "" : new File(parent).getName();
            String siteName = String.valueOf(parent) + "/" + file.getName();
            SiteBookmark site = new SiteBookmark(siteName, url, false);
            site.setLocal(true);
            return site;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean isDuplicate(File file, SiteBookmark[] siteBookmarks) {
        try {
            return LocalSiteSelector.isDuplicate(file.toURL(), siteBookmarks);
        }
        catch (MalformedURLException mue) {
            UpdateUI.logException(mue);
            return false;
        }
    }

    private static boolean isDuplicate(URL url, SiteBookmark[] siteBookmarks) {
        if (siteBookmarks == null) {
            return false;
        }
        int i = 0;
        while (i < siteBookmarks.length) {
            if (siteBookmarks[i].getURL().equals(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static class ZippedSiteValidator
    implements Runnable {
        File file;
        boolean valid = false;

        public ZippedSiteValidator(File file) {
            this.file = file;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block15: {
                block14: {
                    siteZip = null;
                    try {
                        try {
                            siteZip = new ZipFile(this.file);
                            if (siteZip.getEntry("site.xml") != null) {
                                this.valid = true;
lbl8:
                                // 2 sources

                                while (true) {
                                    var6_2 = null;
                                    break block14;
                                    break;
                                }
                            }
                            hasFeatures = false;
                            hasPlugins = false;
                            iterator = siteZip.entries();
                            while (iterator.hasMoreElements()) {
                                zEntry = iterator.nextElement();
                                if (!hasFeatures && zEntry.getName().startsWith("features")) {
                                    hasFeatures = true;
                                }
                                if (!hasPlugins && zEntry.getName().startsWith("plugins")) {
                                    hasPlugins = true;
                                }
                                if (!hasFeatures || !hasPlugins) continue;
                                this.valid = true;
                                ** continue;
lbl23:
                                // 1 sources

                                ** GOTO lbl8
                            }
                            break block15;
                        }
                        catch (Exception v0) {
                            break block15;
                        }
                    }
                    catch (Throwable var7_9) {
                        var6_3 = null;
                        try {
                            if (siteZip == null) throw var7_9;
                            siteZip.close();
                            throw var7_9;
                        }
                        catch (IOException v1) {}
                        throw var7_9;
                    }
                }
                try {}
                catch (IOException v2) {}
                if (siteZip == null) return;
                siteZip.close();
                return;
                return;
            }
            var6_4 = null;
            try {}
            catch (IOException v3) {
                return;
            }
            if (siteZip == null) return;
            siteZip.close();
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

