/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationHistory;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.NavigationHistoryAction;
import org.eclipse.ui.internal.NavigationHistoryEditorInfo;
import org.eclipse.ui.internal.NavigationHistoryEntry;
import org.eclipse.ui.internal.WorkbenchPage;

public class NavigationHistory
implements INavigationHistory {
    private static final int CAPACITY = 50;
    private NavigationHistoryAction backwardAction;
    private NavigationHistoryAction forwardAction;
    private int ignoreEntries;
    private ArrayList history = new ArrayList(50);
    private ArrayList editors = new ArrayList(50);
    private WorkbenchPage page;
    private int activeEntry = 0;

    public NavigationHistory(WorkbenchPage page) {
        this.page = page;
        page.addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                this.updateNavigationHistory(partRef, true);
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
                this.updateNavigationHistory(partRef, false);
            }

            private void updateNavigationHistory(IWorkbenchPartReference partRef, boolean partClosed) {
                if (partRef != null && partRef.getPart(false) instanceof IEditorPart) {
                    IEditorPart editor = (IEditorPart)partRef.getPart(false);
                    IEditorInput input = editor.getEditorInput();
                    String id = editor.getSite().getId();
                    Iterator e = NavigationHistory.this.editors.iterator();
                    NavigationHistoryEditorInfo info = null;
                    NavigationHistoryEditorInfo currentInfo = null;
                    NavigationHistoryEntry current = NavigationHistory.this.getEntry(NavigationHistory.this.activeEntry);
                    if (current != null) {
                        currentInfo = current.editorInfo;
                    }
                    while (e.hasNext()) {
                        info = (NavigationHistoryEditorInfo)e.next();
                        if (id.equals(info.editorID) && input.equals(info.editorInput)) {
                            if (!partClosed || info == currentInfo) break;
                            info.handlePartClosed();
                            break;
                        }
                        info = null;
                    }
                    if (info == null) {
                        return;
                    }
                    e = NavigationHistory.this.history.iterator();
                    int i = 0;
                    while (e.hasNext()) {
                        NavigationHistoryEntry entry = (NavigationHistoryEntry)e.next();
                        if (entry.editorInfo != info) continue;
                        if (!entry.handlePartClosed()) {
                            if (i < NavigationHistory.this.activeEntry) {
                                NavigationHistory navigationHistory = NavigationHistory.this;
                                navigationHistory.activeEntry = navigationHistory.activeEntry - 1;
                            } else if (i == NavigationHistory.this.activeEntry) {
                                if (i != 0) {
                                    NavigationHistory navigationHistory = NavigationHistory.this;
                                    navigationHistory.activeEntry = navigationHistory.activeEntry - 1;
                                }
                            } else {
                                ++i;
                            }
                            e.remove();
                            entry.dispose();
                            continue;
                        }
                        ++i;
                    }
                    NavigationHistory.this.updateActions();
                }
            }
        });
    }

    private Display getDisplay() {
        return this.page.getWorkbenchWindow().getShell().getDisplay();
    }

    public void markEditor(final IEditorPart part) {
        if (this.ignoreEntries > 0 || part == null) {
            return;
        }
        ++this.ignoreEntries;
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                NavigationHistory navigationHistory = NavigationHistory.this;
                navigationHistory.ignoreEntries = navigationHistory.ignoreEntries - 1;
                EditorSite site = (EditorSite)part.getEditorSite();
                Control c = site.getPane().getControl();
                if (c == null || c.isDisposed()) {
                    return;
                }
                NavigationHistoryEntry e = NavigationHistory.this.getEntry(NavigationHistory.this.activeEntry);
                if (e != null && part.getEditorInput() != e.editorInfo.editorInput) {
                    NavigationHistory.this.updateEntry(e);
                }
                NavigationHistory.this.addEntry(part, true);
            }
        });
    }

    public void markLocation(IEditorPart part) {
        this.addEntry(part, true);
    }

    NavigationHistoryEntry[] getBackwardEntries() {
        int length = this.activeEntry;
        NavigationHistoryEntry[] entries = new NavigationHistoryEntry[length];
        int i = 0;
        while (i < this.activeEntry) {
            entries[this.activeEntry - 1 - i] = this.getEntry(i);
            ++i;
        }
        return entries;
    }

    NavigationHistoryEntry[] getForwardEntries() {
        int length = this.history.size() - this.activeEntry - 1;
        length = Math.max(0, length);
        NavigationHistoryEntry[] entries = new NavigationHistoryEntry[length];
        int i = this.activeEntry + 1;
        while (i < this.history.size()) {
            entries[i - this.activeEntry - 1] = this.getEntry(i);
            ++i;
        }
        return entries;
    }

    public INavigationLocation[] getLocations() {
        INavigationLocation[] result = new INavigationLocation[this.history.size()];
        int i = 0;
        while (i < result.length) {
            NavigationHistoryEntry e = (NavigationHistoryEntry)this.history.get(i);
            result[i] = e.location;
            ++i;
        }
        return result;
    }

    public INavigationLocation getCurrentLocation() {
        NavigationHistoryEntry entry = this.getEntry(this.activeEntry);
        return entry == null ? null : entry.location;
    }

    public void dispose() {
        Iterator e = this.history.iterator();
        while (e.hasNext()) {
            NavigationHistoryEntry entry = (NavigationHistoryEntry)e.next();
            this.disposeEntry(entry);
        }
    }

    public void setForwardAction(NavigationHistoryAction action) {
        this.forwardAction = action;
        this.updateActions();
    }

    public void setBackwardAction(NavigationHistoryAction action) {
        this.backwardAction = action;
        this.updateActions();
    }

    private NavigationHistoryEntry getEntry(int index) {
        if (index >= 0 && index < this.history.size()) {
            return (NavigationHistoryEntry)this.history.get(index);
        }
        return null;
    }

    private void add(NavigationHistoryEntry entry) {
        this.removeForwardEntries();
        if (this.history.size() == 50) {
            NavigationHistoryEntry e = (NavigationHistoryEntry)this.history.remove(0);
            this.disposeEntry(e);
        }
        this.history.add(entry);
        this.activeEntry = this.history.size() - 1;
    }

    private void removeForwardEntries() {
        int length = this.history.size();
        int i = this.activeEntry + 1;
        while (i < length) {
            NavigationHistoryEntry e = (NavigationHistoryEntry)this.history.remove(this.activeEntry + 1);
            this.disposeEntry(e);
            ++i;
        }
    }

    private void addEntry(IEditorPart part, boolean markLocation) {
        NavigationHistoryEntry current;
        if (this.ignoreEntries > 0 || part == null) {
            return;
        }
        INavigationLocation location = null;
        if (markLocation && part instanceof INavigationLocationProvider) {
            location = ((INavigationLocationProvider)((Object)part)).createNavigationLocation();
        }
        if ((current = this.getEntry(this.activeEntry)) != null && current.editorInfo.memento != null) {
            current.editorInfo.restoreEditor();
            this.checkDuplicates(current.editorInfo);
        }
        NavigationHistoryEntry e = this.createEntry(this.page, part, location);
        if (current == null) {
            this.add(e);
        } else if (e.mergeInto(current)) {
            this.disposeEntry(e);
            this.removeForwardEntries();
        } else {
            this.add(e);
        }
        this.printEntries("added entry");
        this.updateActions();
    }

    private void printEntries(String label) {
    }

    boolean canForward() {
        return this.activeEntry + 1 >= 0 && this.activeEntry + 1 < this.history.size();
    }

    boolean canBackward() {
        return this.activeEntry - 1 >= 0 && this.activeEntry - 1 < this.history.size();
    }

    private void updateActions() {
        if (this.backwardAction != null) {
            this.backwardAction.update();
        }
        if (this.forwardAction != null) {
            this.forwardAction.update();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void gotoEntry(NavigationHistoryEntry entry) {
        if (entry == null) {
            return;
        }
        try {
            ++this.ignoreEntries;
            if (entry.editorInfo.memento != null) {
                entry.editorInfo.restoreEditor();
                this.checkDuplicates(entry.editorInfo);
            }
            entry.restoreLocation();
            this.updateActions();
            this.printEntries("goto entry");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            --this.ignoreEntries;
            throw throwable;
        }
        {
            Object var2_4 = null;
            --this.ignoreEntries;
            return;
        }
    }

    private void updateEntry(NavigationHistoryEntry activeEntry) {
        if (activeEntry == null || activeEntry.location == null) {
            return;
        }
        activeEntry.location.update();
        this.printEntries("updateEntry");
    }

    public void forward() {
        if (this.canForward()) {
            this.shiftEntry(true);
        }
    }

    public void backward() {
        if (this.canBackward()) {
            this.shiftEntry(false);
        }
    }

    private void shiftEntry(boolean forward) {
        this.updateEntry(this.getEntry(this.activeEntry));
        this.activeEntry = forward ? ++this.activeEntry : --this.activeEntry;
        NavigationHistoryEntry entry = this.getEntry(this.activeEntry);
        if (entry != null) {
            this.gotoEntry(entry);
        }
    }

    protected void shiftCurrentEntry(NavigationHistoryEntry entry) {
        this.updateEntry(this.getEntry(this.activeEntry));
        this.activeEntry = this.history.indexOf(entry);
        this.gotoEntry(entry);
    }

    void saveState(IMemento memento) {
        NavigationHistoryEntry entry;
        NavigationHistoryEntry cEntry = this.getEntry(this.activeEntry);
        if (cEntry == null || !cEntry.editorInfo.isPersistable()) {
            return;
        }
        ArrayList editors = (ArrayList)this.editors.clone();
        Iterator iter = editors.iterator();
        while (iter.hasNext()) {
            NavigationHistoryEditorInfo info = (NavigationHistoryEditorInfo)iter.next();
            if (info.isPersistable()) continue;
            iter.remove();
        }
        IMemento editorsMem = memento.createChild("editors");
        Iterator iter2 = editors.iterator();
        while (iter2.hasNext()) {
            NavigationHistoryEditorInfo info = (NavigationHistoryEditorInfo)iter2.next();
            info.saveState(editorsMem.createChild("editor"));
        }
        ArrayList<NavigationHistoryEntry> list = new ArrayList<NavigationHistoryEntry>(this.history.size());
        int size = this.history.size();
        int i = 0;
        while (i < size) {
            entry = (NavigationHistoryEntry)this.history.get(i);
            if (entry.editorInfo.isPersistable()) {
                list.add(entry);
            }
            ++i;
        }
        size = list.size();
        i = 0;
        while (i < size) {
            entry = (NavigationHistoryEntry)list.get(i);
            IMemento childMem = memento.createChild("item");
            if (entry == cEntry) {
                childMem.putString("active", "true");
            }
            entry.saveState(childMem, list);
            childMem.putInteger("index", editors.indexOf(entry.editorInfo));
            ++i;
        }
    }

    void restoreState(IMemento memento) {
        IMemento editorsMem = memento.getChild("editors");
        IMemento[] items = memento.getChildren("item");
        if (items.length == 0 || editorsMem == null) {
            if (this.page.getActiveEditor() != null) {
                this.markLocation(this.page.getActiveEditor());
            }
            return;
        }
        IMemento[] children = editorsMem.getChildren("editor");
        NavigationHistoryEditorInfo[] editorsInfo = new NavigationHistoryEditorInfo[children.length];
        int i = 0;
        while (i < editorsInfo.length) {
            editorsInfo[i] = new NavigationHistoryEditorInfo(children[i]);
            this.editors.add(editorsInfo[i]);
            ++i;
        }
        i = 0;
        while (i < items.length) {
            IMemento item = items[i];
            int index = item.getInteger("index");
            NavigationHistoryEditorInfo info = editorsInfo[index];
            ++info.refCount;
            NavigationHistoryEntry entry = new NavigationHistoryEntry(info, this.page, null, null);
            this.history.add(entry);
            entry.restoreState(item);
            if (item.getString("active") != null) {
                this.activeEntry = i;
            }
            ++i;
        }
        NavigationHistoryEntry entry = this.getEntry(this.activeEntry);
        if (entry != null && entry.editorInfo.editorInput != null && this.page.getActiveEditor() == this.page.findEditor(entry.editorInfo.editorInput)) {
            this.gotoEntry(entry);
        }
    }

    public NavigationHistoryEntry createEntry(IWorkbenchPage page, IEditorPart part, INavigationLocation location) {
        String editorID = part.getSite().getId();
        IEditorInput editorInput = part.getEditorInput();
        NavigationHistoryEditorInfo info = null;
        Iterator iter = this.editors.iterator();
        while (iter.hasNext()) {
            info = (NavigationHistoryEditorInfo)iter.next();
            if (editorID.equals(info.editorID) && editorInput.equals(info.editorInput)) {
                ++info.refCount;
                break;
            }
            info = null;
        }
        if (info == null) {
            info = new NavigationHistoryEditorInfo(part);
            ++info.refCount;
            this.editors.add(info);
        }
        return new NavigationHistoryEntry(info, page, part, location);
    }

    public void disposeEntry(NavigationHistoryEntry entry) {
        if (entry.editorInfo == null) {
            return;
        }
        --entry.editorInfo.refCount;
        if (entry.editorInfo.refCount == 0) {
            this.editors.remove(entry.editorInfo);
        }
        entry.dispose();
    }

    void checkDuplicates(NavigationHistoryEditorInfo info) {
        NavigationHistoryEditorInfo dup = null;
        if (info.editorInput == null) {
            return;
        }
        Iterator iter = this.editors.iterator();
        while (iter.hasNext()) {
            dup = (NavigationHistoryEditorInfo)iter.next();
            if (info != dup && info.editorID.equals(dup.editorID) && info.editorInput.equals(dup.editorInput)) break;
            dup = null;
        }
        if (dup == null) {
            return;
        }
        iter = this.history.iterator();
        while (iter.hasNext()) {
            NavigationHistoryEntry entry = (NavigationHistoryEntry)iter.next();
            if (entry.editorInfo != dup) continue;
            entry.editorInfo = info;
            ++info.refCount;
        }
        this.editors.remove(dup);
    }
}

