/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.index;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.index.IndexBuilder;
import org.eclipse.help.internal.index.IndexFile;
import org.eclipse.help.internal.toc.HrefUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IndexFileParser
extends DefaultHandler {
    private IndexBuilder builder;
    private IndexFile indexFile;
    private static SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private static XMLParserPool parserPool = new XMLParserPool();

    public IndexFileParser(IndexBuilder builder) {
        this.builder = builder;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(IndexFile file) {
        this.indexFile = file;
        InputStream istream = this.indexFile.getInputStream();
        if (istream == null) {
            return;
        }
        InputSource isource = new InputSource(istream);
        String filePath = "/" + file.getPluginID() + "/" + file.getHref();
        isource.setSystemId(filePath);
        try {
            SAXParser parser = parserPool.obtainParser();
            try {
                parser.parse(isource, (DefaultHandler)this);
                istream.close();
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                parserPool.releaseParser(parser);
                throw throwable;
            }
            {
                Object var6_11 = null;
                parserPool.releaseParser(parser);
                return;
            }
        }
        catch (ParserConfigurationException pce) {
            HelpPlugin.logError("SAXParser implementation could not be loaded.", pce);
            return;
        }
        catch (SAXException se) {
            HelpPlugin.logError("Error loading Index file " + file + ".", se);
            return;
        }
        catch (IOException ioe) {
            HelpPlugin.logError("Error loading Index file " + file + ".", ioe);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("entry")) {
            this.builder.exitIndexEntry();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("entry")) {
            this.builder.addIndexEntry(attributes.getValue("keyword"));
        } else if (qName.equals("topic")) {
            this.builder.addTopic(attributes.getValue("title"), HrefUtil.normalizeHref(this.indexFile.getPluginID(), attributes.getValue("href")), attributes.getValue("location"));
        } else {
            return;
        }
    }

    static class XMLParserPool {
        private ArrayList pool = new ArrayList();

        XMLParserPool() {
        }

        SAXParser obtainParser() throws ParserConfigurationException, SAXException {
            int free = this.pool.size();
            SAXParser p = free > 0 ? (SAXParser)this.pool.remove(free - 1) : parserFactory.newSAXParser();
            return p;
        }

        void releaseParser(SAXParser parser) {
            this.pool.add(parser);
        }
    }
}

