/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import jp.sourceforge.akjrcp.util.YoutubeDLExecuter;
import jp.sourceforge.akjrcp.util.YoutubeUtils;
import org.apache.commons.io.IOUtils;

public class URLDownloader {
    private FileOutputStream output;
    private YoutubeDLExecuter executer;
    private String youtubeDLPath;
    private String pythonPath;

    public String getPythonPath() {
        return this.pythonPath;
    }

    public void setPythonPath(String pythonPath) {
        this.pythonPath = pythonPath;
    }

    public String getYoutubeDLPath() {
        return this.youtubeDLPath;
    }

    public void setYoutubeDLPath(String youtubeDLPath) {
        this.youtubeDLPath = youtubeDLPath;
    }

    public void cancel() throws IOException {
        if (this.output != null) {
            this.output.close();
        }
        if (this.executer != null) {
            this.executer.cancel();
        }
    }

    public void download(URL url, File exportFile) throws IOException {
        if (!exportFile.getParentFile().exists()) {
            throw new IOException("directory not found:" + exportFile.getParentFile());
        }
        String urlText = url.toString();
        if (YoutubeUtils.isYoutubeVideoURL(urlText)) {
            this.executer = new YoutubeDLExecuter();
            this.executer.setYoutubeDLPath(this.youtubeDLPath);
            this.executer.setPythonPath(this.pythonPath);
            this.executer.setExportFile(exportFile);
            this.executer.execute(new URL[]{url});
            this.executer = null;
        } else {
            this.copyURLToFile(url, exportFile);
            this.output = null;
        }
    }

    public void copyURLToFile(URL source, File destination) throws IOException {
        InputStream input = source.openStream();
        try {
            this.output = URLDownloader.openOutputStream(destination);
            try {
                IOUtils.copy((InputStream)input, (OutputStream)this.output);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)this.output);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IOException("File '" + file + "' could not be created");
            }
        }
        return new FileOutputStream(file);
    }
}

