/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui.draw2d;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import jp.sourceforge.akjrcp.ui.draw2d.AlphaUtils;
import jp.sourceforge.akjrcp.ui.draw2d.TimeBasedFigure;
import jp.sourceforge.akjrcp.ui.draw2d.WaveFormFigureCanvas;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubtitleListFigure
extends TimeBasedFigure {
    public static Log log = LogFactory.getLog(SubtitleListFigure.class);
    List<StandardSubObject> standardSubObjectList = new ArrayList<StandardSubObject>();
    private Rectangle[] inRectangle;
    private int rectangleY = 0;
    private int rectangleHeight = 800;
    private Image labelImage;
    private String subObjectPath;
    private Shell shell;
    private RGB backgroundRGB = new RGB(200, 200, 200);

    public SubtitleListFigure(Shell shell, int arg0, int arg1, double splitFrame) {
        super(arg0, arg1, splitFrame);
        this.shell = shell;
        this.setColor(this.backgroundRGB);
    }

    public void add(StandardSubObject sub) {
        this.standardSubObjectList.add(sub);
        this.rerect();
        this.repaint();
    }

    public void remove(StandardSubObject sub) {
        this.standardSubObjectList.remove(sub);
        this.rerect();
        this.repaint();
    }

    public void setColor(RGB color) {
        this.labelImage = AlphaUtils.createColorAlphaImageData(new Color((Device)this.shell.getDisplay(), color), 128);
        this.backgroundRGB = color;
    }

    public void setStandardSubObjectList(List<StandardSubObject> list) {
        this.standardSubObjectList = list;
        this.inRectangle = null;
    }

    public StandardSubObject[] containSubtitles(int x, int y) {
        if (this.standardSubObjectList != null) {
            ArrayList<StandardSubObject> tmp = new ArrayList<StandardSubObject>();
            int i = 0;
            while (i < this.inRectangle.length) {
                if (this.inRectangle[i].contains(-this.getParent().getBounds().x + x, y)) {
                    tmp.add(this.standardSubObjectList.get(i));
                }
                ++i;
            }
            return tmp.toArray(new StandardSubObject[tmp.size()]);
        }
        return new StandardSubObject[0];
    }

    @Override
    public void updateScale() {
        this.rerect();
    }

    public StandardSubObject intersectItem(long time) {
        StandardSubObject[] subs = this.standardSubObjectList.toArray(new StandardSubObject[this.standardSubObjectList.size()]);
        int i = 0;
        while (i < subs.length) {
            if (time >= subs[i].getStartTime() && time <= subs[i].getEndTime()) {
                return subs[i];
            }
            ++i;
        }
        return null;
    }

    public StandardSubObject[] containSubtitles(WaveFormFigureCanvas.TimeSelection selection) {
        StandardSubObject[] subs = this.standardSubObjectList.toArray(new StandardSubObject[this.standardSubObjectList.size()]);
        ArrayList<StandardSubObject> list = new ArrayList<StandardSubObject>();
        int i = 0;
        while (i < subs.length) {
            if (selection.getStart() <= subs[i].getStartTime() && selection.getEnd() >= subs[i].getStartTime()) {
                list.add(subs[i]);
            } else if (selection.getStart() <= subs[i].getEndTime() && selection.getEnd() >= subs[i].getEndTime()) {
                list.add(subs[i]);
            }
            ++i;
        }
        return list.toArray(new StandardSubObject[list.size()]);
    }

    public void rerect() {
        log.trace((Object)"rerect");
        if (this.standardSubObjectList != null) {
            StandardSubObject[] subs = this.standardSubObjectList.toArray(new StandardSubObject[this.standardSubObjectList.size()]);
            Rectangle[] tmpRect = new Rectangle[subs.length];
            int i = 0;
            while (i < subs.length) {
                int dx = this.calculateTimeToX(subs[i].getStartTime());
                int dx2 = this.calculateTimeToX(subs[i].getEndTime());
                tmpRect[i] = new Rectangle(dx, this.rectangleY, dx2 - dx, this.rectangleHeight);
                log.trace((Object)("subrect:" + tmpRect[i]));
                ++i;
            }
            this.inRectangle = tmpRect;
        } else {
            this.inRectangle = new Rectangle[0];
        }
    }

    public void rerect(StandardSubObject target) {
        StandardSubObject[] subs = this.standardSubObjectList.toArray(new StandardSubObject[this.standardSubObjectList.size()]);
        int i = 0;
        while (i < subs.length) {
            if (subs[i] == target) {
                int dx = this.calculateTimeToX(subs[i].getStartTime());
                int dx2 = this.calculateTimeToX(subs[i].getEndTime());
                this.inRectangle[i] = new Rectangle(dx, this.rectangleY, dx2 - dx, this.rectangleHeight);
            }
            ++i;
        }
    }

    public void paintFigure(Graphics g) {
        if (this.inRectangle == null) {
            this.rerect();
        }
        log.trace((Object)("srtlist-paint:" + this.getClientArea() + ",inRectangle=" + this.inRectangle.length));
        Color color = new Color(null, this.backgroundRGB);
        Rectangle rectangle = new Rectangle(this.labelImage.getBounds());
        TextLayout layout = new TextLayout(null);
        int i = 0;
        while (i < this.inRectangle.length) {
            Rectangle drawRec = new Rectangle(this.inRectangle[i].x + this.getParent().getBounds().x, this.inRectangle[i].y, this.inRectangle[i].width, this.inRectangle[i].height);
            StandardSubObject sub = this.standardSubObjectList.get(i);
            String option = sub.getOption();
            g.drawImage(this.labelImage, rectangle, new Rectangle(drawRec.x, drawRec.y, drawRec.width, 128));
            g.setForegroundColor(color);
            g.drawLine(drawRec.x, drawRec.y, drawRec.x, drawRec.y + drawRec.height);
            g.drawLine(drawRec.x + drawRec.width, drawRec.y, drawRec.x + drawRec.width, drawRec.y + drawRec.height);
            if (drawRec.width > 10) {
                int marginH = 20;
                int marginW = 4;
                layout.setWidth(drawRec.width - marginW * 2);
                layout.setText(sub.getText());
                g.setForegroundColor(ColorConstants.black);
                g.drawTextLayout(layout, drawRec.x + marginW, drawRec.y + marginH);
            }
            ++i;
        }
        layout.dispose();
    }

    public int getRectangleHeight() {
        return this.rectangleHeight;
    }

    public void setRectangleHeight(int rectangleHeight) {
        this.rectangleHeight = rectangleHeight;
    }

    public int getRectangleY() {
        return this.rectangleY;
    }

    public void setRectangleY(int rectangleY) {
        this.rectangleY = rectangleY;
    }

    public List<StandardSubObject> getStandardSubObjectList() {
        return this.standardSubObjectList;
    }

    public String getSubObjectPath() {
        return this.subObjectPath;
    }

    public void setSubObjectPath(String subObjectPath) {
        this.subObjectPath = subObjectPath;
    }
}

