/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui.draw2d;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.akjrcp.ui.draw2d.CachedImageListener;
import jp.sourceforge.akjrcp.ui.draw2d.CachedImageLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Image;

public class FileImageCache
implements CachedImageLoader {
    List<String> imageList = new ArrayList<String>();
    Map<String, Image> imageMap = new HashMap<String, Image>();
    int maxSize = 32;
    private CachedImageListener cachedImageListener;
    public static Log log = LogFactory.getLog(FileImageCache.class);

    public CachedImageListener getCachedImageListener() {
        return this.cachedImageListener;
    }

    public void setCachedImageListener(CachedImageListener cachedImageListener) {
        this.cachedImageListener = cachedImageListener;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    private void add(Image img, String key) {
        this.imageList.add(key);
        this.imageMap.put(key, img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image loadImage(String key) {
        log.trace((Object)("call:" + key));
        Image img = this.imageMap.get(key);
        if (img != null) {
            log.trace((Object)("find:" + key));
            FileImageCache fileImageCache = this;
            synchronized (fileImageCache) {
                this.imageList.remove(key);
                this.imageList.add(key);
            }
            return img;
        }
        File file = new File(key);
        if (file.exists()) {
            log.trace((Object)("read:" + key));
            Image newImage = null;
            try {
                newImage = new Image(null, file.getAbsolutePath());
            }
            catch (Exception e) {
                log.warn((Object)e);
                return null;
            }
            if (this.cachedImageListener != null) {
                this.cachedImageListener.loaded(newImage, key);
            }
            this.add(newImage, key);
            if (this.imageList.size() > this.maxSize) {
                FileImageCache fileImageCache = this;
                synchronized (fileImageCache) {
                    this.remove(this.imageList.get(0));
                }
            }
            return newImage;
        }
        return null;
    }

    public synchronized void removeAll() {
        String[] keys = this.imageMap.keySet().toArray(new String[this.imageMap.size()]);
        int i = 0;
        while (i < keys.length) {
            this.remove(keys[i]);
            ++i;
        }
    }

    public void remove(String key) {
        Image obj = this.imageMap.remove(key);
        if (obj != null) {
            if (!obj.isDisposed()) {
                obj.dispose();
            }
            log.trace((Object)("remove:" + key));
            this.imageList.remove(key);
        }
    }
}

