/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class CComboFieldEditor
extends FieldEditor {
    public static final int VALIDATE_ON_KEY_STROKE = 0;
    public static final int VALIDATE_ON_FOCUS_LOST = 1;
    public static int UNLIMITED = -1;
    private boolean isValid;
    private String oldValue;
    CCombo comboField;
    private int widthInChars = UNLIMITED;
    private int textLimit = UNLIMITED;
    private String errorMessage;
    private boolean emptyStringAllowed = true;
    private int validateStrategy = 0;

    protected CComboFieldEditor() {
    }

    public CComboFieldEditor(String name, String labelText, int width, int strategy, Composite parent) {
        this.init(name, labelText);
        this.widthInChars = width;
        this.setValidateStrategy(strategy);
        this.isValid = false;
        this.errorMessage = JFaceResources.getString((String)"StringFieldEditor.errorMessage");
        this.createControl(parent);
    }

    public CComboFieldEditor(String name, String labelText, int width, Composite parent) {
        this(name, labelText, width, 0, parent);
    }

    public CComboFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, UNLIMITED, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.comboField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected boolean checkState() {
        String txt;
        boolean result = false;
        if (this.emptyStringAllowed) {
            result = true;
        }
        if (this.comboField == null) {
            result = false;
        }
        result = (txt = this.comboField.getText()).trim().length() > 0 || this.emptyStringAllowed;
        boolean bl = result = result && this.doCheckState();
        if (result) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(this.errorMessage);
        }
        return result;
    }

    protected boolean doCheckState() {
        return true;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.comboField = this.getCComboControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        if (this.widthInChars != UNLIMITED) {
            GC gc = new GC((Drawable)this.comboField);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this.widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        this.comboField.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.comboField != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.comboField.setText(value);
            this.oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.comboField != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.comboField.setText(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.comboField.getText());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        if (this.comboField != null) {
            return this.comboField.getText();
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    protected CCombo getCComboControl() {
        return this.comboField;
    }

    public CCombo getCComboControl(Composite parent) {
        if (this.comboField == null) {
            this.comboField = new CCombo(parent, 2048);
            this.addValues();
            this.comboField.setFont(parent.getFont());
            switch (this.validateStrategy) {
                case 0: {
                    this.comboField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent e) {
                            CComboFieldEditor.this.valueChanged();
                        }
                    });
                    break;
                }
                case 1: {
                    this.comboField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            CComboFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.comboField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            CComboFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            CComboFieldEditor.this.valueChanged();
                            CComboFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.comboField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    CComboFieldEditor.this.comboField = null;
                }
            });
            if (this.textLimit > 0) {
                this.comboField.setTextLimit(this.textLimit);
            }
        } else {
            this.checkParent((Control)this.comboField, parent);
        }
        return this.comboField;
    }

    public boolean isEmptyStringAllowed() {
        return this.emptyStringAllowed;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    public void setEmptyStringAllowed(boolean b) {
        this.emptyStringAllowed = b;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setFocus() {
        if (this.comboField != null) {
            this.comboField.setFocus();
        }
    }

    public void setStringValue(String value) {
        if (this.comboField != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.comboField.getText();
            if (!this.oldValue.equals(value)) {
                this.comboField.setText(value);
                this.valueChanged();
            }
        }
    }

    public void setTextLimit(int limit) {
        this.textLimit = limit;
        if (this.comboField != null) {
            this.comboField.setTextLimit(limit);
        }
    }

    public void setValidateStrategy(int value) {
        Assert.isTrue((value == 1 || value == 0 ? 1 : 0) != 0);
        this.validateStrategy = value;
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        String newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        if (!(newValue = this.comboField.getText()).equals(this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getCComboControl(parent).setEnabled(enabled);
    }

    public void add(String value) {
        this.getCComboControl().add(value);
    }

    public abstract void addValues();
}

