/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.snack;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import jp.sourceforge.akjrcp.snack.AbstractParser;
import jp.sourceforge.akjrcp.snack.SpectrogramListener;
import jp.sourceforge.akjrcp.ui.ProgressMonitor;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class SpectrogramGifConverter
extends AbstractParser {
    private ProgressMonitor progressMonitor;
    private int perMonitorCancel = 50;
    private int samplerate;
    private int height;
    private double permillisecond;
    private boolean removeNoise = true;
    private PaletteData paletteData;
    int imageWidth = 80;
    public static Log log = LogFactory.getLog(SpectrogramGifConverter.class);
    private boolean zippedFile = false;
    private String exportPath;
    private ZipOutputStream zipout;
    private int k = 5;
    private SpectrogramListener spectrogramListener;
    ArrayIntList blist;
    NoiseRemover noiseRemover;
    int imageIndex;
    ImageLoader loader = new ImageLoader();

    private SpectrogramGifConverter() {
        RGB[] graycolors = new RGB[256];
        int i = 0;
        while (i < 256) {
            graycolors[i] = new RGB(i, i, i);
            ++i;
        }
        graycolors[0] = new RGB(255, 255, 255);
        this.paletteData = new PaletteData(graycolors);
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getPermillisecond() {
        return this.permillisecond;
    }

    public void setPermillisecond(double permillisecond) {
        this.permillisecond = permillisecond;
    }

    public boolean isRemoveNoise() {
        return this.removeNoise;
    }

    public void setRemoveNoise(boolean removeNoise) {
        this.removeNoise = removeNoise;
    }

    public int getSamplerate() {
        return this.samplerate;
    }

    public void setSamplerate(int samplerate) {
        this.samplerate = samplerate;
    }

    public String toLabel(int index) {
        String v = "" + index;
        while (v.length() < this.k) {
            v = "0" + v;
        }
        return v;
    }

    public static int toValue256(double d) {
        if (d < 0.0) {
            d *= -1.0;
        }
        double r = Math.toRadians(d);
        double v = Math.sin(r) * 1.1;
        return Math.min(255, (int)(v * 256.0));
    }

    public SpectrogramGifConverter(int samplerate, int height, double permillisecond) {
        this();
        this.samplerate = samplerate;
        this.height = height;
        this.permillisecond = permillisecond;
        this.init();
    }

    public void init() {
        this.noiseRemover = new NoiseRemover(this.height);
    }

    public Object parse(Reader read) throws IOException {
        String line;
        this.blist = new ArrayIntList();
        long spSize = 0L;
        if (this.zippedFile) {
            this.zipout = new ZipOutputStream(new File(this.exportPath));
            this.zipout.setEncoding("SJIS");
            this.zipout.setLevel(0);
        }
        int index = 0;
        BufferedReader reader = new BufferedReader(read);
        int prev = 0;
        int perpixel = this.imageWidth * this.height;
        ImageData imageData = new ImageData(this.imageWidth, this.height, 8, this.paletteData);
        while ((line = reader.readLine()) != null) {
            int v = 0;
            try {
                v = Integer.parseInt(line);
            }
            catch (Exception exception) {}
            this.blist.add(SpectrogramGifConverter.toValue256(prev -= v));
            if (this.progressMonitor != null && index % this.perMonitorCancel == 0 && this.progressMonitor.isCanceled()) {
                log.trace((Object)"parse-canceled");
                reader.close();
                return null;
            }
            ++spSize;
            if (++index != perpixel) continue;
            int[] rawint = this.blist.toArray();
            if (this.removeNoise) {
                this.noiseRemover.removeNoize(rawint);
            }
            int i = 0;
            while (i < rawint.length) {
                imageData.setPixel(i / this.height, this.height - 1 - i % this.height, rawint[i]);
                ++i;
            }
            this.saveImage(imageData);
            index = 0;
            this.blist = new ArrayIntList();
        }
        reader.close();
        if (this.blist.size() > 0) {
            int[] rawint = this.blist.toArray();
            if (this.removeNoise) {
                this.noiseRemover.removeNoize(rawint);
            }
            int i = 0;
            while (i < perpixel) {
                if (i < rawint.length) {
                    imageData.setPixel(i / this.height, this.height - 1 - i % this.height, rawint[i]);
                } else {
                    imageData.setPixel(i / this.height, this.height - 1 - i % this.height, 0);
                }
                ++i;
            }
            this.saveImage(imageData);
        }
        if (this.zipout != null) {
            this.zipout.close();
            this.zipout = null;
            this.spectrogramListener.imageSaved(this.exportPath);
        }
        log.trace((Object)("spectrogram-length=" + spSize / 512L));
        if (spSize > 0L) {
            return new Integer((int)(spSize / 512L));
        }
        return new Integer(0);
    }

    public void saveImage(ImageData imgData) {
        this.loader.data = new ImageData[]{imgData};
        String label = this.toLabel(this.imageIndex);
        if (!this.zippedFile) {
            String path = String.valueOf(this.exportPath) + File.separator + label + ".gif";
            this.loader.save(path, 2);
            log.trace((Object)("gif-image-save:" + path));
            if (this.spectrogramListener != null) {
                this.spectrogramListener.imageSaved(path);
            }
        } else {
            ZipEntry entry = new ZipEntry(String.valueOf(label) + ".gif");
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                BufferedOutputStream buffer = new BufferedOutputStream(bout, 10240);
                log.info((Object)("createEntry:" + entry));
                this.zipout.putNextEntry(entry);
                this.loader.save((OutputStream)buffer, 2);
                this.zipout.write(bout.toByteArray());
                this.zipout.closeEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ++this.imageIndex;
        if (this.progressMonitor != null) {
            this.progressMonitor.worked(1);
        }
    }

    public byte toSignedByte(int v) {
        byte r = (byte)v;
        if (r > 127) {
            r = (byte)(r - 256);
        }
        return r;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public String getExportPath() {
        return this.exportPath;
    }

    public void setExportPath(String exportPath) {
        this.exportPath = exportPath;
    }

    public boolean isZippedFile() {
        return this.zippedFile;
    }

    public void setZippedFile(boolean zippedFile) {
        this.zippedFile = zippedFile;
    }

    public SpectrogramListener getSpectrogramListener() {
        return this.spectrogramListener;
    }

    public void setSpectrogramListener(SpectrogramListener spectrogramListener) {
        this.spectrogramListener = spectrogramListener;
    }

    public static class NoiseRemover {
        private int sampleHeight;

        public NoiseRemover(int sampleheight) {
            this.sampleHeight = sampleheight;
        }

        private void removeNoize(int[] values2) {
            int vsize = 10;
            int x = values2.length / this.sampleHeight;
            int i = 0;
            while (i < x) {
                int[] last = new int[vsize - 1];
                int j = 0;
                while (j < this.sampleHeight) {
                    int v = values2[i * this.sampleHeight + j];
                    if (v != 0) {
                        if (this.isNear(v, last)) {
                            int k = 0;
                            while (k < last.length + 1) {
                                values2[i * this.sampleHeight + j - k] = 255;
                                ++k;
                            }
                            this.setInit(0, last);
                        } else {
                            this.setLast(v, last);
                        }
                    } else {
                        this.setLast(v, last);
                    }
                    ++j;
                }
                ++i;
            }
        }

        private boolean near(int a, int b) {
            int ch = 2;
            return Math.abs(a - b) <= ch;
        }

        private boolean isNear(int v, int[] array) {
            int i = array.length - 1;
            while (i > 0) {
                if (!this.near(array[i], array[i - 1])) {
                    return false;
                }
                --i;
            }
            return this.near(array[0], v);
        }

        private void setInit(int value, int[] array) {
            int i = 0;
            while (i < array.length) {
                array[i] = value;
                ++i;
            }
        }

        private void setLast(int v, int[] array) {
            int i = array.length - 1;
            while (i > 0) {
                array[i] = array[i - 1];
                --i;
            }
            array[0] = v;
        }
    }
}

