/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.snack;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import jp.sourceforge.akjrcp.snack.ESPS;
import jp.sourceforge.akjrcp.snack.ESPSParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PitchExecuter {
    public static Log log = LogFactory.getLog(PitchExecuter.class);
    private String pitch2ExePath;
    public static double SKIPPED_TIME = 0.025;
    private Process process;

    public String[] getCommands(String wavePath, int start, int end, int min, int max, double framelength) {
        String[] argv = new String[]{this.pitch2ExePath, wavePath, "" + start, "" + end, "" + min, "" + max, "" + framelength};
        return argv;
    }

    public void cancel() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ESPS[] getESPS(String wavePath, int start, int end, int min, int max, double framelength) throws IOException {
        ESPSParser parser = new ESPSParser();
        String[] argv = this.getCommands(wavePath, start, end, min, max, framelength);
        this.process = Runtime.getRuntime().exec(argv);
        InputStream input = null;
        PitchExecuter pitchExecuter = this;
        synchronized (pitchExecuter) {
            if (this.process != null) {
                input = this.process.getInputStream();
                if (input != null) {
                    long starttime = System.currentTimeMillis();
                    log.trace((Object)"start-parse-esps:");
                    Vector vector = (Vector)parser.parse(input);
                    log.trace((Object)("end-parse-esps:" + (System.currentTimeMillis() - starttime) + "ms"));
                    return vector.toArray(new ESPS[vector.size()]);
                }
                throw new IOException("input null");
            }
        }
        return null;
    }

    public static ESPS[] toAverage(ESPS[] espses, int averageSize) {
        if (espses.length == 0) {
            return espses;
        }
        int arraySize = espses.length / averageSize;
        if (arraySize == 0) {
            return new ESPS[0];
        }
        ESPS[] retData = new ESPS[arraySize];
        int i = 0;
        while (i < retData.length) {
            retData[i] = new ESPS();
            int voicing = 0;
            int zero = 0;
            int j = 0;
            while (j < averageSize) {
                ESPS baseData = espses[i * averageSize + j];
                retData[i].setCorrelation(retData[i].getCorrelation() + baseData.getCorrelation());
                retData[i].setMeasurements(retData[i].getMeasurements() + baseData.getMeasurements());
                if (retData[i].getPitch() > 0.0) {
                    retData[i].setPitch(retData[i].getPitch() + baseData.getPitch());
                } else {
                    ++zero;
                }
                if (baseData.isVoicing()) {
                    ++voicing;
                }
                ++j;
            }
            if (zero < averageSize / 2) {
                retData[i].setPitch(retData[i].getPitch() / (double)(averageSize - zero));
            }
            retData[i].setCorrelation(retData[i].getCorrelation() / (double)averageSize);
            retData[i].setMeasurements(retData[i].getMeasurements() / (double)averageSize);
            if (voicing >= averageSize / 2) {
                retData[i].setVoicing(true);
            }
            ++i;
        }
        return retData;
    }

    public String getPitch2ExePath() {
        return this.pitch2ExePath;
    }

    public void setPitch2ExePath(String pitch2ExePath) {
        this.pitch2ExePath = pitch2ExePath;
    }
}

