/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.psp.imageconvert;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import jp.sourceforge.akjrcp.psp.imageconvert.ImageChanger;
import jp.sourceforge.akjrcp.psp.imageconvert.SupportCancel;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import jp.sourceforge.akjrcp.util.image.ImageUtils;

public abstract class AbstractImageChanger
implements SupportCancel,
ImageChanger {
    protected int width = 480;
    protected int height = 272;
    protected long time;
    protected float jpegQuality = 1.0f;
    protected boolean cancel;
    protected ImageLoader imageLoader = new ImageLoader();

    public BufferedImage toARGB(BufferedImage img) {
        BufferedImage ret = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        ret.getGraphics().drawImage(img, 0, 0, null);
        return ret;
    }

    public BufferedImage toARGB(BufferedImage img, int width, int height) {
        BufferedImage ret = new BufferedImage(width, height, 2);
        Graphics2D g2 = (Graphics2D)ret.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(img, 0, 0, width, height, 0, 0, img.getWidth(), img.getHeight(), null);
        return ret;
    }

    public BufferedImage toRGB(BufferedImage img, int width, int height) {
        BufferedImage ret = new BufferedImage(width, height, 1);
        Graphics2D g2 = (Graphics2D)ret.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(img, 0, 0, width, height, 0, 0, img.getWidth(), img.getHeight(), null);
        return ret;
    }

    public BufferedImage toRGB(BufferedImage img) {
        BufferedImage ret = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        ret.getGraphics().drawImage(img, 0, 0, null);
        return ret;
    }

    protected void saveImage(BufferedImage clipImage, String imageFileName, File exportDir) throws IOException {
        String extension = "png";
        if (ImageUtils.isJpegFile(imageFileName)) {
            extension = "jpg";
        }
        File newFile = new File(exportDir, String.valueOf(FileNameUtils.getRemovedExtensionName(FileNameUtils.getZipEntryFileName(imageFileName))) + "." + extension);
        if (extension.equals("jpg")) {
            ImageUtils.writeJpegWithQuality(clipImage, newFile, this.jpegQuality);
        } else {
            ImageIO.write((RenderedImage)clipImage, extension, newFile);
        }
        newFile.setLastModified(this.time);
        this.time += 2000L;
    }

    protected void saveImage(BufferedImage clipImage, int index, String imageFileName, File exportDir) throws IOException {
        String extension = "png";
        if (ImageUtils.isJpegFile(imageFileName)) {
            extension = "jpg";
        }
        File newFile = new File(exportDir, String.valueOf(FileNameUtils.getRemovedExtensionName(FileNameUtils.getZipEntryFileName(imageFileName))) + "_" + FileNameUtils.digited(index, 3) + "." + extension);
        System.out.println(newFile.getAbsolutePath());
        if (extension.equals("jpg")) {
            ImageUtils.writeJpegWithQuality(clipImage, newFile, this.jpegQuality);
        } else {
            ImageIO.write((RenderedImage)clipImage, extension, newFile);
        }
        newFile.setLastModified(this.time);
        this.time += 2000L;
    }

    protected void saveImage(BufferedImage clipImage, File imageFile, File exportDir) throws IOException {
        String extension = "png";
        if (imageFile.getName().toLowerCase().endsWith(".jpg")) {
            extension = "jpg";
        }
        File newFile = new File(exportDir, String.valueOf(FileNameUtils.getRemovedExtensionName(imageFile.getName())) + "." + extension);
        if (extension.equals("jpg")) {
            ImageUtils.writeJpegWithQuality(this.toRGB(clipImage), newFile, this.jpegQuality);
        } else {
            ImageIO.write((RenderedImage)clipImage, extension, newFile);
        }
        newFile.setLastModified(this.time);
        this.time += 2000L;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public float getJpegQuality() {
        return this.jpegQuality;
    }

    public void setJpegQuality(float jpegQuality) {
        this.jpegQuality = jpegQuality;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public void writePng(BufferedImage clipImage, int index, String imageFileName, File exportDir) throws IOException {
        String extension = "png";
        File newFile = new File(exportDir, String.valueOf(FileNameUtils.getRemovedExtensionName(imageFileName)) + "_" + FileNameUtils.digited(index, 3) + "." + extension);
        ImageIO.write((RenderedImage)clipImage, extension, newFile);
        newFile.setLastModified(this.time);
        this.time += 2000L;
    }

    public void clear() {
        this.imageLoader.clear();
    }

    protected static class ImageLoader {
        private BufferedImage image;
        private long lasttime;
        private String lastPath;

        protected ImageLoader() {
        }

        protected void clear() {
            this.image.getGraphics().dispose();
            this.image = null;
            System.gc();
        }

        protected BufferedImage loadImage(String path) throws IOException {
            if (this.image == null) {
                File file = new File(path);
                this.image = ImageIO.read(file);
                this.lastPath = path;
                this.lasttime = file.lastModified();
            } else {
                File file = new File(path);
                if (path.equals(this.lastPath) && file.lastModified() == this.lasttime) {
                    return this.image;
                }
                this.image = ImageIO.read(file);
                this.lastPath = path;
                this.lasttime = file.lastModified();
            }
            return this.image;
        }

        protected BufferedImage loadImage(String path, InputStream input) throws IOException {
            if (this.image == null) {
                this.image = ImageIO.read(input);
                this.lastPath = path;
            } else {
                if (path.equals(this.lastPath)) {
                    return this.image;
                }
                this.image = ImageIO.read(input);
                this.lastPath = path;
            }
            return this.image;
        }
    }
}

