/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.potrace;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedDropSomething;
import jp.sourceforge.akjrcp.dropsomething.IDropSomething;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.potrace.MkBitmapUtils;
import jp.sourceforge.akjrcp.potrace.PotraceExecuter;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.ui.GenericParameters;
import jp.sourceforge.akjrcp.ui.GenericParametersEditor;
import jp.sourceforge.akjrcp.ui.GenericParametersSaveDialog;
import jp.sourceforge.akjrcp.ui.GenericParametersTableViewer;
import jp.sourceforge.akjrcp.ui.param.ParamBoolean;
import jp.sourceforge.akjrcp.ui.param.ParamColor;
import jp.sourceforge.akjrcp.ui.param.ParamCombo;
import jp.sourceforge.akjrcp.ui.param.ParamItem;
import jp.sourceforge.akjrcp.ui.param.ParamItemActionListener;
import jp.sourceforge.akjrcp.ui.param.ParamSpinner;
import jp.sourceforge.akjrcp.ui.param.ParamSpinnerAndScale;
import jp.sourceforge.akjrcp.util.image.ImageUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class PotraceTabBuilder
implements IDropSomething {
    public static Log log = LogFactory.getLog(PotraceTabBuilder.class);
    private FileOverwriteControler fileOverwriteControler;
    public static final String POTRACE_CONVERT = "potraceconvert";

    public void createTab(ViewPart part, CTabFolder tab) {
        Akj_betasPlugin.getDefault().getPreferenceStore().setDefault("", "");
        CTabItem tabItem1 = new CTabItem(tab, 0);
        tabItem1.setText(Messages.getString("potraceconvert.tab"));
        PotraceConvertTab dtab = new PotraceConvertTab((Composite)tab, 0);
        dtab.setViewPart(part);
        tabItem1.setControl((Control)dtab);
        this.fileOverwriteControler = new FileOverwriteControler(tab.getShell());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PotraceConvertTab
    extends DirectoryBasedDropSomething {
        private PotraceExecuter potraceExecuter;
        private Label dragHere;
        private String currentTarget;
        private List settingList;
        private GenericParametersTableViewer tableViewer;
        private List<ParamItem> paramList;
        private Button saveSetting;
        ItemModifyCheck itemModifyCheck;
        private String selectedExport;

        public PotraceConvertTab(Composite parent, int style) {
            super(parent, style);
            this.selectedExport = "png";
        }

        public void addParamList(ParamItem item) {
            this.paramList.add(item);
            item.setParamItemActionListener(this.itemModifyCheck);
        }

        public Map<String, String> toNewParameterMap() {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            int i = 0;
            while (i < this.paramList.size()) {
                ParamItem item = this.paramList.get(i);
                if (item.getValue().length() > 0) {
                    parameterMap.put(item.getKey(), item.getValue());
                }
                ++i;
            }
            return parameterMap;
        }

        public void tableSelectionChanged() {
            GenericParameters parameters;
            this.saveSetting.setEnabled(false);
            int selection = this.tableViewer.getTable().getSelectionIndex();
            if (selection >= 0) {
                log.info((Object)("table item changed:" + selection));
                parameters = (GenericParameters)this.tableViewer.getTable().getItem(this.tableViewer.getTable().getSelectionIndex()).getData();
                log.info((Object)("size:" + this.paramList.size()));
            } else {
                parameters = new GenericParameters();
                parameters.set("POTRACE_USE", "1");
                parameters.set("MKBITMAP_USE", "1");
                parameters.set("t", "2");
                parameters.set("a", "1");
                parameters.set("n", "");
                parameters.set("O", "0.2");
                parameters.set("u", "10");
                parameters.set("z", "minority");
                parameters.set("C", "#000000");
                parameters.set("MKBITMAP_t", "0.45");
                parameters.set("MKBITMAP_f", "4");
                parameters.set("MKBITMAP_s", "2");
                parameters.set("MKBITMAP_i", "");
                parameters.set("GLOBAL_backgroundColor", "#ffffff");
                parameters.set("GLOBAL_line_transparent", "100");
                parameters.set("GLOBAL_image_transparent", "100");
                parameters.set("GLOBAL_bluar_image", "1");
            }
            Map<String, String> map = parameters.getParameters();
            int i = 0;
            while (i < this.paramList.size()) {
                ParamItem item = this.paramList.get(i);
                String value = map.get(item.getKey());
                if (value != null) {
                    log.info((Object)(String.valueOf(item.getKey()) + "," + value));
                    item.setValue(value);
                } else {
                    item.setValue("");
                }
                ++i;
            }
            this.saveSetting.setEnabled(false);
        }

        private Button createRadio(Composite parent, String key) {
            Button svg = new Button(parent, 16);
            ExportSelect se = new ExportSelect();
            svg.addSelectionListener((SelectionListener)se);
            svg.setText(key);
            return svg;
        }

        @Override
        public Composite createControls(Composite parent) {
            this.itemModifyCheck = new ItemModifyCheck();
            this.paramList = new ArrayList<ParamItem>();
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            Composite listComposite = new Composite(composite, 0);
            listComposite.setLayoutData((Object)new GridData(768));
            listComposite.setLayout((Layout)new GridLayout(2, false));
            List list = GenericParametersTableViewer.loadList(this.getPreferenceStore().getString("potracesetting.potrace_settings"));
            GridData gd = new GridData(768);
            gd.heightHint = 40;
            this.tableViewer = new GenericParametersTableViewer(listComposite);
            this.tableViewer.getTable().setLayoutData((Object)gd);
            this.tableViewer.setGenericParametersList(list);
            this.tableViewer.addSelectionChangedListener(new SelectChanged());
            this.saveSetting = new Button(listComposite, 0);
            this.saveSetting.setText(Messages.getString("h264converter.save"));
            this.saveSetting.setEnabled(false);
            this.saveSetting.addSelectionListener((SelectionListener)new GenericSave());
            this.settingList = new ArrayList();
            this.setPreferenceKey(PotraceTabBuilder.POTRACE_CONVERT);
            new SavePreferenceStore();
            CTabFolder tab = new CTabFolder(composite, 0x800400);
            GridData gd2 = new GridData(1808);
            tab.setLayoutData((Object)gd2);
            Composite basicComposite = new Composite((Composite)tab, 0);
            basicComposite.setLayout((Layout)new GridLayout(1, true));
            CTabItem tabItem1 = new CTabItem(tab, 0);
            tabItem1.setText(Messages.getString("potraceconvert.basic"));
            tabItem1.setControl((Control)basicComposite);
            this.createDirectoryInfo(basicComposite);
            this.dragHere = new Label(basicComposite, 0);
            this.dragHere.setLayoutData((Object)new GridData(768));
            Group export = new Group(basicComposite, 0);
            export.setLayoutData((Object)new GridData(768));
            export.setLayout((Layout)new GridLayout(9, false));
            export.setText(Messages.getString("potraceconvert.export"));
            this.createRadio((Composite)export, "svg");
            this.createRadio((Composite)export, "ps");
            this.createRadio((Composite)export, "eps");
            this.createRadio((Composite)export, "pdf");
            this.createRadio((Composite)export, "png").setSelection(true);
            this.createRadio((Composite)export, "jpg");
            this.createRadio((Composite)export, "bmp");
            this.createRadio((Composite)export, "pnm");
            int spinnerWidth = 145;
            Group mkbitmapGroup = new Group(basicComposite, 0);
            mkbitmapGroup.setLayoutData((Object)new GridData(768));
            mkbitmapGroup.setText(Messages.getString("potraceconvert.mkbitmap"));
            mkbitmapGroup.setLayout((Layout)new GridLayout(2, false));
            ParamBoolean useMkbitmap = new ParamBoolean((Composite)mkbitmapGroup, 0, "MKBITMAP_USE", Messages.getString("potraceconvert.use_mkbitmap"));
            this.addParamList(useMkbitmap);
            Composite p1 = new Composite((Composite)mkbitmapGroup, 0);
            p1.setLayout((Layout)new GridLayout(3, false));
            ParamSpinner mkbitmapS = new ParamSpinner(p1, 0, "MKBITMAP_s", "size");
            mkbitmapS.setDigits(0);
            mkbitmapS.setMaximum(16.0);
            mkbitmapS.setMinimum(1.0);
            this.addParamList(mkbitmapS);
            ParamBoolean param_g = new ParamBoolean(p1, 0, "MKBITMAP_g", "grey");
            this.addParamList(param_g);
            ParamBoolean param_i = new ParamBoolean(p1, 0, "MKBITMAP_i", "invert");
            this.addParamList(param_i);
            ParamSpinnerAndScale mkbitmapF = this.createParamSpinnerAndScale((Composite)mkbitmapGroup, 0, "MKBITMAP_f", "high pass filter", spinnerWidth);
            mkbitmapF.setDigits(0);
            mkbitmapF.setMaximum(50.0);
            mkbitmapF.setMinimum(0.0);
            this.addParamList(mkbitmapF);
            ParamSpinnerAndScale mkbitmapT = new ParamSpinnerAndScale((Composite)mkbitmapGroup, 0, "MKBITMAP_t", "-t");
            Image bgImage = ImageUtils.loadImage("jp.sourceforge.akjrcp.akj_betas", "icons/tbg32.png");
            mkbitmapT.getSpinnerAndScale().getScale().setBackgroundImage(bgImage);
            GridData data = new GridData(768);
            data.widthHint = 400;
            mkbitmapT.getSpinnerAndScale().setLayoutData(data);
            mkbitmapT.setDigits(3);
            mkbitmapT.setMaximum(1.0);
            mkbitmapT.setMinimum(0.001);
            this.addParamList(mkbitmapT);
            Group potraceG = new Group(basicComposite, 0);
            potraceG.setLayout((Layout)new GridLayout(4, true));
            potraceG.setText(Messages.getString("potraceconvert.potrace"));
            ParamBoolean usePotrace = new ParamBoolean((Composite)potraceG, 0, "POTRACE_USE", Messages.getString("potraceconvert.use_potrace"));
            this.addParamList(usePotrace);
            ParamBoolean param_n = new ParamBoolean((Composite)potraceG, 0, "n", "n");
            this.addParamList(param_n);
            param_n.setToolTipText("longcurve            - turn off curve optimization");
            ParamCombo param_z = new ParamCombo((Composite)potraceG, 0, "z", "z", new String[]{"black", "white", "right", "left", "minority", "majority"});
            this.addParamList(param_z);
            param_z.setToolTipText("turnpolicy <policy>  - how to resolve ambiguities in path decomposition");
            new Label((Composite)potraceG, 0);
            ParamSpinnerAndScale param_t = this.createParamSpinnerAndScale((Composite)potraceG, 0, "t", "t", spinnerWidth);
            param_t.setMaximum(300.0);
            param_t.setMinimum(1.0);
            this.addParamList(param_t);
            param_t.setToolTipText("turdsize <n>         - suppress speckles of up to this size (default 2)");
            ParamSpinnerAndScale param_a = this.createParamSpinnerAndScale((Composite)potraceG, 0, "a", "a", spinnerWidth);
            param_a.setDigits(2);
            param_a.setMaximum(1.34);
            param_a.setMinimum(0.0);
            this.addParamList(param_a);
            param_a.setToolTipText("alphamax <n>         - corner threshold parameter (default 1)");
            ParamSpinnerAndScale param_O = this.createParamSpinnerAndScale((Composite)potraceG, 0, "O", "O", spinnerWidth);
            param_O.setDigits(2);
            param_O.setMaximum(1.0);
            param_O.setMinimum(0.01);
            this.addParamList(param_O);
            param_O.setToolTipText("opttolerance <n>     - curve optimization tolerance (default 0.2)");
            ParamSpinnerAndScale param_u = this.createParamSpinnerAndScale((Composite)potraceG, 0, "u", "u", spinnerWidth);
            param_u.setMaximum(100.0);
            param_u.setMinimum(1.0);
            this.addParamList(param_u);
            param_u.setToolTipText("unit <n>             - quantize output to 1/unit pixels (default 10)");
            Composite advancedComposite = new Composite((Composite)tab, 0);
            advancedComposite.setLayout((Layout)new GridLayout(2, false));
            CTabItem tabItem2 = new CTabItem(tab, 0);
            tabItem2.setText(Messages.getString("potraceconvert.advanced"));
            tabItem2.setControl((Control)advancedComposite);
            this.createAdvancedControl(advancedComposite);
            tab.setSelection(0);
            tab.forceFocus();
            this.updateStatus();
            Akj_betasPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new PreferenceStoreMonitor());
            int defaultSelect = this.getPreferenceStore().getInt("potracesetting.potrace_settings_index");
            log.info((Object)("defaultSelect:" + defaultSelect));
            if (this.tableViewer.getTable().getItemCount() > defaultSelect) {
                this.tableViewer.getTable().setSelection(Math.max(0, defaultSelect));
            } else if (this.tableViewer.getTable().getItemCount() > 0) {
                this.tableViewer.getTable().setSelection(0);
            } else {
                log.info((Object)"item is empty");
            }
            this.tableSelectionChanged();
            this.tableViewer.addSelectionChangedListener(new StoreSelect());
            return composite;
        }

        private void createAdvancedControl(Composite advanced) {
            ParamColor lineColor = new ParamColor(advanced, 0, "C", Messages.getString("potrace.lineColor"));
            lineColor.setToolTipText(Messages.getString("potrace.lineColor_tooltip"));
            this.addParamList(lineColor);
            ParamSpinnerAndScale line_transparent = this.createParamSpinnerAndScale(advanced, 0, "GLOBAL_line_transparent", Messages.getString("potrace.line_transparent"), 200);
            line_transparent.setMaximum(100.0);
            line_transparent.setMinimum(1.0);
            this.addParamList(line_transparent);
            line_transparent.setToolTipText(Messages.getString("potrace.line_transparent_tooltip"));
            ParamColor bgColor = new ParamColor(advanced, 0, "GLOBAL_backgroundColor", Messages.getString("potrace.backgroundColor"));
            bgColor.setToolTipText(Messages.getString("potrace.backgroundColor_tooltip"));
            this.addParamList(bgColor);
            ParamSpinnerAndScale image_transparent = this.createParamSpinnerAndScale(advanced, 0, "GLOBAL_image_transparent", Messages.getString("potrace.image_transparent"), 200);
            image_transparent.setMaximum(100.0);
            image_transparent.setMinimum(1.0);
            this.addParamList(image_transparent);
            image_transparent.setToolTipText(Messages.getString("potrace.image_transparent_tooltip"));
            ParamBoolean draw_image = new ParamBoolean(advanced, 0, "GLOBAL_draw_image", Messages.getString("potrace.drawImage"));
            draw_image.setToolTipText(Messages.getString("potrace.drawImage_tooltip"));
            this.addParamList(draw_image);
            ParamSpinnerAndScale bluar_image = this.createParamSpinnerAndScale(advanced, 0, "GLOBAL_bluar_image", Messages.getString("potrace.bluar_image"), 200);
            bluar_image.setMaximum(100.0);
            bluar_image.setMinimum(1.0);
            this.addParamList(bluar_image);
            line_transparent.setToolTipText(Messages.getString("potrace.bluar_image_tooltip"));
        }

        private ParamSpinnerAndScale createParamSpinnerAndScale(Composite parent, int style, String key, String label, int width) {
            ParamSpinnerAndScale param = new ParamSpinnerAndScale(parent, style, key, label);
            GridData data = new GridData();
            data.widthHint = width;
            param.getSpinnerAndScale().setLayoutData(data);
            return param;
        }

        public void updateSettingTable() {
            List list = GenericParametersTableViewer.loadList(Akj_betasPlugin.getDefault().getPreferenceStore().getString("potracesetting.potrace_settings"));
            this.tableViewer.setGenericParametersList(list);
            if (this.tableViewer.getTable().getItemCount() > 0) {
                this.tableViewer.getTable().setSelection(0);
            }
        }

        public void restoreControl(Control control) {
            this.getPreferenceStore();
        }

        public void selectCombo(CCombo combo, String value) {
            int s = combo.getItemCount();
            int i = 0;
            while (i < s) {
                if (combo.getItem(i).equals(value)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }

        public void storeControl(Control control) {
            this.getPreferenceStore();
        }

        @Override
        public void inconvert(File file) {
            this.potraceExecuter.execute(new File[]{file});
        }

        @Override
        public void beforeConvert() {
            String mkBitmapPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("potracesetting.mkbitmpap_path");
            this.potraceExecuter = new PotraceExecuter();
            this.potraceExecuter.setExecuteListener(new PotraceMonitor());
            this.potraceExecuter.setPotracePath(Akj_betasPlugin.getDefault().getPreferenceStore().getString("potracesetting.potrace_path"));
            this.potraceExecuter.setMkBitmapPath(mkBitmapPath);
            this.potraceExecuter.setProcessPrinter(Akj_betasPlugin.getDefault().getProcessPrinter());
            Map<String, String> newMap = this.toNewParameterMap();
            GenericParameters setting = new GenericParameters(newMap);
            this.potraceExecuter.setOutputExtension(this.selectedExport);
            if (this.selectedExport.equals("pnm")) {
                if (setting.getParameters().get("POTRACE_USE") == null && setting.getParameters().get("MKBITMAP_g") == null) {
                    this.potraceExecuter.setOutputExtension("pbm");
                } else {
                    this.potraceExecuter.setOutputExtension("pgm");
                }
            }
            if (this.selectedExport.equals("png") || this.selectedExport.equals("jpg") || this.selectedExport.equals("bmp")) {
                setting.set("b", "postscript");
                setting.set("c", "1");
            }
            System.out.println("GLOBAL_draw_image:" + setting.getParameters().get("GLOBAL_draw_image"));
            if (setting.getParameters().get("GLOBAL_draw_image") != null) {
                this.potraceExecuter.setMixImage(true);
            } else {
                this.potraceExecuter.setMixImage(false);
            }
            if (!setting.getParameters().get("GLOBAL_line_transparent").equals("")) {
                this.potraceExecuter.setLineTransparent((float)(Double.parseDouble(setting.getParameters().get("GLOBAL_line_transparent")) / 100.0));
            }
            if (!setting.getParameters().get("GLOBAL_image_transparent").equals("")) {
                this.potraceExecuter.setImageTransparent((float)(Double.parseDouble(setting.getParameters().get("GLOBAL_image_transparent")) / 100.0));
            }
            if (!setting.getParameters().get("GLOBAL_backgroundColor").equals("")) {
                this.potraceExecuter.setBgColor(setting.getParameters().get("GLOBAL_backgroundColor"));
            }
            if (!setting.getParameters().get("GLOBAL_bluar_image").equals("")) {
                this.potraceExecuter.setBlur((int)Double.parseDouble(setting.getParameters().get("GLOBAL_bluar_image")));
            }
            this.potraceExecuter.setGenericParameters(setting);
            this.potraceExecuter.setSameDirectory(this.samefolder.getSelection());
            this.potraceExecuter.setBackup(this.backup.getSelection());
            if (!this.samefolder.getSelection()) {
                this.potraceExecuter.setExportDir(this.directoryChooser.getAbsoluteFilePath());
            }
        }

        @Override
        public void afterConvert() {
        }

        @Override
        public boolean isCanConvert() {
            String exePath = MkBitmapUtils.getMkbitmapPath();
            if (exePath == null) {
                this.setCantConvertStatusbarMessage("potrace.no_mkbitmap");
                return false;
            }
            return super.isCanConvert();
        }

        @Override
        public void cancelConvert() {
            this.potraceExecuter.cancel();
        }

        @Override
        public void updateStatus() {
            if (this.samefolder.getSelection() || this.directoryChooser.getFile() != null) {
                this.setMessage(Messages.getString("dropsomething.drag_folder"));
                this.setCanConvert(true);
            } else {
                this.setErrorMessage(Messages.getString("dropsomething.choose_folder"));
                this.setCanConvert(false);
            }
        }

        public void setMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 64, 255, 64));
                this.dragHere.setText(text);
            }
        }

        public void setErrorMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 255, 0, 0));
                this.dragHere.setText(text);
            }
        }

        @Override
        public IPreferenceStore getPreferenceStore() {
            return Akj_betasPlugin.getDefault().getPreferenceStore();
        }

        public boolean setFocus() {
            return this.tableViewer.getTable().setFocus();
        }

        public class ItemModifyCheck
        implements ParamItemActionListener {
            public void paramItemModified(ParamItem source) {
                boolean modified = false;
                int i = 0;
                while (i < PotraceConvertTab.this.paramList.size()) {
                    ParamItem item = (ParamItem)PotraceConvertTab.this.paramList.get(i);
                    if (item.isModified()) {
                        modified = true;
                        break;
                    }
                    ++i;
                }
                PotraceConvertTab.this.saveSetting.setEnabled(modified);
            }
        }

        public class SelectChanged
        implements ISelectionChangedListener {
            public void selectionChanged(SelectionChangedEvent event) {
                PotraceConvertTab.this.tableSelectionChanged();
            }
        }

        public class GenericSave
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int ret;
                GenericParameters parameter = PotraceConvertTab.this.tableViewer.getCurrentSelection();
                GenericParametersSaveDialog dialog = new GenericParametersSaveDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                if (parameter != null) {
                    String newName = PotraceConvertTab.this.tableViewer.copiedName(parameter);
                    dialog.setName(newName);
                    dialog.setComment(parameter.getComment());
                }
                if ((ret = dialog.open()) == 0) {
                    int selection;
                    log.info((Object)("Save:" + dialog.isSaveOverwrite()));
                    Map<String, String> newMap = PotraceConvertTab.this.toNewParameterMap();
                    if (dialog.isSaveOverwrite()) {
                        parameter.setParameters(newMap);
                        parameter.setComment(dialog.getComment());
                        selection = PotraceConvertTab.this.tableViewer.getTable().getSelectionIndex();
                    } else {
                        GenericParameters newParam = new GenericParameters(newMap);
                        newParam.setName(dialog.getName());
                        newParam.setComment(dialog.getComment());
                        PotraceConvertTab.this.tableViewer.getGenericParameters().add(newParam);
                        PotraceConvertTab.this.tableViewer.refresh();
                        selection = PotraceConvertTab.this.tableViewer.getTable().getItemCount() - 1;
                    }
                    GenericParameters[] infos = PotraceConvertTab.this.tableViewer.getGenericParameters().toArray(new GenericParameters[0]);
                    String newValue = GenericParametersEditor.toStoreString(infos);
                    PotraceConvertTab.this.getPreferenceStore().setValue("potracesetting.potrace_settings", newValue);
                    PotraceConvertTab.this.tableViewer.getTable().setSelection(selection);
                    PotraceConvertTab.this.tableSelectionChanged();
                }
            }
        }

        private class ExportSelect
        implements SelectionListener {
            private ExportSelect() {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PotraceConvertTab.this.selectedExport = ((Button)e.getSource()).getText();
            }
        }

        public class StoreSelect
        implements ISelectionChangedListener {
            public void selectionChanged(SelectionChangedEvent event) {
                PotraceConvertTab.this.getPreferenceStore().setValue("potracesetting.potrace_settings_index", PotraceConvertTab.this.tableViewer.getTable().getSelectionIndex());
            }
        }

        public class PreferenceStoreMonitor
        implements Preferences.IPropertyChangeListener {
            public void propertyChange(Preferences.PropertyChangeEvent event) {
                log.info((Object)event.getProperty());
                if (event.getProperty().equals("potracesetting.potrace_settings")) {
                    PotraceConvertTab.this.updateSettingTable();
                }
            }
        }

        public class SavePreferenceStore
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PotraceConvertTab.this.storeControl((Control)e.getSource());
            }
        }

        public class PotraceMonitor
        implements DirectryBasedExecuterListener {
            public void beforeConvert() {
            }

            public void afterConvert() {
                PotraceConvertTab.this.setProgress(0);
            }

            public void startConvert(File file) {
                PotraceConvertTab.this.setProgress(0);
            }

            public void endConvert(File file) {
                PotraceConvertTab.this.setProgress(100);
            }

            public void faildConvert(File file, String message) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[faild-potrace]" + message + "," + file.getAbsolutePath() + "\n\n");
            }

            public void printProcess(String line) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printError(line);
                if (FFMpegUtils.isProgressString(line)) {
                    PotraceConvertTab.this.progressBytes(FFMpegUtils.getProgressSize(line));
                }
            }

            public boolean askOverwrite(File output) {
                return FileOverwriteControler.askOverwrite(PotraceTabBuilder.this.fileOverwriteControler, output);
            }
        }
    }
}

