/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.greycstoration;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class RepeatBufferedImageMaker {
    private int paddingTop = 20;
    private int paddingLeft = 10;
    private int paddingRight = 10;
    private int paddingBottom = 20;
    private int marginCell = 20;
    private int imageCount;
    private Color labelColor = new Color(0, 0, 0);
    private Color backgroundColor = new Color(255, 255, 255);
    private Font labelFont = new Font("Courier", 0, 12);
    private int currentIndex;
    private String titleLabel;
    private BufferedImage bufferedImage;
    private Graphics2D g;

    public RepeatBufferedImageMaker(int imageCount, String titleLabel) {
        this.imageCount = imageCount;
        this.titleLabel = titleLabel;
    }

    public void paintImage(Image image, String label) {
        if (this.bufferedImage == null) {
            this.initImage(image);
        }
        int dx = this.paddingLeft;
        int dy = (image.getHeight(null) + this.marginCell) * this.currentIndex + this.paddingTop;
        this.bufferedImage.getGraphics().drawImage(image, dx, dy, null);
        Rectangle drawRectangle = new Rectangle(dx, dy + image.getHeight(null), image.getWidth(null), 12);
        this.g.setColor(this.labelColor);
        this.fillShapInRect(this.g, drawRectangle, RepeatBufferedImageMaker.makeStringShape(label, this.labelFont));
        ++this.currentIndex;
    }

    private void initImage(Image image) {
        Shape shape = RepeatBufferedImageMaker.makeStringShape(this.titleLabel, this.labelFont);
        int dw = Math.max(shape.getBounds().width, image.getWidth(null) + this.paddingLeft + this.paddingRight);
        int dh = image.getHeight(null) * this.imageCount + (this.imageCount - 1) * this.marginCell + this.paddingTop + this.paddingBottom;
        this.bufferedImage = new BufferedImage(dw, dh, 1);
        this.g = (Graphics2D)this.bufferedImage.getGraphics();
        this.g.setBackground(this.backgroundColor);
        this.g.clearRect(0, 0, dw, dh);
        this.g.setColor(this.labelColor);
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.fillShapInRect(this.g, new Rectangle(0, 0, dw, this.paddingTop), shape);
    }

    public void dispose() {
        if (this.g != null) {
            this.g.dispose();
        }
    }

    public void fillShapInRect(Graphics2D g2, Rectangle rect, Shape shape) {
        int dx = 0;
        int dy = 0;
        int cx = (rect.width - shape.getBounds().width) / 2;
        int cy = (rect.height - shape.getBounds().height) / 2;
        dx = rect.x + cx - shape.getBounds().x;
        dy = rect.y + cy - shape.getBounds().y;
        System.out.println(String.valueOf(dx) + "," + dy);
        g2.translate(dx, dy);
        g2.fill(shape);
        g2.translate(-dx, -dy);
    }

    public static Shape makeStringShape(String text, Font font) {
        BufferedImage dstImage = new BufferedImage(1, 1, 2);
        Graphics2D g2 = (Graphics2D)dstImage.getGraphics();
        TextLayout textLayout = new TextLayout(text, font, g2.getFontRenderContext());
        Shape shape = textLayout.getOutline(new AffineTransform());
        return shape;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }
}

