/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JpegPipeReader {
    public static Log log = LogFactory.getLog(JpegPipeReader.class);
    private InputStream inputStream;
    public static final int[] START_JPEG = new int[]{255, 216};
    public static final int[] END_JPEG = new int[]{255, 217};
    private boolean started = false;
    private boolean done = false;
    private int waitDone = 0;
    private static final int[] checkSeparate = new int[]{END_JPEG[0], END_JPEG[1], START_JPEG[0], START_JPEG[1]};
    ByteArrayOutputStream bout = new ByteArrayOutputStream(262144);

    public JpegPipeReader() {
    }

    public JpegPipeReader(InputStream input) {
        this.inputStream = input;
    }

    public byte[] nextImage() {
        block18: {
            if (this.done) {
                return null;
            }
            this.bout.reset();
            if (this.started) {
                this.bout.write(START_JPEG[0]);
                this.bout.write(START_JPEG[1]);
            } else {
                try {
                    int s1 = this.inputStream.read();
                    int s2 = this.inputStream.read();
                    if (s1 == START_JPEG[0] && s2 == START_JPEG[1]) {
                        this.bout.write(START_JPEG[0]);
                        this.bout.write(START_JPEG[1]);
                        this.started = true;
                        break block18;
                    }
                    log.info((Object)"not header");
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        int much_index = 0;
        int b = -1;
        try {
            while (!this.done) {
                b = this.inputStream.read();
                if (b == -1) {
                    if (much_index != 2) break;
                    System.out.println("#try to find header");
                    break;
                }
                if (checkSeparate[much_index] == b) {
                    if (much_index == 3) {
                        this.started = true;
                        break;
                    }
                    if (much_index < 2) {
                        this.bout.write(b);
                    }
                    if (++much_index != 2) continue;
                    if (this.waitDone > 0) {
                        try {
                            Thread.sleep(this.waitDone);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!this.done) continue;
                    this.started = true;
                    return this.bout.toByteArray();
                }
                this.bout.write(b);
                much_index = 0;
            }
            if (much_index == 2 && b == -1) {
                log.info((Object)"guess finish jpeg");
                this.started = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.bout.toByteArray().length == 0) {
            return null;
        }
        return this.bout.toByteArray();
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public int getWaitDone() {
        return this.waitDone;
    }

    public void setWaitDone(int waitDone) {
        this.waitDone = waitDone;
    }
}

