/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dropsomething;

import java.io.File;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.dropsomething.DropsomethingAction;
import jp.sourceforge.akjrcp.dropsomething.FFMpegDropSomethingTab;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultFFMpegMonitor
implements DirectryBasedExecuterListener {
    public static Log log = LogFactory.getLog(DefaultFFMpegMonitor.class);
    FFMpegDropSomethingTab dropsomethingTab;
    private String keyName;
    private String remainTimeLabel = String.valueOf(Messages.getString("dropsomething.remainTime")) + " - ";
    private String currentTimeLabel = " " + Messages.getString("dropsomething.currentTime") + " - ";
    private DropsomethingAction afterAction;
    private String totalTimeLabel = " " + Messages.getString("dropsomething.totalTime") + " - ";
    private long editStart;
    private long editDuration;

    public DefaultFFMpegMonitor(FFMpegDropSomethingTab dropsomethingTab, String keyName) {
        this.dropsomethingTab = dropsomethingTab;
        this.keyName = keyName;
    }

    public void beforeConvert() {
    }

    public void afterConvert() {
        this.dropsomethingTab.setProgress(0);
    }

    public void startConvert(File file) {
        this.dropsomethingTab.setCenterText("");
        this.dropsomethingTab.setProgress(0);
        FFMpegFLVParser parser = new FFMpegFLVParser(this.dropsomethingTab.getFFMpegExecuter().getFfmpegPreference().getFfmpegPath());
        FLVInfomation info = parser.parseFile(file);
        this.initialProgress(info);
        this.dropsomethingTab.setStartTime(System.currentTimeMillis());
    }

    public void initialProgress(FLVInfomation info) {
        long time = (long)(FFMpegUtils.timeToDouble(info.getDuration()) * 1000.0);
        if (time == 0L) {
            log.warn((Object)"maxtime==0");
        }
        this.dropsomethingTab.setProgressMaxTime(time);
    }

    public void endConvert(File input) {
        long t = System.currentTimeMillis() - this.dropsomethingTab.getStartTime();
        String timeString = FFMpegUtils.toTimeLabel(t);
        String info = "[" + this.keyName + ":" + Messages.getString("dropsomething.complete") + "]\r\n";
        info = String.valueOf(info) + Messages.getString("dropsomething.file") + ":" + input.getAbsolutePath() + "\r\n";
        info = String.valueOf(info) + Messages.getString("dropsomething.converttime") + ":" + timeString + "\r\n";
        info = String.valueOf(info) + "####\r\n";
        this.dropsomethingTab.setProgress(100);
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(info);
        File output = this.dropsomethingTab.getFFMpegExecuter().getCurrentOutputFile();
        this.dropsomethingTab.setCenterText("");
        if (this.afterAction != null) {
            this.afterAction.exec(input, output);
        }
    }

    public void faildConvert(File file, String message) {
        String info = "[" + this.keyName + ":" + Messages.getString("dropsomething.faild") + "]\r\n";
        info = String.valueOf(info) + Messages.getString("dropsomething.file") + ":" + file.getAbsolutePath() + "\r\n";
        info = String.valueOf(info) + "####\r\n\r\n";
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(info);
    }

    public void printProcess(String line) {
        Akj_betasPlugin.getDefault().getProcessPrinter().printError(line);
        if (FFMpegUtils.isProgressString(line)) {
            this.progress(line);
            this.updateInfoText();
        }
    }

    public boolean askOverwrite(File output) {
        return FileOverwriteControler.askOverwrite(this.dropsomethingTab.getFileOverWriteControler(), output);
    }

    public void progress(String line) {
        long time = FFMpegUtils.getProgressTime(line);
        this.dropsomethingTab.setProgressTime(time);
        this.dropsomethingTab.progressTime(time);
    }

    public long getTotalTime(long currentTime) {
        long progressMaxTime = this.dropsomethingTab.getProgressMaxTime();
        if (progressMaxTime == 0L) {
            log.warn((Object)"progressMaxBytes 0 ");
            return 0L;
        }
        long totalTime = 0L;
        if (this.dropsomethingTab.getProgressTime() > 0L) {
            double ratio = (double)progressMaxTime / (double)this.dropsomethingTab.getProgressTime();
            totalTime = (long)((double)currentTime * ratio);
        }
        return totalTime;
    }

    public void updateInfoText() {
        StringBuffer text = new StringBuffer();
        long currentTime = System.currentTimeMillis() - this.dropsomethingTab.getStartTime();
        long totalTime = this.getTotalTime(currentTime);
        if (totalTime != 0L) {
            text.append(this.remainTimeLabel);
            text.append(FFMpegUtils.toTimeLabel(totalTime - currentTime));
            text.append(this.currentTimeLabel);
            text.append(FFMpegUtils.toTimeLabel(currentTime));
            text.append(this.totalTimeLabel);
            text.append(FFMpegUtils.toTimeLabel(totalTime));
            this.dropsomethingTab.setCenterText(text.toString());
        } else {
            log.warn((Object)"totaltime 0 ");
        }
    }

    public DropsomethingAction getAfterAction() {
        return this.afterAction;
    }

    public void setAfterAction(DropsomethingAction afterAction) {
        this.afterAction = afterAction;
    }
}

