/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.IOException;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;

public class MRUBundleFileList
implements EventDispatcher {
    private static final String PROP_FILE_LIMIT = "osgi.bundlefile.limit";
    private static final int MIN = 10;
    private BundleFile[] bundleFileList;
    private long[] useStampList;
    private long curUseStamp = 0L;
    private int fileLimit = 0;
    private int numOpen = 0;
    private EventManager bundleFileCloserManager;
    private EventListeners bundleFileCloser;

    public MRUBundleFileList() {
        try {
            String prop = BundleFile.secureAction.getProperty(PROP_FILE_LIMIT);
            if (prop != null) {
                this.init(Integer.parseInt(prop));
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public MRUBundleFileList(int fileLimit) {
        this.init(fileLimit);
    }

    private void init(int initFileLimit) {
        if (initFileLimit >= 10) {
            this.fileLimit = initFileLimit;
            this.bundleFileList = new BundleFile[initFileLimit];
            this.useStampList = new long[initFileLimit];
            this.bundleFileCloserManager = new EventManager("Bundle File Closer");
            this.bundleFileCloser = new EventListeners();
            this.bundleFileCloser.addListener(this, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BundleFile bundleFile) throws IOException {
        if (this.fileLimit < 10) {
            return;
        }
        BundleFile toRemove = null;
        BundleFile[] bundleFileArray = this.bundleFileList;
        synchronized (this.bundleFileList) {
            int index = 0;
            if (this.numOpen < this.fileLimit) {
                int i = 0;
                while (i < this.fileLimit) {
                    if (this.bundleFileList[i] == null) {
                        index = i;
                        break;
                    }
                    ++i;
                }
            } else {
                index = 0;
                int i = 1;
                while (i < this.fileLimit) {
                    if (this.useStampList[i] < this.useStampList[index]) {
                        index = i;
                    }
                    ++i;
                }
                toRemove = this.bundleFileList[index];
                this.remove(toRemove);
            }
            this.bundleFileList[index] = bundleFile;
            bundleFile.setMruIndex(index);
            this.incUseStamp(index);
            ++this.numOpen;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.closeBundleFile(toRemove);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(BundleFile bundleFile) {
        if (this.fileLimit < 10) {
            return false;
        }
        BundleFile[] bundleFileArray = this.bundleFileList;
        synchronized (this.bundleFileList) {
            block5: {
                int index = bundleFile.getMruIndex();
                if (index < 0 || index >= this.fileLimit || this.bundleFileList[index] != bundleFile) break block5;
                bundleFile.setMruIndex(-1);
                this.bundleFileList[index] = null;
                this.useStampList[index] = -1L;
                --this.numOpen;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void use(BundleFile bundleFile) {
        if (this.fileLimit < 10) {
            return;
        }
        BundleFile[] bundleFileArray = this.bundleFileList;
        synchronized (this.bundleFileList) {
            int index = bundleFile.getMruIndex();
            if (index >= 0 && index < this.fileLimit && this.bundleFileList[index] == bundleFile) {
                this.incUseStamp(index);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void incUseStamp(int index) {
        if (this.curUseStamp == Long.MAX_VALUE) {
            int i = 0;
            while (i < this.fileLimit) {
                this.useStampList[i] = 0L;
                ++i;
            }
            this.curUseStamp = 0L;
        }
        this.useStampList[index] = ++this.curUseStamp;
    }

    public final void dispatchEvent(Object eventListener, Object listenerObject, int eventAction, Object eventObject) {
        try {
            ((BundleFile)eventObject).close();
        }
        catch (IOException iOException) {}
    }

    private void closeBundleFile(BundleFile toRemove) {
        if (toRemove == null) {
            return;
        }
        ListenerQueue queue = new ListenerQueue(this.bundleFileCloserManager);
        queue.queueListeners(this.bundleFileCloser, this);
        queue.dispatchEventAsynchronous(0, toRemove);
    }
}

