/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.videotools.imagetomovie;

import java.io.File;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.dropsomething.DropsomethingView;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFileInfomation;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegInput;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.ffmpeg.SimpleCommandExecuter;
import jp.sourceforge.akjrcp.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.util.ExecutingControler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class SingleImageToMovie
extends ViewPart {
    public static Log log = LogFactory.getLog(SingleImageToMovie.class);
    public static final String ID = SingleImageToMovie.class.getName();
    Composite composite;
    private FileDirChoicer imageFileChooser;
    private FileDirChoicer audioFileChooser;
    private FileDirChoicer outputFileChooser;
    private SingleImageToMovieExecute singleImageToMovieExecute;
    private String imagePath;
    private String audioPath;
    private String outputPath;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.singleImageToMovieExecute = new SingleImageToMovieExecute();
        FileSelected selected = new FileSelected();
        this.imageFileChooser = new FileDirChoicer(parent, 2048, 0, Messages.getString("singleimagetomovie.imagefile"));
        this.imageFileChooser.setLayoutData(new GridData(768));
        this.imageFileChooser.setFilterExtensions(new String[]{"*.jpg", "*.avi;*.flv"});
        this.imageFileChooser.addFileListChangeListener(selected);
        this.audioFileChooser = new FileDirChoicer(parent, 2048, 0, Messages.getString("singleimagetomovie.audiofile"));
        this.audioFileChooser.setLayoutData(new GridData(768));
        this.audioFileChooser.setFilterExtensions(new String[]{"*.mp3;*.flv"});
        this.audioFileChooser.addFileListChangeListener(selected);
        this.outputFileChooser = new FileDirChoicer(parent, 2048, 2, Messages.getString("singleimagetomovie.outputfile"));
        this.outputFileChooser.setLayoutData(new GridData(768));
        this.outputFileChooser.setFilterExtensions(new String[]{"*.avi"});
        this.outputFileChooser.addFileListChangeListener(selected);
        this.outputFileChooser.addFileListChangeListener(new OverwriteCheck());
        this.singleImageToMovieExecute.addControl((Control)this.imageFileChooser);
        this.singleImageToMovieExecute.addControl((Control)this.audioFileChooser);
        this.singleImageToMovieExecute.addControl((Control)this.outputFileChooser);
        new ExecutingControler.ExecutingControlButton(parent, 0, this.singleImageToMovieExecute, Messages.getString("singleimagetomovie.exec"), Messages.getString("singleimagetomovie.cancel"));
    }

    public void printInputInfo(FFMpegFileInfomation imageInfo, FFMpegFileInfomation audioInfo) {
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("##SingleImageToMovieInupt Info\n");
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("#Image\n");
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(imageInfo.getText());
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("#\n");
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("#Audio\n");
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(audioInfo.getText());
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("#\n");
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("##\n");
    }

    public void setStatusValue(String value) {
        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new SetMessage(value));
    }

    public void setFocus() {
    }

    public class OverwriteCheck
    implements FileDirChoicer.FileStatusChangeListener {
        public void addList(FileDirChoicer.FileStatusChangeEvent event) {
            FileOverwriteControler controler;
            boolean r;
            File f = new File(event.getFilePath());
            if (f.exists() && !(r = (controler = new FileOverwriteControler(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1)).canOverwrite(f))) {
                ((FileDirChoicer)((Object)event.getSource())).removePath();
            }
        }

        public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
        }
    }

    public class FileSelected
    implements FileDirChoicer.FileStatusChangeListener {
        public void addList(FileDirChoicer.FileStatusChangeEvent event) {
            SingleImageToMovie.this.singleImageToMovieExecute.updateControlSwitch();
        }

        public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
            SingleImageToMovie.this.singleImageToMovieExecute.updateControlSwitch();
        }
    }

    public class SingleImageToMovieExecute
    extends ExecutingControler {
        private SimpleCommandExecuter simpleExecuter;

        public void afterExecute() {
        }

        public void beforeExecute() {
            SingleImageToMovie.this.imagePath = SingleImageToMovie.this.imageFileChooser.getAbsoluteFilePath();
            SingleImageToMovie.this.audioPath = SingleImageToMovie.this.audioFileChooser.getAbsoluteFilePath();
            SingleImageToMovie.this.outputPath = SingleImageToMovie.this.outputFileChooser.getAbsoluteFilePath();
        }

        public boolean canExecute() {
            return !SingleImageToMovie.this.imageFileChooser.getAbsoluteFilePath().equals("") && !SingleImageToMovie.this.audioFileChooser.getAbsoluteFilePath().equals("") && !SingleImageToMovie.this.outputFileChooser.getAbsoluteFilePath().equals("");
        }

        public void cancelExecuting() {
            this.simpleExecuter.getProcess().destroy();
        }

        public void inExecute() {
            FLVInfomation imageInfo;
            FFMpegFLVParser parser;
            FFMpegInput imageInput;
            String ffmpegPath = FFMpegUI.getFFmpeg();
            if (ffmpegPath == null) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("error:need ffmpeg.exe");
                return;
            }
            FFMpegPreference preference = new FFMpegPreference();
            preference.setFfmpegPath(ffmpegPath);
            if (SingleImageToMovie.this.imagePath.toLowerCase().endsWith(".avi") || SingleImageToMovie.this.imagePath.toLowerCase().endsWith(".flv")) {
                preference.setVideoCodec("copy");
                imageInput = new FFMpegInput(SingleImageToMovie.this.imagePath);
                preference.addMap("0:0");
                if (SingleImageToMovie.this.audioPath.toLowerCase().endsWith(".flv")) {
                    preference.addMap("1:1");
                } else {
                    preference.addMap("1:0");
                }
            } else {
                preference.setShortest(true);
                preference.setVideoRate(1.0);
                preference.setVideoCodec("xvid");
                preference.setAudioCodec("copy");
                imageInput = new FFMpegInput(SingleImageToMovie.this.imagePath);
                imageInput.setFormat("image2");
                imageInput.setLoop(true);
                parser = new FFMpegFLVParser(ffmpegPath);
                imageInfo = parser.parseFile(new File(SingleImageToMovie.this.imagePath));
                if (imageInfo.getVideoWidth() > 0 && imageInfo.getVideoHeight() > 0) {
                    int h;
                    int w = imageInfo.getVideoWidth();
                    if (w % 2 > 0) {
                        ++w;
                    }
                    if ((h = imageInfo.getVideoHeight()) % 2 > 0) {
                        ++h;
                    }
                    preference.setVideoSize(w, h);
                }
            }
            parser = new FFMpegFLVParser(ffmpegPath);
            imageInfo = parser.parseFile(new File(SingleImageToMovie.this.imagePath));
            FLVInfomation audioInfo = parser.parseFile(new File(SingleImageToMovie.this.audioPath));
            SingleImageToMovie.this.printInputInfo(imageInfo, audioInfo);
            preference.setAudioCodec("copy");
            String[] commands = preference.toCommand(new FFMpegInput[]{imageInput, new FFMpegInput(SingleImageToMovie.this.audioPath)}, SingleImageToMovie.this.outputPath);
            Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(FFMpegUtils.toCommand(commands));
            this.simpleExecuter = new SimpleCommandExecuter(commands);
            this.simpleExecuter.setPrinter(Akj_betasPlugin.getDefault().getProcessPrinter());
            this.simpleExecuter.execute();
        }
    }

    public class SetMessage
    implements Runnable {
        String message;

        SetMessage(String message) {
            this.message = message;
        }

        public void run() {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)DropsomethingView.viewSite.getWorkbenchWindow();
            WWinActionBars actionBars = workbenchWindow.getActionBars();
            IStatusLineManager manager = actionBars.getStatusLineManager();
            manager.setMessage(this.message);
        }
    }
}

