/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util.image;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.akjrcp.util.image.ImageDecoder;

public class PpmDecoder
extends ImageDecoder {
    private int type;
    private static final int PBM_ASCII = 1;
    private static final int PGM_ASCII = 2;
    private static final int PPM_ASCII = 3;
    private static final int PBM_RAW = 4;
    private static final int PGM_RAW = 5;
    private static final int PPM_RAW = 6;
    private int width = -1;
    private int height = -1;
    private int maxval;
    private int bitshift = -1;
    private int bits;

    public PpmDecoder(InputStream in) {
        super(in);
    }

    void readHeader(InputStream in) throws IOException {
        char c1 = (char)PpmDecoder.readByte(in);
        char c2 = (char)PpmDecoder.readByte(in);
        if (c1 != 'P') {
            throw new IOException("not a PBM/PGM/PPM file");
        }
        switch (c2) {
            case '1': {
                this.type = 1;
                break;
            }
            case '2': {
                this.type = 2;
                break;
            }
            case '3': {
                this.type = 3;
                break;
            }
            case '4': {
                this.type = 4;
                break;
            }
            case '5': {
                this.type = 5;
                break;
            }
            case '6': {
                this.type = 6;
                break;
            }
            default: {
                throw new IOException("not a standard PBM/PGM/PPM file");
            }
        }
        this.width = PpmDecoder.readInt(in);
        this.height = PpmDecoder.readInt(in);
        if (this.type != 1 && this.type != 4) {
            this.maxval = PpmDecoder.readInt(in);
        }
        System.out.println(String.valueOf(this.type) + " " + this.width + "x" + this.height + " max=" + this.maxval);
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    void readRow(InputStream in, int row, int[] rgbRow) throws IOException {
        int rgb = 0;
        int col = 0;
        while (col < this.width) {
            switch (this.type) {
                case 1: {
                    char c = PpmDecoder.readChar(in);
                    if (c == '1') {
                        rgb = -16777216;
                        break;
                    }
                    if (c == '0') {
                        rgb = -1;
                        break;
                    }
                    throw new IOException("illegal PBM bit");
                }
                case 2: {
                    int g = PpmDecoder.readInt(in);
                    rgb = PpmDecoder.makeRgb(g, g, g);
                    break;
                }
                case 3: {
                    int r = PpmDecoder.readInt(in);
                    int g = PpmDecoder.readInt(in);
                    int b = PpmDecoder.readInt(in);
                    rgb = PpmDecoder.makeRgb(r, g, b);
                    break;
                }
                case 4: {
                    if (this.readBit(in)) {
                        rgb = -16777216;
                        break;
                    }
                    rgb = -1;
                    break;
                }
                case 5: {
                    int g = PpmDecoder.readByte(in);
                    if (this.maxval != 255) {
                        g = this.fixDepth(g);
                    }
                    rgb = PpmDecoder.makeRgb(g, g, g);
                    break;
                }
                case 6: {
                    int r = PpmDecoder.readByte(in);
                    int g = PpmDecoder.readByte(in);
                    int b = PpmDecoder.readByte(in);
                    if (this.maxval != 255) {
                        r = this.fixDepth(r);
                        g = this.fixDepth(g);
                        b = this.fixDepth(b);
                    }
                    rgb = PpmDecoder.makeRgb(r, g, b);
                }
            }
            rgbRow[col] = rgb;
            ++col;
        }
    }

    private static int readByte(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }

    private boolean readBit(InputStream in) throws IOException {
        if (this.bitshift == -1) {
            this.bits = PpmDecoder.readByte(in);
            this.bitshift = 7;
        }
        boolean bit = (this.bits >> this.bitshift & 1) != 0;
        --this.bitshift;
        return bit;
    }

    private static char readChar(InputStream in) throws IOException {
        char c = (char)PpmDecoder.readByte(in);
        if (c == '#') {
            while ((c = (char)PpmDecoder.readByte(in)) != '\n' && c != '\r') {
            }
        }
        return c;
    }

    private static char readNonwhiteChar(InputStream in) throws IOException {
        char c;
        while ((c = PpmDecoder.readChar(in)) == ' ' || c == '\t' || c == '\n' || c == '\r') {
        }
        return c;
    }

    private static int readInt(InputStream in) throws IOException {
        char c = PpmDecoder.readNonwhiteChar(in);
        if (c < '0' || c > '9') {
            throw new IOException("junk in file where integer should be");
        }
        int i = 0;
        do {
            i = i * 10 + c - 48;
        } while ((c = PpmDecoder.readChar(in)) >= '0' && c <= '9');
        return i;
    }

    private int fixDepth(int p) {
        return (p * 255 + this.maxval / 2) / this.maxval;
    }

    private static int makeRgb(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

