/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util.directorybased;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import jp.sourceforge.akjrcp.util.PathnameUtils;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import jp.sourceforge.akjrcp.util.SimpleProcessPrinter;
import jp.sourceforge.akjrcp.util.directorybased.DirectoryBasedCommand;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DirectoryBasedCommandExecuter {
    public static Log log = LogFactory.getLog(DirectoryBasedCommandExecuter.class);
    protected DirectryBasedExecuterListener executeListener;
    protected String exportDir;
    protected boolean sameDirectory;
    protected boolean backup;
    protected boolean cancelling;
    protected File inputParentDirectory;
    protected File currentOutputFile;
    protected String outputExtension;
    protected boolean renameSameFile = true;
    protected ProcessPrinter processPrinter = new SimpleProcessPrinter();
    protected DirectoryBasedCommand currentCommand;

    public void execute(File[] files) {
        if (this.executeListener != null) {
            this.executeListener.beforeConvert();
        }
        int i = 0;
        while (i < files.length) {
            this.inputParentDirectory = files[i];
            this.execute(files[i]);
            ++i;
        }
        if (this.executeListener != null) {
            this.executeListener.afterConvert();
        }
    }

    private void execute(File file) {
        if (file.isDirectory()) {
            if (this.cancelling) {
                log.info((Object)("cancel " + file));
                return;
            }
            String[] list = file.list();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    this.execute(new File(file, list[i]));
                    ++i;
                }
            }
        } else {
            this.inExecute(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        log.info((Object)"called cancel");
        DirectoryBasedCommandExecuter directoryBasedCommandExecuter = this;
        synchronized (directoryBasedCommandExecuter) {
            System.out.println("cancell:" + System.currentTimeMillis());
            this.cancelling = true;
        }
        if (this.getProcess() != null) {
            this.getProcess().destroy();
            log.info((Object)("maybe destroyed:" + this.getProcess()));
        }
    }

    public Process getProcess() {
        if (this.currentCommand != null) {
            return this.currentCommand.getProcess();
        }
        return null;
    }

    private File toOutputFile(File file) {
        String outputPath;
        String outputDir = file.getParent();
        if (!this.sameDirectory) {
            outputDir = this.exportDir;
            String remain = PathnameUtils.getRemainPath(this.inputParentDirectory.getParent(), PathnameUtils.changeExtension(file.getAbsolutePath(), this.outputExtension));
            System.out.println("remain:" + remain);
            outputPath = String.valueOf(outputDir) + "\\" + remain;
        } else {
            outputPath = String.valueOf(outputDir) + "\\" + PathnameUtils.changeExtension(file.getName(), this.outputExtension);
        }
        log.info((Object)("saveto:" + outputPath));
        if (file.getAbsolutePath().equals(outputPath)) {
            if (this.renameSameFile) {
                File newFile = FileNameUtils.makeBackupFile(file, "new");
                outputPath = newFile.getAbsolutePath();
            } else if (this.executeListener != null) {
                this.executeListener.faildConvert(file, "input and output is same");
                return null;
            }
        }
        boolean overwrite = false;
        File tmpOutput = new File(outputPath);
        if (tmpOutput.exists() && !tmpOutput.canWrite() && this.executeListener != null) {
            this.executeListener.faildConvert(file, "file can't overwrite");
            return null;
        }
        if (!this.backup) {
            if (tmpOutput.exists()) {
                if (this.executeListener != null && !(overwrite = this.executeListener.askOverwrite(tmpOutput))) {
                    if (this.executeListener != null) {
                        this.executeListener.faildConvert(file, "file don't overwrite");
                    }
                    return null;
                }
                boolean deleted = tmpOutput.delete();
                if (!deleted && this.executeListener != null) {
                    this.executeListener.faildConvert(file, "file can't overwrite");
                    return null;
                }
            }
        } else {
            boolean r;
            File backUpFile = FileNameUtils.makeBackupFile(tmpOutput, "backup");
            if (backUpFile.exists()) {
                r = backUpFile.delete();
                if (!r) {
                    log.warn((Object)("delete faild " + backUpFile));
                    if (this.executeListener != null) {
                        this.executeListener.faildConvert(file, "can't make backupfile " + backUpFile);
                    }
                    return null;
                }
                log.info((Object)("delete success " + backUpFile));
            }
            if (tmpOutput.exists()) {
                r = tmpOutput.renameTo(backUpFile);
                if (!r) {
                    log.warn((Object)("backup faild " + tmpOutput));
                    if (this.executeListener != null) {
                        this.executeListener.faildConvert(file, "can't make backupfile " + tmpOutput);
                    }
                    return null;
                }
                log.info((Object)("backup success " + tmpOutput));
            }
        }
        return tmpOutput;
    }

    protected abstract DirectoryBasedCommand[] toCommand(File var1, File var2);

    private void inExecute(File file) {
        if (this.cancelling) {
            log.info((Object)("cancel " + file));
            return;
        }
        File tmpOutput = this.toOutputFile(file);
        if (tmpOutput == null) {
            return;
        }
        this.setCurrentOutputFile(tmpOutput);
        if (this.getProcess() != null) {
            this.getProcess().destroy();
        }
        if (this.cancelling) {
            log.info((Object)("cancel " + file));
            return;
        }
        tmpOutput.getParentFile().mkdirs();
        DirectoryBasedCommand[] commands = this.toCommand(file, tmpOutput);
        if (commands == null) {
            log.warn((Object)"null command");
            if (this.executeListener != null) {
                this.executeListener.faildConvert(file, "");
            }
            return;
        }
        if (this.executeListener != null) {
            this.executeListener.startConvert(file);
        }
        try {
            try {
                int i = 0;
                while (i < commands.length) {
                    if (this.cancelling) {
                        log.info((Object)("canceled " + file));
                        throw new IOException("cancelled");
                    }
                    this.currentCommand = commands[i];
                    if (!this.cancelling) {
                        this.beforeExecuteCommand(this.currentCommand);
                        this.currentCommand.setProcessPrinter(this.processPrinter);
                        int result = this.currentCommand.exec();
                        this.processReturnValue(result);
                        if (result != 0) {
                            throw new IOException("exec faild");
                        }
                    } else {
                        throw new IOException("cancelled");
                    }
                    this.afterExecuteCommand(this.currentCommand);
                    ++i;
                }
            }
            catch (Exception e) {
                if (this.getProcess() != null) {
                    this.getProcess().destroy();
                }
                if (this.executeListener != null) {
                    this.executeListener.faildConvert(file, e.getMessage());
                }
                e.printStackTrace();
            }
        }
        finally {
            this.inFinallyAction(file, tmpOutput);
        }
        if (this.executeListener != null) {
            this.executeListener.endConvert(file);
        }
        this.currentCommand = null;
    }

    protected abstract void afterExecuteCommand(DirectoryBasedCommand var1);

    protected abstract void beforeExecuteCommand(DirectoryBasedCommand var1);

    protected abstract void processReturnValue(int var1);

    protected abstract void inFinallyAction(File var1, File var2);

    public static String toDebugArray(String[] array) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        return String.valueOf(v) + "\n";
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public DirectryBasedExecuterListener getExecuteListener() {
        return this.executeListener;
    }

    public void setExecuteListener(DirectryBasedExecuterListener executeListener) {
        this.executeListener = executeListener;
    }

    public String getExportDir() {
        return this.exportDir;
    }

    public void setExportDir(String exportDir) {
        this.exportDir = exportDir;
    }

    public boolean isSameDirectory() {
        return this.sameDirectory;
    }

    public void setSameDirectory(boolean sameDirectory) {
        this.sameDirectory = sameDirectory;
    }

    public File getCurrentOutputFile() {
        return this.currentOutputFile;
    }

    public void setCurrentOutputFile(File currentOutputFile) {
        this.currentOutputFile = currentOutputFile;
    }

    public String getOutputExtension() {
        return this.outputExtension;
    }

    public void setOutputExtension(String outputExtension) {
        this.outputExtension = outputExtension;
    }

    public ProcessPrinter getProcessPrinter() {
        return this.processPrinter;
    }

    public void setProcessPrinter(ProcessPrinter processPrinter) {
        this.processPrinter = processPrinter;
    }

    public class TestMonitor
    implements DirectryBasedExecuterListener {
        public void beforeConvert() {
        }

        public void afterConvert() {
        }

        public void startConvert(File file) {
        }

        public void endConvert(File file) {
        }

        public void faildConvert(File file, String message) {
            System.out.println("faild:" + file);
        }

        public void printProcess(String line) {
        }

        public boolean askOverwrite(File output) {
            return false;
        }
    }

    public class ErrorCatchProcessPrinter
    implements ProcessPrinter {
        public void printOutput(String output) throws IOException {
            this.print(output);
        }

        public void printError(String error) throws IOException {
            this.print(error);
        }

        private void print(String line) throws IOException {
            if (DirectoryBasedCommandExecuter.this.executeListener != null) {
                DirectoryBasedCommandExecuter.this.executeListener.printProcess(line);
            }
            log.debug((Object)line);
            if (line.indexOf("Unsupported video codec") != -1) {
                if (line.indexOf("flv") != -1) {
                    log.info((Object)"flv is sensitive");
                } else {
                    log.info((Object)"unsupported:");
                }
            }
        }
    }
}

