/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import java.io.File;
import java.util.List;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFileInfomation;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegInput;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.ui.GenericParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericParametersFFMpegPreference
extends FFMpegPreference {
    public static Log log = LogFactory.getLog(GenericParametersFFMpegPreference.class);
    public static final String EXTENSION = "EXTENSION";
    public static final String TWO_PASS_ENCODE = "TWO_PASS_ENCODE";
    public static final String MAX_FRAME_RATE = "MAX_FRAME_RATE";
    public static final String[] SYSTEM_KEYS = new String[]{"EXTENSION", "TWO_PASS_ENCODE", "MAX_FRAME_RATE"};
    private GenericParameters genericParameters;

    public GenericParametersFFMpegPreference(GenericParameters setting) {
        this.setGenericParameters(setting);
        this.setFormat(setting.getParameters().get("f"));
    }

    public void addLastOptions(FFMpegInput[] input, List params) {
        if (this.genericParameters != null) {
            String maxValue = this.genericParameters.getParameters().get(MAX_FRAME_RATE);
            String rate = this.genericParameters.getParameters().get("r");
            if (maxValue != null && rate == null) {
                double maxFrameRate = Double.parseDouble(maxValue);
                FFMpegFileInfomation info = GenericParametersFFMpegPreference.getVideoInfomation(this.getFfmpegPath(), input);
                if (info != null && info.getVideoRate() > 0.0) {
                    log.warn((Object)("rate:" + maxFrameRate + "," + info.getVideoRate()));
                    double r = Math.min(maxFrameRate, info.getVideoRate());
                    log.info((Object)("maxrate:set rate " + r));
                    this.genericParameters.getParameters().put("r", "" + r);
                } else {
                    log.warn((Object)"info null and cant set maxframerate");
                }
            }
            String[] args = this.genericParameters.toArgParams();
            String tmpSize = null;
            int i = 0;
            while (i < args.length) {
                if (this.getGeneration() == 2) {
                    if (args[i].equals("-acodec")) {
                        args[i + 1] = GenericParametersFFMpegPreference.toSuiteAudioCodec(args[i + 1], this.getGeneration());
                    }
                    if (args[i].equals("-vcodec")) {
                        args[i + 1] = GenericParametersFFMpegPreference.toSuiteVideoCodec(args[i + 1], this.getGeneration());
                    }
                }
                if (args[i].equals("-s")) {
                    tmpSize = args[i + 1];
                    ++i;
                } else {
                    params.add(args[i]);
                }
                ++i;
            }
            if (tmpSize != null) {
                params.add("-s");
                params.add(tmpSize);
            }
        } else {
            log.warn((Object)"genericParameters=null");
        }
    }

    public static FFMpegFileInfomation getVideoInfomation(String ffmpegPath, FFMpegInput[] inputs) {
        int i = inputs.length - 1;
        while (i >= 0) {
            FLVInfomation info = new FFMpegFLVParser(ffmpegPath).parseFile(new File(inputs[i].getPath()));
            if (info != null && info.isHaveVideo()) {
                return info;
            }
            --i;
        }
        return null;
    }

    public GenericParameters getGenericParameters() {
        return this.genericParameters;
    }

    public void setGenericParameters(GenericParameters genericParameters) {
        this.genericParameters = genericParameters;
    }

    public boolean isTwoPassEncode() {
        if (this.genericParameters != null) {
            String twopass = this.genericParameters.getParameters().get(TWO_PASS_ENCODE);
            return twopass != null;
        }
        log.info((Object)"twopass is not in map");
        return super.isTwoPassEncode();
    }

    public String getExtension() {
        String ext;
        if (this.genericParameters != null && (ext = this.genericParameters.getParameters().get(EXTENSION)) != null) {
            return ext;
        }
        log.info((Object)"extension is not in map");
        return super.getExtension();
    }
}

