/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegCommandUtil;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegInput;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.SimpleCommandExecuter;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.util.PathnameUtils;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import jp.sourceforge.akjrcp.util.StatusBarUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.ui.PlatformUI;

public class FFMpegExecuter {
    public static Log log = LogFactory.getLog(FFMpegExecuter.class);
    private boolean useAvisynth;
    private String[] ignoreAvisynthExtensions = new String[]{"mpg", "mp3", "flv", "ac3", "mp2", "m2a", "aac", "ogg", "wav", "vob", "wma"};
    private DirectryBasedExecuterListener executeListener;
    private String exportDir;
    private boolean sameDirectory;
    private boolean backup;
    private FFMpegPreference ffmpegPreference = new FFMpegPreference();
    private Process process;
    private boolean cancelling;
    private File rootFile;
    private File currentOutputFile;

    public int getGuessSize() {
        return this.ffmpegPreference.getGuessSize();
    }

    public void execute(File[] files) {
        if (this.executeListener != null) {
            this.executeListener.beforeConvert();
        }
        int i = 0;
        while (i < files.length) {
            this.rootFile = files[i];
            this.execute(files[i]);
            ++i;
        }
        if (this.executeListener != null) {
            this.executeListener.afterConvert();
        }
    }

    private void execute(File file) {
        if (file.isDirectory()) {
            if (this.cancelling) {
                log.info((Object)("cancel " + file));
                return;
            }
            String[] list = file.list();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    this.execute(new File(file, list[i]));
                    ++i;
                }
            }
        } else {
            this.inExecute(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        log.info((Object)"called cancel");
        FFMpegExecuter fFMpegExecuter = this;
        synchronized (fFMpegExecuter) {
            System.out.println("cancell:" + System.currentTimeMillis());
            this.cancelling = true;
        }
        if (this.process != null) {
            this.process.destroy();
            log.info((Object)("maybe destroyed:" + this.process));
        }
    }

    private File toOutputFile(File file) {
        String outputPath;
        String outputDir = file.getParent();
        if (!this.sameDirectory) {
            outputDir = this.exportDir;
            String remain = PathnameUtils.getRemainPath(this.rootFile.getParent(), PathnameUtils.changeExtension(file.getAbsolutePath(), this.ffmpegPreference.getExtension()));
            System.out.println("remain:" + remain);
            outputPath = String.valueOf(outputDir) + "\\" + remain;
        } else {
            outputPath = String.valueOf(outputDir) + "\\" + PathnameUtils.changeExtension(file.getName(), this.ffmpegPreference.getExtension());
        }
        log.info((Object)("save:" + outputPath));
        if (file.getAbsolutePath().equals(outputPath) && this.executeListener != null) {
            this.executeListener.faildConvert(file, "input and output is same");
            return null;
        }
        boolean overwrite = false;
        File tmpOutput = new File(outputPath);
        if (tmpOutput.exists() && !tmpOutput.canWrite() && this.executeListener != null) {
            this.executeListener.faildConvert(file, "file can't overwrite");
            return null;
        }
        if (!this.backup) {
            if (tmpOutput.exists() && this.executeListener != null && !(overwrite = this.executeListener.askOverwrite(tmpOutput))) {
                if (this.executeListener != null) {
                    this.executeListener.faildConvert(file, "file don't overwrite");
                }
                return null;
            }
        } else {
            boolean r;
            File backUpFile = FFMpegExecuter.makeBackupFile(tmpOutput, "bk");
            if (backUpFile.exists()) {
                r = backUpFile.delete();
                if (!r) {
                    log.warn((Object)("delete faild " + backUpFile));
                    if (this.executeListener != null) {
                        this.executeListener.faildConvert(file, "can't make backupfile " + backUpFile);
                    }
                    return null;
                }
                log.info((Object)("delete success " + backUpFile));
            }
            if (tmpOutput.exists()) {
                r = tmpOutput.renameTo(backUpFile);
                if (!r) {
                    log.warn((Object)("backup faild " + tmpOutput));
                    if (this.executeListener != null) {
                        this.executeListener.faildConvert(file, "can't make backupfile " + tmpOutput);
                    }
                    return null;
                }
                log.info((Object)("backup success " + tmpOutput));
            }
        }
        return tmpOutput;
    }

    public static File makeBackupFile(File file, String addextension) {
        int count = 1;
        File bkfile = new File(file.getParentFile(), String.valueOf(file.getName()) + "." + addextension);
        while (bkfile.exists()) {
            bkfile = new File(file.getParentFile(), String.valueOf(file.getName()) + "." + "(" + count + ")." + addextension);
            ++count;
        }
        return bkfile;
    }

    /*
     * Unable to fully structure code
     */
    private void inExecute(File file) {
        block46: {
            block44: {
                block45: {
                    if (this.ffmpegPreference.getFfmpegPath() == null) {
                        FFMpegExecuter.log.warn((Object)"ffmpeg not found:set ffmpegPath in preference");
                    }
                    if (this.cancelling) {
                        FFMpegExecuter.log.info((Object)("cancel " + file));
                        return;
                    }
                    tmpOutput = this.toOutputFile(file);
                    if (tmpOutput == null) {
                        return;
                    }
                    this.setCurrentOutputFile(tmpOutput);
                    input = null;
                    avs = null;
                    avsAvailable = false;
                    if (this.ffmpegPreference != null) {
                        avsAvailable = FFMpegUtils.isAvisynthAvailable(new File(this.ffmpegPreference.getFfmpegPath()));
                    }
                    i = 0;
                    while (i < this.ignoreAvisynthExtensions.length) {
                        if (file.getName().toLowerCase().endsWith(this.ignoreAvisynthExtensions[i])) {
                            this.useAvisynth = false;
                            FFMpegExecuter.log.info((Object)("dont use avisynth for " + this.ignoreAvisynthExtensions[i]));
                            break;
                        }
                        ++i;
                    }
                    FFMpegExecuter.log.info((Object)(String.valueOf(this.useAvisynth) + "," + avsAvailable));
                    if (this.useAvisynth && avsAvailable) {
                        try {
                            avs = File.createTempFile("avs", ".avs");
                            writer = new FileWriter(avs);
                            writer.write(FFMpegUtils.toAVSScript(file.getAbsolutePath()));
                            writer.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    input = file;
                    FFMpegExecuter.log.info((Object)("avs:" + avs));
                    avsPath = null;
                    if (avs != null) {
                        avsPath = avs.getAbsolutePath();
                    }
                    FFMpegExecuter.log.info((Object)("avsPath:" + avsPath));
                    if (this.process != null) {
                        this.process.destroy();
                    }
                    this.process = null;
                    if (this.cancelling) {
                        FFMpegExecuter.log.info((Object)("cancel " + file));
                        return;
                    }
                    tmpOutput.getParentFile().mkdirs();
                    tmpAudio = null;
                    tmpVideo = null;
                    commands = null;
                    if (this.ffmpegPreference.isTwoPassEncode()) ** GOTO lbl129
                    if (input.getName().toLowerCase().endsWith(".flv") && PlatformUI.getPreferenceStore().getBoolean("ffmpeg.demux_dome_video") && avsPath == null) {
                        flvInfo = new FFMpegFLVParser(this.ffmpegPreference.getFfmpegPath()).parseFile(input);
                        if (flvInfo.getVideoCodec().equals("vp6f")) {
                            tmpAudio = File.createTempFile("vp6", ".mp3");
                            tmpAudio.deleteOnExit();
                            command = FFMpegCommandUtil.makeCopyAudioCommand(this.ffmpegPreference.getFfmpegPath(), input.getAbsolutePath(), tmpAudio.getAbsolutePath());
                            executer1 = new SimpleCommandExecuter(command);
                            executer1.execute();
                            FFMpegExecuter.log.info((Object)"demuxed audio");
                            tmpVideo = File.createTempFile("vp6", ".avi");
                            tmpVideo.deleteOnExit();
                            command2 = FFMpegCommandUtil.makeCopyVideoCommand(this.ffmpegPreference.getFfmpegPath(), input.getAbsolutePath(), tmpVideo.getAbsolutePath());
                            executer2 = new SimpleCommandExecuter(command2);
                            executer2.execute();
                            FFMpegExecuter.log.info((Object)"demuxed video");
                            commands = this.ffmpegPreference.toCommand(new FFMpegInput[]{new FFMpegInput(tmpAudio.getAbsolutePath(), "mp3"), new FFMpegInput(tmpVideo.getAbsolutePath())}, tmpOutput.getAbsolutePath());
                        } else {
                            commands = this.ffmpegPreference.toCommand(input.getAbsolutePath(), avsPath, tmpOutput.getAbsolutePath());
                        }
                    } else {
                        commands = this.ffmpegPreference.toCommand(input.getAbsolutePath(), avsPath, tmpOutput.getAbsolutePath());
                    }
                    if (commands != null) break block44;
                    FFMpegExecuter.log.warn((Object)"null command");
                    if (this.executeListener == null) break block45;
                    this.executeListener.faildConvert(file, "");
                }
lbl77:
                // 5 sources

                return;
            }
            try {
                try {
                    block47: {
                        if (this.executeListener != null) {
                            this.executeListener.startConvert(file);
                        }
                        if (!this.cancelling) break block47;
                        FFMpegExecuter.log.info((Object)("canceled " + file));
                        ** GOTO lbl77
                    }
                    runtime = Runtime.getRuntime();
                    printer = new ErrorCatchProcessPrinter();
                    try {
                        printer.printOutput(FFMpegExecuter.toDebugArray(commands));
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    FFMpegExecuter.log.info((Object)("start process:" + this.process + "," + ArrayUtils.toString((Object)commands)));
                    this.process = runtime.exec(commands);
                    System.out.println("process:" + System.currentTimeMillis() + "," + this.cancelling);
                    monitor = new ProcessMonitor(this.process, printer);
                    monitor.startMonitor();
                    try {
                        if (!this.cancelling) {
                            this.process.waitFor();
                            result = this.process.exitValue();
                            if (result != 0) {
                                if (result == 1) {
                                    FFMpegExecuter.log.info((Object)("exit-value:" + result));
                                } else {
                                    printer.printError("[error] " + result + "\n");
                                    if (result == -1073741819) {
                                        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new StatusBarUtils.ShowStatusBar(String.valueOf(Messages.getString("error.happend")) + ":" + Messages.getString("error.memory")));
                                        FFMpegExecuter.log.warn((Object)("exit-value:" + result + "maybe memory error"));
                                    } else if (result == -1073741515) {
                                        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new StatusBarUtils.ShowStatusBar(String.valueOf(Messages.getString("error.happend")) + ":" + Messages.getString("error.pthreadGC2")));
                                        FFMpegExecuter.log.warn((Object)("exit-value:" + result + "pthreadGC2.dll not found"));
                                        printer.printError("[error] " + Messages.getString("error.pthreadGC2") + "\n");
                                        printer.printError(Messages.getString("hint.pthreadGC2") + "\n");
                                    } else {
                                        FFMpegExecuter.log.warn((Object)("exit-value:" + result));
                                        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new StatusBarUtils.ShowStatusBar(String.valueOf(Messages.getString("error.happend")) + ":" + result));
                                    }
                                    Thread.sleep(1000L);
                                }
                            }
                            break block46;
                        }
                        FFMpegExecuter.log.info((Object)("finally cancel " + file));
                        ** GOTO lbl77
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break block46;
                    }
lbl129:
                    // 1 sources

                    if (input.getName().toLowerCase().endsWith(".flv") && PlatformUI.getPreferenceStore().getBoolean("ffmpeg.demux_dome_video") && avsPath == null) {
                        flvInfo = new FFMpegFLVParser(this.ffmpegPreference.getFfmpegPath()).parseFile(input);
                        if (flvInfo.getVideoCodec().equals("vp6f")) {
                            tmpAudio = File.createTempFile("vp6", ".mp3");
                            tmpAudio.deleteOnExit();
                            command = FFMpegCommandUtil.makeCopyAudioCommand(this.ffmpegPreference.getFfmpegPath(), input.getAbsolutePath(), tmpAudio.getAbsolutePath());
                            executer1 = new SimpleCommandExecuter(command);
                            executer1.execute();
                            FFMpegExecuter.log.info((Object)"demuxed audio");
                            tmpVideo = File.createTempFile("vp6", ".avi");
                            tmpVideo.deleteOnExit();
                            command2 = FFMpegCommandUtil.makeCopyVideoCommand(this.ffmpegPreference.getFfmpegPath(), input.getAbsolutePath(), tmpVideo.getAbsolutePath());
                            executer2 = new SimpleCommandExecuter(command2);
                            executer2.execute();
                            FFMpegExecuter.log.info((Object)"demuxed video");
                            this.twoPassEncode(new FFMpegInput[]{new FFMpegInput(tmpAudio.getAbsolutePath(), "mp3"), new FFMpegInput(tmpVideo.getAbsolutePath())}, tmpOutput, this.ffmpegPreference);
                        } else {
                            this.twoPassEncode(input, avsPath, tmpOutput, this.ffmpegPreference);
                        }
                    } else {
                        this.twoPassEncode(input, avsPath, tmpOutput, this.ffmpegPreference);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    this.process.destroy();
                    if (this.executeListener == null) ** GOTO lbl77
                    this.executeListener.faildConvert(file, e1.getMessage());
                    ** continue;
                }
            }
            catch (Throwable var15_27) {
                throw var15_27;
            }
            finally {
                if (avs != null) {
                    avs.delete();
                }
                if (tmpAudio != null) {
                    tmpAudio.delete();
                    tmpAudio = null;
                }
                if (tmpVideo != null) {
                    tmpVideo.delete();
                    tmpVideo = null;
                }
            }
        }
        if (this.executeListener != null) {
            this.executeListener.endConvert(file);
        }
        this.process = null;
    }

    public void twoPassEncode(File input, String avsPath, File tmpOutput, FFMpegPreference preferences) throws IOException {
        FFMpegInput[] inputs = new FFMpegInput[]{avsPath != null ? new FFMpegInput(avsPath) : new FFMpegInput(input.getAbsolutePath())};
        this.twoPassEncode(inputs, tmpOutput, preferences);
    }

    public void twoPassEncode(FFMpegInput[] inputs, File tmpOutput, FFMpegPreference preferences) throws IOException {
        String[] commands2pass;
        boolean deleteOnePass;
        String passlog = String.valueOf(System.getProperty("java.io.tmpdir")) + System.currentTimeMillis() + "_log";
        new File(passlog).deleteOnExit();
        File onePassFile = new File(tmpOutput.getParent(), "tmp_" + tmpOutput.getName());
        String[] commands1pass = preferences.toCommandPass1(inputs, passlog, onePassFile.getAbsolutePath());
        if (commands1pass == null) {
            log.warn((Object)"null command");
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        ErrorCatchProcessPrinter printer = new ErrorCatchProcessPrinter();
        try {
            printer.printOutput(FFMpegExecuter.toDebugArray(commands1pass));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        log.info((Object)("start process:" + this.process + "," + ArrayUtils.toString((Object)commands1pass)));
        this.process = runtime.exec(commands1pass);
        ProcessMonitor monitor = new ProcessMonitor(this.process, printer);
        monitor.startMonitor();
        try {
            if (this.cancelling) {
                log.info((Object)"finally cancel ");
                return;
            }
            this.process.waitFor();
            int exit = this.process.exitValue();
            if (exit != 0) {
                throw new IOException("exit:" + exit);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        if (this.cancelling) {
            log.info((Object)"canceled ");
        }
        if (!(deleteOnePass = onePassFile.delete())) {
            log.warn((Object)("delete one pass file failed:" + onePassFile.getAbsolutePath()));
        }
        if ((commands2pass = preferences.toCommandPass2(inputs, passlog, tmpOutput.getAbsolutePath())) == null) {
            log.warn((Object)"null command");
            return;
        }
        try {
            printer.printOutput(FFMpegExecuter.toDebugArray(commands2pass));
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new IOException(e2.getMessage());
        }
        log.info((Object)("start process:" + this.process + "," + ArrayUtils.toString((Object)commands1pass)));
        if (!this.cancelling) {
            this.process = runtime.exec(commands2pass);
        }
        ProcessMonitor monitor2 = new ProcessMonitor(this.process, printer);
        monitor2.startMonitor();
        try {
            if (this.cancelling) {
                log.info((Object)"finally cancel ");
                return;
            }
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        new File(passlog).delete();
        int exit = this.process.exitValue();
        if (exit != 0) {
            throw new IOException("exit:" + exit);
        }
    }

    public static String toDebugArray(String[] array) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        return String.valueOf(v) + "\n";
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public DirectryBasedExecuterListener getExecuteListener() {
        return this.executeListener;
    }

    public void setExecuteListener(DirectryBasedExecuterListener executeListener) {
        this.executeListener = executeListener;
    }

    public String getExportDir() {
        return this.exportDir;
    }

    public void setExportDir(String exportDir) {
        this.exportDir = exportDir;
    }

    public FFMpegPreference getFfmpegPreference() {
        return this.ffmpegPreference;
    }

    public void setFfmpegPreference(FFMpegPreference ffmpegPreference) {
        this.ffmpegPreference = ffmpegPreference;
    }

    public String[] getIgnoreAvisynthExtensions() {
        return this.ignoreAvisynthExtensions;
    }

    public void setIgnoreAvisynthExtensions(String[] ignoreAvisynthExtensions) {
        this.ignoreAvisynthExtensions = ignoreAvisynthExtensions;
    }

    public boolean isSameDirectory() {
        return this.sameDirectory;
    }

    public void setSameDirectory(boolean sameDirectory) {
        this.sameDirectory = sameDirectory;
    }

    public boolean isUseAvisynth() {
        return this.useAvisynth;
    }

    public void setUseAvisynth(boolean useAvisynth) {
        this.useAvisynth = useAvisynth;
    }

    public File getCurrentOutputFile() {
        return this.currentOutputFile;
    }

    public void setCurrentOutputFile(File currentOutputFile) {
        this.currentOutputFile = currentOutputFile;
    }

    public class TestMonitor
    implements DirectryBasedExecuterListener {
        public void beforeConvert() {
        }

        public void afterConvert() {
        }

        public void startConvert(File file) {
        }

        public void endConvert(File file) {
        }

        public void faildConvert(File file, String message) {
            System.out.println("faild:" + file);
        }

        public void printProcess(String line) {
        }

        public boolean askOverwrite(File output) {
            return false;
        }
    }

    public class ErrorCatchProcessPrinter
    implements ProcessPrinter {
        public void printOutput(String output) throws IOException {
            this.print(output);
        }

        public void printError(String error) throws IOException {
            this.print(error);
        }

        private void print(String line) throws IOException {
            if (FFMpegExecuter.this.executeListener != null) {
                FFMpegExecuter.this.executeListener.printProcess(line);
            }
            log.debug((Object)line);
            if (line.indexOf("Unsupported video codec") != -1) {
                if (line.indexOf("flv") != -1) {
                    log.info((Object)"flv is sensitive");
                } else {
                    log.info((Object)"unsupported:");
                }
            }
        }
    }
}

