/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dropsomething;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedDropSomething;
import jp.sourceforge.akjrcp.dropsomething.FFMpegOptionEditor;
import jp.sourceforge.akjrcp.dropsomething.IDropSomething;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegExecuter;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.flvtools.explorer.ThumbnailManager;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.ui.GenericParameters;
import jp.sourceforge.akjrcp.ui.GenericParametersEditor;
import jp.sourceforge.akjrcp.ui.GenericParametersEditorDialog;
import jp.sourceforge.akjrcp.ui.GenericParametersEventListener;
import jp.sourceforge.akjrcp.ui.GenericParametersFFMpegPreference;
import jp.sourceforge.akjrcp.ui.GenericParametersSaveDialog;
import jp.sourceforge.akjrcp.ui.GenericParametersTableViewer;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class FFMpegConvertTabBuilder
implements IDropSomething {
    public static Log log = LogFactory.getLog(FFMpegConvertTabBuilder.class);
    private FileOverwriteControler fileOverwriteControler;
    public static final String TYPE_SELECT = "type_select";
    public static final String AVISYNTH = "avisynth";
    public static final String FFMPEGCONVERT = "ffmpegconvert";

    public void createTab(ViewPart part, CTabFolder tab) {
        CTabItem tabItem1 = new CTabItem(tab, 0);
        tabItem1.setText(Messages.getString("ffmpegconvert.tab"));
        FFMpegConvertTab dtab = new FFMpegConvertTab((Composite)tab, 0);
        dtab.setViewPart(part);
        tabItem1.setControl((Control)dtab);
        this.fileOverwriteControler = new FileOverwriteControler(tab.getShell());
    }

    public class FFMpegConvertTab
    extends DirectoryBasedDropSomething {
        private FFMpegExecuter ffmpegExecuter;
        private Label dragHere;
        private String currentTarget;
        private Button avisynth;
        private List settingList;
        private GenericParametersTableViewer tableViewer;
        private Button saveSetting;
        private Button newSetting;
        private CustomFFMpegOptionEditor editor;

        public FFMpegConvertTab(Composite parent, int style) {
            super(parent, style);
        }

        public void tableSelectionChanged() {
            GenericParameters parameters;
            this.saveSetting.setEnabled(false);
            int selection = this.tableViewer.getTable().getSelectionIndex();
            if (selection >= 0) {
                log.info((Object)("table item changed:" + selection));
                parameters = (GenericParameters)this.tableViewer.getTable().getItem(this.tableViewer.getTable().getSelectionIndex()).getData();
            } else {
                parameters = new GenericParameters();
                parameters.set("b", "2500k");
                parameters.set("EXTENSION", "mpg");
                parameters.set("ab", "128k");
            }
            Map<String, String> map = parameters.getParameters();
            this.editor.setParameters(map);
            this.saveSetting.setEnabled(false);
        }

        public Composite createControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            Composite listComposite = new Composite(composite, 0);
            listComposite.setLayoutData((Object)new GridData(768));
            listComposite.setLayout((Layout)new GridLayout(2, false));
            List list = GenericParametersTableViewer.loadList(this.getPreferenceStore().getString("ffmpegsetting.ffmpeg_settings"));
            GridData gd = new GridData(768);
            gd.heightHint = 40;
            this.tableViewer = new GenericParametersTableViewer(listComposite);
            this.tableViewer.getTable().setLayoutData((Object)gd);
            this.tableViewer.setGenericParametersList(list);
            this.tableViewer.addSelectionChangedListener(new SelectChanged());
            Composite buttons = new Composite(listComposite, 0);
            buttons.setLayout((Layout)new GridLayout(1, false));
            this.newSetting = new Button(buttons, 0);
            this.newSetting.setText(Messages.getString("h264converter.new"));
            this.newSetting.addSelectionListener((SelectionListener)new GenericNew());
            this.saveSetting = new Button(buttons, 0);
            this.saveSetting.setText(Messages.getString("h264converter.save"));
            this.saveSetting.setEnabled(false);
            this.saveSetting.addSelectionListener((SelectionListener)new GenericSave());
            this.settingList = new ArrayList();
            this.setPreferenceKey(FFMpegConvertTabBuilder.FFMPEGCONVERT);
            this.editor = new CustomFFMpegOptionEditor();
            this.editor.createControls(composite);
            this.editor.addListener(new GenericParametersEventListener(){

                public void updateModified(boolean modified) {
                    FFMpegConvertTab.this.saveSetting.setEnabled(modified);
                }
            });
            this.updateStatus();
            Akj_betasPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new PreferenceStoreMonitor());
            int defaultSelect = this.getPreferenceStore().getInt("ffmpegsetting.ffmpeg_settings_index");
            log.info((Object)("defaultSelect:" + defaultSelect));
            if (this.tableViewer.getTable().getItemCount() > defaultSelect) {
                this.tableViewer.getTable().setSelection(Math.max(0, defaultSelect));
            } else if (this.tableViewer.getTable().getItemCount() > 0) {
                this.tableViewer.getTable().setSelection(0);
            } else {
                log.info((Object)"item is empty");
            }
            this.tableSelectionChanged();
            this.tableViewer.addSelectionChangedListener(new StoreSelect());
            return composite;
        }

        public void updateSettingTable() {
            List list = GenericParametersTableViewer.loadList(Akj_betasPlugin.getDefault().getPreferenceStore().getString("ffmpegsetting.ffmpeg_settings"));
            this.tableViewer.setGenericParametersList(list);
            if (this.tableViewer.getTable().getItemCount() > 0) {
                this.tableViewer.getTable().setSelection(0);
            }
        }

        public void restoreControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.avisynth) {
                this.avisynth.setSelection(store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + FFMpegConvertTabBuilder.AVISYNTH));
            }
        }

        public void selectCombo(CCombo combo, String value) {
            int s = combo.getItemCount();
            int i = 0;
            while (i < s) {
                if (combo.getItem(i).equals(value)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }

        public void storeControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.avisynth) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + FFMpegConvertTabBuilder.AVISYNTH, this.avisynth.getSelection());
            }
        }

        public String toTime(long bps, long maxMega) {
            String sstring;
            String mstring;
            long bytes = bps / 8L;
            long second = maxMega * 1024L * 1024L / bytes;
            long hour = second / 3600L;
            long min = (second %= 3600L) / 60L;
            long sec = second % 60L;
            String hstring = "" + hour;
            if (hstring.length() < 2) {
                hstring = "0" + hstring;
            }
            if ((mstring = "" + min).length() < 2) {
                mstring = "0" + mstring;
            }
            if ((sstring = "" + sec).length() < 2) {
                sstring = "0" + sstring;
            }
            return String.valueOf(hstring) + ":" + mstring + ":" + sstring;
        }

        public void inconvert(File file) {
            this.ffmpegExecuter.execute(new File[]{file});
        }

        public void beforeConvert() {
            this.ffmpegExecuter = new FFMpegExecuter();
            this.ffmpegExecuter.setExecuteListener(new FFMpegMonitor());
            Map newMap = this.editor.getParameters();
            GenericParameters setting = new GenericParameters();
            setting.setParameters(newMap);
            GenericParametersFFMpegPreference preference = new GenericParametersFFMpegPreference(setting);
            String ffmpegPath = FFMpegUI.getFFmpeg();
            if (ffmpegPath == null) {
                ffmpegPath = FFMpegUI.getPureFFmpeg();
            }
            preference.setFfmpegPath(ffmpegPath);
            log.info((Object)preference);
            boolean threads = FFMpegUI.isUseThread();
            if (threads && "h264".equals(preference.getVideoCodec())) {
                preference.setThreads(2);
            }
            this.ffmpegExecuter.setFfmpegPreference(preference);
            this.ffmpegExecuter.setUseAvisynth(this.avisynth.getSelection());
            this.ffmpegExecuter.setIgnoreAvisynthExtensions(new String[0]);
            this.ffmpegExecuter.setSameDirectory(this.samefolder.getSelection());
            this.ffmpegExecuter.setBackup(this.backup.getSelection());
            if (!this.samefolder.getSelection()) {
                this.ffmpegExecuter.setExportDir(this.directoryChooser.getAbsoluteFilePath());
            }
        }

        public void afterConvert() {
        }

        public boolean isCanConvert() {
            String ffmpegPath = FFMpegUI.getFFmpegOrPureFFMpeg();
            if (!FFMpegUI.isFFMpegOrPureFFMpegAvailable(ffmpegPath)) {
                this.setCantConvertStatusbarMessage(Messages.getString("ffmpeg_statusbar.no_ffmpeg"));
                return false;
            }
            return super.isCanConvert();
        }

        public void cancelConvert() {
            this.ffmpegExecuter.cancel();
        }

        public void updateStatus() {
            if (this.samefolder.getSelection() || this.directoryChooser.getFile() != null) {
                this.setMessage(Messages.getString("dropsomething.drag_folder"));
                this.setCanConvert(true);
            } else {
                this.setErrorMessage(Messages.getString("dropsomething.choose_folder"));
                this.setCantConvertStatusbarMessage(Messages.getString("dropsomething.choose_folder"));
                this.setCanConvert(false);
            }
        }

        public void setMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 64, 255, 64));
                this.dragHere.setText(text);
            }
        }

        public void setErrorMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 255, 0, 0));
                this.dragHere.setText(text);
            }
        }

        public IPreferenceStore getPreferenceStore() {
            return Akj_betasPlugin.getDefault().getPreferenceStore();
        }

        public boolean setFocus() {
            return this.tableViewer.getTable().setFocus();
        }

        public class SelectChanged
        implements ISelectionChangedListener {
            public void selectionChanged(SelectionChangedEvent event) {
                FFMpegConvertTab.this.tableSelectionChanged();
            }
        }

        public class GenericNew
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GenericParametersEditorDialog dialog = new GenericParametersEditorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                int result = dialog.open();
                if (result == 0) {
                    GenericParameters newed = GenericParameters.csvToParameters(dialog.getCommand());
                    newed.setName(dialog.getName());
                    newed.setComment(dialog.getComment());
                    FFMpegConvertTab.this.tableViewer.getGenericParameters().add(newed);
                    FFMpegConvertTab.this.tableViewer.refresh();
                    GenericParameters[] infos = FFMpegConvertTab.this.tableViewer.getGenericParameters().toArray(new GenericParameters[0]);
                    String newValue = GenericParametersEditor.toStoreString(infos);
                    FFMpegConvertTab.this.getPreferenceStore().setValue("ffmpegsetting.ffmpeg_settings", newValue);
                    FFMpegConvertTab.this.tableViewer.getTable().setSelection(FFMpegConvertTab.this.tableViewer.getTable().getItemCount() - 1);
                    FFMpegConvertTab.this.tableSelectionChanged();
                } else {
                    log.info((Object)result);
                }
            }
        }

        public class GenericSave
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GenericParameters parameter = FFMpegConvertTab.this.tableViewer.getCurrentSelection();
                GenericParametersSaveDialog dialog = new GenericParametersSaveDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                if (parameter == null) {
                    dialog.setName(Messages.getString("dropsomething.newsetting"));
                } else {
                    String newName = FFMpegConvertTab.this.tableViewer.copiedName(parameter);
                    dialog.setName(newName);
                    dialog.setComment(parameter.getComment());
                }
                int ret = dialog.open();
                if (ret == 0) {
                    log.info((Object)("Save:" + dialog.isSaveOverwrite()));
                    Map newMap = FFMpegConvertTab.this.editor.getParameters();
                    if (dialog.isSaveOverwrite()) {
                        parameter.setParameters(newMap);
                        parameter.setComment(dialog.getComment());
                        FFMpegConvertTab.this.tableViewer.getTable().getSelectionIndex();
                    } else {
                        GenericParameters newParam = new GenericParameters();
                        newParam.setName(dialog.getName());
                        newParam.setComment(dialog.getComment());
                        newParam.setParameters(newMap);
                        FFMpegConvertTab.this.tableViewer.getGenericParameters().add(newParam);
                        FFMpegConvertTab.this.tableViewer.refresh();
                        int cfr_ignored_0 = FFMpegConvertTab.this.tableViewer.getTable().getItemCount() - 1;
                    }
                    GenericParameters[] infos = FFMpegConvertTab.this.tableViewer.getGenericParameters().toArray(new GenericParameters[0]);
                    String newValue = GenericParametersEditor.toStoreString(infos);
                    FFMpegConvertTab.this.getPreferenceStore().setValue("ffmpegsetting.ffmpeg_settings", newValue);
                    FFMpegConvertTab.this.tableSelectionChanged();
                }
            }
        }

        public class CustomFFMpegOptionEditor
        extends FFMpegOptionEditor {
            public Composite createOtherControls(Composite parent) {
                FFMpegConvertTab.this.createDirectoryInfo(parent);
                SavePreferenceStore savePreference = new SavePreferenceStore();
                FFMpegConvertTab.this.avisynth = new Button(parent, 32);
                FFMpegConvertTab.this.avisynth.setText(Messages.getString("pspconvert.use_avisynth"));
                FFMpegConvertTab.this.avisynth.setToolTipText(Messages.getString("pspconvert.use_avisynth_tooltip"));
                FFMpegConvertTab.this.avisynth.addSelectionListener((SelectionListener)savePreference);
                FFMpegConvertTab.this.dragHere = new Label(parent, 0);
                FFMpegConvertTab.this.dragHere.setLayoutData((Object)new GridData(768));
                FFMpegConvertTab.this.restoreControl((Control)FFMpegConvertTab.this.avisynth);
                return parent;
            }
        }

        public class StoreSelect
        implements ISelectionChangedListener {
            public void selectionChanged(SelectionChangedEvent event) {
                FFMpegConvertTab.this.getPreferenceStore().setValue("ffmpegsetting.ffmpeg_settings_index", FFMpegConvertTab.this.tableViewer.getTable().getSelectionIndex());
            }
        }

        public class PreferenceStoreMonitor
        implements Preferences.IPropertyChangeListener {
            public void propertyChange(Preferences.PropertyChangeEvent event) {
                log.info((Object)event.getProperty());
                if (event.getProperty().equals("ffmpegsetting.ffmpeg_settings")) {
                    FFMpegConvertTab.this.updateSettingTable();
                }
            }
        }

        public class SetPSPDir
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent e) {
                File[] roots = File.listRoots();
                int i = roots.length - 1;
                while (i > 0) {
                    File videoFolder;
                    File tmp = new File(roots[i], "PSP");
                    if (tmp.exists() && (videoFolder = new File(roots[i], "VIDEO")).exists()) {
                        FFMpegConvertTab.this.directoryChooser.setEnabled(true);
                        FFMpegConvertTab.this.samefolder.setSelection(false);
                        FFMpegConvertTab.this.directoryChooser.setFile(videoFolder);
                        FFMpegConvertTab.this.updateStatus();
                    }
                    --i;
                }
            }
        }

        public class SavePreferenceStore
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FFMpegConvertTab.this.storeControl((Control)e.getSource());
            }
        }

        public class FFMpegMonitor
        implements DirectryBasedExecuterListener {
            public void beforeConvert() {
            }

            public void afterConvert() {
                FFMpegConvertTab.this.setProgress(0);
            }

            public void startConvert(File file) {
                FFMpegConvertTab.this.setProgress(0);
                FFMpegFLVParser parser = new FFMpegFLVParser(FFMpegConvertTab.this.ffmpegExecuter.getFfmpegPreference().getFfmpegPath());
                FLVInfomation info = parser.parseFile(file);
                int guessSize = FFMpegPreference.toKBytes(info.getDuration(), FFMpegConvertTab.this.ffmpegExecuter.getFfmpegPreference().getVideoBitrate() + FFMpegConvertTab.this.ffmpegExecuter.getFfmpegPreference().getAudioBitrate());
                log.info((Object)("guessSize:" + guessSize));
                guessSize = (int)((double)guessSize * 1.1);
                FFMpegConvertTab.this.setProgressMaxBytes(guessSize);
            }

            public void endConvert(File file) {
                FFMpegConvertTab.this.setProgress(100);
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[complete:FFMpeg]" + file.getAbsolutePath() + "\n\n");
                String name = FileNameUtils.getChangedExtensionName(FFMpegConvertTab.this.ffmpegExecuter.getCurrentOutputFile(), "jpg", true);
                File jpegFile = new File(name);
                ThumbnailManager.makeThumbnail(file, 3, jpegFile);
            }

            public void faildConvert(File file, String message) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[faild:FFMpeg]" + message + "," + file.getAbsolutePath() + "\n\n");
            }

            public void printProcess(String line) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printError(line);
                if (FFMpegUtils.isProgressString(line)) {
                    FFMpegConvertTab.this.progressBytes(FFMpegUtils.getProgressSize(line));
                }
            }

            public boolean askOverwrite(File output) {
                return FileOverwriteControler.askOverwrite(FFMpegConvertTabBuilder.this.fileOverwriteControler, output);
            }
        }
    }
}

