/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.fieldassist;

import java.util.HashMap;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;

public class FieldDecorationRegistry {
    public static final String DEC_CONTENT_PROPOSAL = "DEC_CONTENT_PROPOSAL";
    public static final String DEC_REQUIRED = "DEC_REQUIRED";
    public static final String DEC_ERROR = "DEC_ERROR";
    public static final String DEC_WARNING = "DEC_WARNING";
    private static final String IMG_DEC_FIELD_CONTENT_PROPOSAL = "org.eclipse.jface.fieldassist.IMG_DEC_FIELD_CONTENT_PROPOSAL";
    private static final String IMG_DEC_FIELD_REQUIRED = "org.eclipse.jface.fieldassist.IMG_DEC_FIELD_REQUIRED";
    private static final String IMG_DEC_FIELD_ERROR = "org.eclipse.jface.fieldassist.IMG_DEC_FIELD_ERROR";
    private static final String IMG_DEC_FIELD_WARNING = "org.eclipse.jface.fieldassist.IMG_DEC_FIELD_WARNING";
    private static FieldDecorationRegistry defaultInstance;
    private int maxDecorationWidth = 0;
    private int maxDecorationHeight = 0;
    private HashMap decorations = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.fieldassist.FieldDecorationRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        imageRegistry.put(IMG_DEC_FIELD_CONTENT_PROPOSAL, ImageDescriptor.createFromFile(clazz, "images/content_proposal_cue.gif"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jface.fieldassist.FieldDecorationRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        imageRegistry.put(IMG_DEC_FIELD_ERROR, ImageDescriptor.createFromFile(clazz2, "images/error_cue.gif"));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.jface.fieldassist.FieldDecorationRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        imageRegistry.put(IMG_DEC_FIELD_WARNING, ImageDescriptor.createFromFile(clazz3, "images/warning_cue.gif"));
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.jface.fieldassist.FieldDecorationRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        imageRegistry.put(IMG_DEC_FIELD_REQUIRED, ImageDescriptor.createFromFile(clazz4, "images/required_field_cue.gif"));
        FieldDecorationRegistry.getDefault().registerFieldDecoration(DEC_CONTENT_PROPOSAL, JFaceResources.getString("FieldDecorationRegistry.contentAssistMessage"), IMG_DEC_FIELD_CONTENT_PROPOSAL, imageRegistry);
        FieldDecorationRegistry.getDefault().registerFieldDecoration(DEC_ERROR, JFaceResources.getString("FieldDecorationRegistry.errorMessage"), IMG_DEC_FIELD_ERROR, imageRegistry);
        FieldDecorationRegistry.getDefault().registerFieldDecoration(DEC_WARNING, null, IMG_DEC_FIELD_WARNING, imageRegistry);
        FieldDecorationRegistry.getDefault().registerFieldDecoration(DEC_REQUIRED, JFaceResources.getString("FieldDecorationRegistry.requiredFieldMessage"), IMG_DEC_FIELD_REQUIRED, imageRegistry);
    }

    public static FieldDecorationRegistry getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new FieldDecorationRegistry();
        }
        return defaultInstance;
    }

    public static void setDefault(FieldDecorationRegistry defaultRegistry) {
        defaultInstance = defaultRegistry;
    }

    public int getMaximumDecorationWidth() {
        return this.maxDecorationWidth;
    }

    public int getMaximumDecorationHeight() {
        return this.maxDecorationHeight;
    }

    public void registerFieldDecoration(String id, String description, Image image) {
        this.decorations.put(id, new Entry(description, image));
    }

    public void registerFieldDecoration(String id, String description, String imageId) {
        this.decorations.put(id, new Entry(description, imageId, JFaceResources.getImageRegistry()));
    }

    public void registerFieldDecoration(String id, String description, String imageId, ImageRegistry imageRegistry) {
        this.decorations.put(id, new Entry(description, imageId, imageRegistry));
    }

    public void unregisterFieldDecoration(String id) {
        this.decorations.put(id, null);
    }

    public FieldDecoration getFieldDecoration(String id) {
        Object entry = this.decorations.get(id);
        if (entry == null) {
            return null;
        }
        FieldDecoration dec = ((Entry)entry).getDecoration();
        Image image = dec.getImage();
        if (image != null) {
            this.maxDecorationHeight = Math.max(0, image.getBounds().height);
            this.maxDecorationWidth = Math.max(0, image.getBounds().width);
        }
        return dec;
    }

    class Entry {
        private String description;
        private String imageId;
        private ImageRegistry imageRegistry;
        private Image image;
        private FieldDecoration decoration;

        Entry(String description, String imageId, ImageRegistry registry) {
            this.description = description;
            this.imageId = imageId;
            this.imageRegistry = registry;
        }

        Entry(String description, Image image) {
            this.description = description;
            this.image = image;
        }

        FieldDecoration getDecoration() {
            if (this.decoration == null) {
                if (this.image == null) {
                    if (this.imageRegistry == null) {
                        this.imageRegistry = JFaceResources.getImageRegistry();
                    }
                    this.image = this.imageRegistry.get(this.imageId);
                }
                this.decoration = new FieldDecoration(this.image, this.description);
            }
            this.description = null;
            this.imageId = null;
            this.imageRegistry = null;
            this.image = null;
            return this.decoration;
        }
    }
}

