/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.greycstoration;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedExecuter;
import jp.sourceforge.akjrcp.dropsomething.DropsomethingView;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVFileEffector;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.greycstoration.BeforeAfterBufferedImageMaker;
import jp.sourceforge.akjrcp.greycstoration.RepeatBufferedImageMaker;
import jp.sourceforge.akjrcp.greycstoration.RestorationSetting;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.util.PathnameUtils;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import jp.sourceforge.akjrcp.util.image.ImageUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;

public class DirectoryBasedGreycstorationExecuter
implements DirectoryBasedExecuter {
    public static Log log = LogFactory.getLog(DirectoryBasedGreycstorationExecuter.class);
    private DirectryBasedExecuterListener executeListener;
    private String exportDir;
    private boolean sameDirectory;
    private boolean backup;
    RestorationSetting restorationSetting;
    private Process process;
    private boolean cancelling;
    private String settingLabel;
    private GFFMpegFLVFileEffector effector;
    private boolean createCompareImage;
    RepeatImageSetting repeatImageSetting = new RepeatImageSetting();
    private static ProcessTimeout processTimeout;

    public void execute(File[] files) {
        if (this.executeListener != null) {
            this.executeListener.beforeConvert();
        }
        int i = 0;
        while (i < files.length) {
            this.execute(files[i]);
            ++i;
        }
        if (this.executeListener != null) {
            this.executeListener.afterConvert();
        }
    }

    private void execute(File file) {
        if (file.isDirectory()) {
            if (this.cancelling) {
                log.info((Object)("cancel " + file));
                return;
            }
            String[] list = file.list();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    this.execute(new File(file, list[i]));
                    ++i;
                }
            }
        } else if (this.accept(file.getParentFile(), file.getName())) {
            if (this.isFLV(file)) {
                this.inExecuteMovie(file);
            } else {
                this.inExecute(file);
            }
        }
    }

    public void cancel() {
        log.info((Object)"call cancel");
        this.cancelling = true;
        if (this.process != null) {
            this.process.destroy();
        }
        if (this.effector != null) {
            this.effector.cancel();
        }
    }

    public void setStatusValue(String value) {
        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new SetMessage(value));
    }

    public static final ProcessTimeout getProcessTimeout() {
        if (processTimeout == null) {
            processTimeout = new ProcessTimeout();
            processTimeout.start();
        }
        return processTimeout;
    }

    private void inExecuteMovie(File inputFile) {
        if (this.cancelling) {
            log.info((Object)("cancel " + inputFile));
            return;
        }
        if (this.executeListener != null) {
            this.executeListener.startConvert(inputFile);
        }
        String outputDir = inputFile.getParent();
        if (!this.sameDirectory) {
            outputDir = this.exportDir;
        }
        String outputPath = String.valueOf(outputDir) + "\\" + this.restorationSetting.toFileName(inputFile.getName());
        log.info((Object)inputFile.getAbsolutePath());
        log.info((Object)outputPath);
        File outPutFile = new File(outputPath);
        File tmpOutput = null;
        try {
            tmpOutput = File.createTempFile("grey", inputFile.getName());
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        boolean overwrite = false;
        if (outPutFile.exists() && !outPutFile.canWrite() && !outPutFile.exists() && this.executeListener != null) {
            this.executeListener.faildConvert(inputFile, "file can't overwrite");
            return;
        }
        if (!this.backup && outPutFile.exists() && this.executeListener != null && !(overwrite = this.executeListener.askOverwrite(tmpOutput))) {
            if (this.executeListener != null) {
                this.executeListener.faildConvert(inputFile, "file don't overwrite");
            }
            return;
        }
        String ffmpegPath = FFMpegUI.getFFmpeg();
        this.effector = new GFFMpegFLVFileEffector(ffmpegPath, inputFile, tmpOutput);
        this.effector.setInputImageType(1);
        this.effector.setOutputImageType(1);
        this.effector.start();
        long starttime = System.currentTimeMillis();
        while (!this.effector.isDoneRead() || !this.effector.isDoneWrite()) {
            try {
                Thread.sleep(3000L);
                this.setStatusValue(String.valueOf(FFMpegFLVFileEffector.doneFrames) + "frames done.it's about " + FFMpegFLVFileEffector.doneFrames / 30L + "second");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("***finally finished***");
        long end = System.currentTimeMillis() - starttime;
        String min = "" + end / 1000L / 60L;
        log.info((Object)("time:" + min));
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (outPutFile.exists()) {
            if (this.backup) {
                File newBackupFile = PathnameUtils.getEmptyFileName(outPutFile);
                boolean renamed = outPutFile.renameTo(newBackupFile);
                if (renamed) {
                    boolean renamed2 = tmpOutput.renameTo(new File(outputPath));
                    if (!renamed2 && this.executeListener != null) {
                        tmpOutput.delete();
                        this.executeListener.faildConvert(inputFile, "file can't overwrite");
                        return;
                    }
                } else if (this.executeListener != null) {
                    tmpOutput.delete();
                    this.executeListener.faildConvert(inputFile, "file can't overwrite");
                    return;
                }
            } else {
                outPutFile.delete();
                boolean renamed2 = tmpOutput.renameTo(new File(outputPath));
                if (!renamed2 && this.executeListener != null) {
                    tmpOutput.delete();
                    this.executeListener.faildConvert(inputFile, "file can't overwrite");
                    return;
                }
            }
        } else {
            boolean renamed2 = tmpOutput.renameTo(new File(outputPath));
            if (!renamed2 && this.executeListener != null) {
                tmpOutput.delete();
                this.executeListener.faildConvert(inputFile, "file can't overwrite");
                return;
            }
        }
        if (this.executeListener != null) {
            this.executeListener.endConvert(inputFile);
        }
        this.effector = null;
        this.process = null;
        this.cancelling = false;
    }

    public void createRestorateImage(File inputFile, File outputFile, RestorationSetting restorationSetting) throws IOException {
        File exeInput = null;
        File exeOutput = null;
        boolean usingTemp = false;
        if (this.isBMP(inputFile)) {
            exeInput = inputFile;
            exeOutput = outputFile;
        } else {
            try {
                usingTemp = true;
                exeInput = File.createTempFile("temp", ".bmp");
                Image image = new Image(null, inputFile.getAbsolutePath());
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{image.getImageData()};
                loader.save(exeInput.getAbsolutePath(), 0);
                log.trace((Object)exeInput.getAbsolutePath());
                exeOutput = File.createTempFile("temp", ".bmp");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String[] commands = restorationSetting.toCommand(exeInput, exeOutput);
        log.info((Object)ArrayUtils.toString((Object)commands));
        Runtime runtime = Runtime.getRuntime();
        ErrorCatchProcessPrinter printer = new ErrorCatchProcessPrinter();
        try {
            printer.printOutput(DirectoryBasedGreycstorationExecuter.toDebugArray(commands));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.process = null;
        try {
            this.process = runtime.exec(commands);
            ProcessMonitor monitor = new ProcessMonitor(this.process, printer);
            monitor.startMonitor();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            this.process.destroy();
            if (usingTemp) {
                exeInput.delete();
                exeOutput.delete();
            }
            throw e1;
        }
        if (usingTemp) {
            try {
                BufferedImage image = ImageIO.read(exeOutput);
                if (image == null) {
                    exeInput.delete();
                    exeOutput.delete();
                    throw new IOException("image is null");
                }
                if (this.isJPEG(outputFile)) {
                    ImageUtils.writeJpegWithQuality(image, outputFile, 1.0f);
                } else if (this.isPNG(outputFile)) {
                    ImageIO.write((RenderedImage)image, "PNG", outputFile);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            exeInput.delete();
            exeOutput.delete();
        }
    }

    private void inExecute(File inputFile) {
        long starttime = System.currentTimeMillis();
        if (this.cancelling) {
            log.info((Object)("cancel " + inputFile));
            return;
        }
        if (this.executeListener != null) {
            this.executeListener.startConvert(inputFile);
        }
        String outputDir = inputFile.getParent();
        if (!this.sameDirectory) {
            outputDir = this.exportDir;
        }
        String outputPath = String.valueOf(outputDir) + "\\" + this.restorationSetting.toFileName(inputFile.getName());
        log.info((Object)inputFile.getAbsolutePath());
        log.info((Object)outputPath);
        if (this.repeatImageSetting.isEnabled()) {
            RepeatBufferedImageMaker repeatBufferedImageMaker = new RepeatBufferedImageMaker(this.repeatImageSetting.getRepeatTime(), this.settingLabel);
            int i = 0;
            while (i < this.repeatImageSetting.getRepeatTime()) {
                try {
                    File tmpImage = File.createTempFile("grey", inputFile.getName());
                    this.createRestorateImage(inputFile, tmpImage, this.restorationSetting);
                    BufferedImage drawImage = ImageIO.read(tmpImage);
                    repeatBufferedImageMaker.paintImage(drawImage, this.restorationSetting.getParamLabel(this.repeatImageSetting.getParamName()));
                    drawImage = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (this.executeListener != null) {
                        this.executeListener.faildConvert(inputFile, "can't make temp file");
                    }
                    return;
                }
                System.gc();
                this.restorationSetting.incrementValue(this.repeatImageSetting.getParamName(), this.repeatImageSetting.getIncrementValue());
                ++i;
            }
            File repeatFile = new File(new File(outputPath).getParentFile(), String.valueOf(PathnameUtils.removeExtension(inputFile.getName())) + "_repeat.png");
            try {
                ImageIO.write((RenderedImage)repeatBufferedImageMaker.getBufferedImage(), "PNG", repeatFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.executeListener != null) {
                    this.executeListener.faildConvert(inputFile, "can't output " + repeatFile.getAbsolutePath());
                }
                return;
            }
        }
        File outPutFile = new File(outputPath);
        File tmpOutput = null;
        try {
            tmpOutput = File.createTempFile("grey", inputFile.getName());
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        boolean overwrite = false;
        if (outPutFile.exists() && !outPutFile.canWrite() && !outPutFile.exists() && this.executeListener != null) {
            this.executeListener.faildConvert(inputFile, "file can't overwrite");
            return;
        }
        if (!this.backup && outPutFile.exists() && this.executeListener != null && !(overwrite = this.executeListener.askOverwrite(tmpOutput))) {
            if (this.executeListener != null) {
                this.executeListener.faildConvert(inputFile, "file don't overwrite");
            }
            return;
        }
        File exeInput = null;
        File exeOutput = null;
        boolean usingTemp = false;
        if (this.isBMP(inputFile)) {
            exeInput = inputFile;
            exeOutput = tmpOutput;
        } else {
            try {
                usingTemp = true;
                exeInput = File.createTempFile("temp", ".bmp");
                Image image = new Image(null, inputFile.getAbsolutePath());
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{image.getImageData()};
                loader.save(exeInput.getAbsolutePath(), 0);
                log.trace((Object)exeInput.getAbsolutePath());
                exeOutput = File.createTempFile("temp", ".bmp");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String[] commands = this.restorationSetting.toCommand(exeInput, exeOutput);
        log.info((Object)ArrayUtils.toString((Object)commands));
        Runtime runtime = Runtime.getRuntime();
        ErrorCatchProcessPrinter printer = new ErrorCatchProcessPrinter();
        try {
            printer.printOutput(DirectoryBasedGreycstorationExecuter.toDebugArray(commands));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.process = null;
        try {
            this.process = runtime.exec(commands);
            ProcessMonitor monitor = new ProcessMonitor(this.process, printer);
            monitor.startMonitor();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.process.destroy();
            if (this.executeListener != null) {
                this.executeListener.faildConvert(inputFile, e1.getMessage());
            }
            return;
        }
        if (usingTemp) {
            try {
                BufferedImage image = ImageIO.read(exeOutput);
                if (image == null && this.executeListener != null) {
                    tmpOutput.delete();
                    this.executeListener.faildConvert(inputFile, "file can't overwrite");
                    exeInput.delete();
                    exeOutput.delete();
                    return;
                }
                if (this.isJPEG(tmpOutput)) {
                    ImageUtils.writeJpegWithQuality(image, tmpOutput, 1.0f);
                } else if (this.isPNG(tmpOutput)) {
                    ImageIO.write((RenderedImage)image, "PNG", tmpOutput);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            exeInput.delete();
            exeOutput.delete();
        }
        if (outPutFile.exists()) {
            if (this.backup) {
                File newBackupFile = PathnameUtils.getEmptyFileName(outPutFile);
                boolean renamed = outPutFile.renameTo(newBackupFile);
                if (renamed) {
                    boolean renamed2 = tmpOutput.renameTo(new File(outputPath));
                    if (!renamed2 && this.executeListener != null) {
                        tmpOutput.delete();
                        this.executeListener.faildConvert(inputFile, "file can't overwrite");
                        return;
                    }
                } else if (this.executeListener != null) {
                    tmpOutput.delete();
                    this.executeListener.faildConvert(inputFile, "file can't overwrite");
                    return;
                }
            } else {
                outPutFile.delete();
                boolean renamed2 = tmpOutput.renameTo(new File(outputPath));
                if (!renamed2 && this.executeListener != null) {
                    tmpOutput.delete();
                    this.executeListener.faildConvert(inputFile, "file can't overwrite");
                    return;
                }
            }
        } else {
            boolean renamed2 = tmpOutput.renameTo(new File(outputPath));
            if (!renamed2 && this.executeListener != null) {
                tmpOutput.delete();
                this.executeListener.faildConvert(inputFile, "file can't overwrite");
                return;
            }
        }
        if (this.createCompareImage) {
            File outputFile = new File(outputPath);
            File before_after = new File(outputFile.getParentFile(), String.valueOf(PathnameUtils.removeExtension(inputFile.getName())) + "_before_after.png");
            try {
                BufferedImage image_before = ImageIO.read(inputFile);
                BufferedImage image_after = ImageIO.read(outputFile);
                BeforeAfterBufferedImageMaker bm = new BeforeAfterBufferedImageMaker();
                bm.setDescription(this.settingLabel);
                BufferedImage before_after_image = bm.createBufferedImage(image_before, image_after);
                ImageIO.write((RenderedImage)before_after_image, "PNG", before_after);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        long end = System.currentTimeMillis() - starttime;
        String sec = "" + end / 1000L;
        log.info((Object)("time:" + sec + "s"));
        if (this.executeListener != null) {
            this.executeListener.endConvert(inputFile);
        }
        this.process = null;
        this.cancelling = false;
    }

    public static String toDebugArray(String[] array) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        return String.valueOf(v) + "\n";
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public DirectryBasedExecuterListener getExecuteListener() {
        return this.executeListener;
    }

    public void setExecuteListener(DirectryBasedExecuterListener executeListener) {
        this.executeListener = executeListener;
    }

    public String getExportDir() {
        return this.exportDir;
    }

    public void setExportDir(String exportDir) {
        this.exportDir = exportDir;
    }

    public boolean isSameDirectory() {
        return this.sameDirectory;
    }

    public void setSameDirectory(boolean sameDirectory) {
        this.sameDirectory = sameDirectory;
    }

    public boolean accept(File parent, String name) {
        String[] supportImages = new String[]{"jpg", "bmp", "png", "flv"};
        int i = 0;
        while (i < supportImages.length) {
            if (name.toLowerCase().endsWith("." + supportImages[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isFLV(File file) {
        return file.getName().toLowerCase().endsWith(".flv");
    }

    public boolean isBMP(File file) {
        return file.getName().toLowerCase().endsWith(".bmp");
    }

    public boolean isJPEG(File file) {
        return file.getName().toLowerCase().endsWith(".jpg");
    }

    public boolean isPNG(File file) {
        return file.getName().toLowerCase().endsWith(".png");
    }

    public RestorationSetting getRestorationSetting() {
        return this.restorationSetting;
    }

    public void setRestorationSetting(RestorationSetting restorationSetting) {
        this.restorationSetting = restorationSetting;
    }

    public String getSettingLabel() {
        return this.settingLabel;
    }

    public void setSettingLabel(String settingLabel) {
        this.settingLabel = settingLabel;
    }

    public boolean isCreateCompareImage() {
        return this.createCompareImage;
    }

    public void setCreateCompareImage(boolean createCompareImage) {
        this.createCompareImage = createCompareImage;
    }

    public class RepeatImageSetting {
        private boolean enabled;
        private String paramName;
        private double incrementValue;
        private int repeatTime;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public double getIncrementValue() {
            return this.incrementValue;
        }

        public void setIncrementValue(double incrementValue) {
            this.incrementValue = incrementValue;
        }

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public int getRepeatTime() {
            return this.repeatTime;
        }

        public void setRepeatTime(int repeatTime) {
            this.repeatTime = repeatTime;
        }
    }

    public class SetMessage
    implements Runnable {
        String message;

        SetMessage(String message) {
            this.message = message;
        }

        public void run() {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)DropsomethingView.viewSite.getWorkbenchWindow();
            WWinActionBars actionBars = workbenchWindow.getActionBars();
            IStatusLineManager manager = actionBars.getStatusLineManager();
            manager.setMessage(this.message);
        }
    }

    private static class ProcessTimeout
    extends Thread {
        private Process timeoutProcess;
        private long lastmodified;
        private long timeout = 120000L;
        private boolean monitering = true;

        private ProcessTimeout() {
        }

        public void update(Process process) {
            this.timeoutProcess = process;
            this.lastmodified = System.currentTimeMillis();
        }

        public void run() {
            while (this.monitering) {
                if (this.timeoutProcess != null) {
                    if (System.currentTimeMillis() > this.lastmodified + this.timeout) {
                        log.warn((Object)"process destroyed by timeout");
                        this.timeoutProcess.destroy();
                        this.monitering = false;
                        DirectoryBasedGreycstorationExecuter.processTimeout = null;
                    } else {
                        log.info((Object)(this.timeoutProcess + " is OK"));
                    }
                }
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public class GFFMpegFLVFileEffector
    extends FFMpegFLVFileEffector {
        private ProcessPrinter printer;
        private boolean debug_copy_only;
        private int maxtrycound;

        public GFFMpegFLVFileEffector(String ffmpegPath, File input, File output) {
            super(ffmpegPath, input, output);
            this.debug_copy_only = false;
            this.maxtrycound = 5;
            this.printer = new ErrorCatchProcessPrinter();
        }

        public void effect(File inputFile, File outputFile) {
            try {
                if (this.debug_copy_only) {
                    FileUtils.copyFile((File)inputFile, (File)outputFile);
                    return;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            String[] commands = DirectoryBasedGreycstorationExecuter.this.restorationSetting.toCommand(inputFile, outputFile);
            Runtime runtime = Runtime.getRuntime();
            int i = 0;
            while (i < this.maxtrycound) {
                if (i != 0) {
                    log.warn((Object)(String.valueOf(i + 1) + "nd time try convert:" + ArrayUtils.toString((Object)commands)));
                }
                DirectoryBasedGreycstorationExecuter.this.process = null;
                try {
                    DirectoryBasedGreycstorationExecuter.this.process = runtime.exec(commands);
                    DirectoryBasedGreycstorationExecuter.getProcessTimeout().update(DirectoryBasedGreycstorationExecuter.this.process);
                    ProcessMonitor monitor = new ProcessMonitor(DirectoryBasedGreycstorationExecuter.this.process, this.printer);
                    monitor.startMonitor();
                    try {
                        DirectoryBasedGreycstorationExecuter.this.process.waitFor();
                        int result = DirectoryBasedGreycstorationExecuter.this.process.exitValue();
                        if (result == 0) {
                            return;
                        }
                        log.warn((Object)("exit values is wrong:" + result));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    DirectoryBasedGreycstorationExecuter.this.process.destroy();
                    System.out.println("killed process");
                }
                ++i;
            }
            if (DirectoryBasedGreycstorationExecuter.this.executeListener != null) {
                DirectoryBasedGreycstorationExecuter.this.executeListener.faildConvert(inputFile, "all time try faild");
            }
        }
    }

    public class ErrorCatchProcessPrinter
    implements ProcessPrinter {
        public void printOutput(String output) throws IOException {
            this.print(output);
        }

        public void printError(String error) throws IOException {
            this.print(error);
        }

        private void print(String line) throws IOException {
            if (DirectoryBasedGreycstorationExecuter.this.executeListener != null) {
                DirectoryBasedGreycstorationExecuter.this.executeListener.printProcess(line);
            }
        }
    }
}

