/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.internal.menus.IDynamicMenu;
import org.eclipse.ui.internal.menus.MenuContainer;
import org.eclipse.ui.internal.menus.SLocation;

public final class SMenu
extends MenuContainer {
    public static final String PROPERTY_LABEL = "LABEL";
    private String label;

    SMenu(String id) {
        super(id);
    }

    public final void define(String label, SLocation location) {
        this.define(label, location, null);
    }

    public final void define(String label, SLocation location, IDynamicMenu dynamic) {
        SLocation[] locations = location == null ? (SLocation[])null : new SLocation[]{location};
        this.define(label, locations, dynamic);
    }

    public final void define(String label, SLocation[] locations, IDynamicMenu dynamic) {
        if (locations != null && locations.length == 0) {
            locations = null;
        }
        this.setDefined(true);
        this.setLocations(locations);
        this.setDynamic(dynamic);
        this.setLabel(label);
    }

    public final String getLabel() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the label from an undefined menu");
        }
        return this.label;
    }

    protected final void setLabel(String label) {
        if (!Util.equals((Object)this.label, (Object)label)) {
            PropertyChangeEvent event = null;
            if (this.isListenerAttached()) {
                event = new PropertyChangeEvent((Object)this, PROPERTY_LABEL, (Object)this.label, (Object)label);
            }
            this.label = label;
            this.firePropertyChangeEvent(event);
        }
    }

    public final String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SMenu(");
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.label);
            stringBuffer.append(',');
            try {
                stringBuffer.append(this.dynamic);
            }
            catch (Exception e) {
                stringBuffer.append(e.getClass().getName());
            }
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(')');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final void undefine() {
        this.string = null;
        this.setLabel(null);
        this.setDynamic(null);
        this.setLocations(null);
        this.setDefined(false);
    }
}

