/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import jp.sourceforge.akjrcp.ui.AbstractParamItem;
import jp.sourceforge.akjrcp.ui.SpinnerAndScale;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ParamSpinnerAndScale
extends AbstractParamItem {
    private String key;
    private String label;
    private Label labelItem;
    private String value = "";
    private SpinnerAndScale spinnerAndScale;

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public void setDigits(int digit) {
        this.spinnerAndScale.setDigits(digit);
    }

    public void setToolTipText(String text) {
        this.labelItem.setToolTipText(text);
        this.spinnerAndScale.setToolTipText(text);
    }

    public String getValue() {
        return "" + this.spinnerAndScale.getDigitedSelection();
    }

    public void setValue(String value) {
        if (value.length() > 0) {
            double dvalue = Double.parseDouble(value);
            this.spinnerAndScale.setSelection(this.forDigit(dvalue));
        }
        this.value = value;
    }

    public ParamSpinnerAndScale(Composite parent, int style, String key, String label) {
        super(parent, style);
        this.key = key;
        this.label = label;
        this.setLayout((Layout)new GridLayout(2, false));
        this.labelItem = new Label((Composite)this, 0);
        this.labelItem.setText(label);
        this.spinnerAndScale = new SpinnerAndScale(this, 0);
        this.spinnerAndScale.addSelectionListener(new AbstractParamItem.SelectionCheck());
    }

    public boolean isModified() {
        String oldValue = this.getValue();
        return !oldValue.equals(this.value);
    }

    public void setMaximum(double max) {
        this.spinnerAndScale.setMaximum(this.forDigit(max));
    }

    public void setMinimum(double min) {
        this.spinnerAndScale.setMinimum(this.forDigit(min));
    }

    private int forDigit(double value) {
        int base = 1;
        int i = 0;
        while (i < this.spinnerAndScale.getSpinner().getDigits()) {
            base *= 10;
            ++i;
        }
        return (int)(value * (double)base);
    }

    public SpinnerAndScale getSpinnerAndScale() {
        return this.spinnerAndScale;
    }

    public void setSpinnerAndScale(SpinnerAndScale spinnerAndScale) {
        this.spinnerAndScale = spinnerAndScale;
    }
}

