/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.greycstoration;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class BeforeAfterBufferedImageMaker {
    private String image1Label = "Before";
    private String image2Label = "After";
    private int paddingTop = 20;
    private int paddingLeft = 10;
    private int paddingRight = 10;
    private int paddingBottom = 20;
    private int marginCell = 10;
    private String description = "";
    private Color labelColor = new Color(0, 0, 0);
    private Color backgroundColor = new Color(255, 255, 255);
    private Font labelFont = new Font("Courier", 0, 12);

    public BufferedImage createBufferedImage(Image before, Image after) {
        int imgW = this.paddingLeft + before.getWidth(null) + this.marginCell + after.getWidth(null) + this.paddingRight;
        int imgH = this.paddingTop + this.paddingBottom + Math.max(before.getHeight(null), after.getHeight(null));
        BufferedImage bimage = new BufferedImage(imgW, imgH, 1);
        Graphics2D g2 = (Graphics2D)bimage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setBackground(this.backgroundColor);
        g2.clearRect(0, 0, bimage.getWidth(), bimage.getHeight());
        g2.setColor(this.labelColor);
        g2.drawImage(before, this.paddingLeft, this.paddingTop, null);
        Rectangle beforeArea = new Rectangle(this.paddingLeft, 0, before.getWidth(null), this.paddingTop);
        this.fillShapInRect(g2, beforeArea, BeforeAfterBufferedImageMaker.makeStringShape(this.image1Label, this.labelFont));
        g2.drawImage(after, this.paddingLeft + before.getWidth(null) + this.marginCell, this.paddingTop, null);
        Rectangle afterArea = new Rectangle(this.paddingLeft + before.getWidth(null) + this.marginCell, 0, before.getWidth(null), this.paddingTop);
        this.fillShapInRect(g2, afterArea, BeforeAfterBufferedImageMaker.makeStringShape(this.image2Label, this.labelFont));
        Shape descriptionShape = BeforeAfterBufferedImageMaker.makeStringShape(this.description, this.labelFont);
        Rectangle descriptionArea = new Rectangle(0, bimage.getHeight() - this.paddingBottom, bimage.getWidth(), this.paddingBottom);
        this.fillShapInRect(g2, descriptionArea, descriptionShape);
        return bimage;
    }

    public void fillShapInRect(Graphics2D g2, Rectangle rect, Shape shape) {
        System.out.println(rect);
        System.out.println(this.description);
        System.out.println(shape.getBounds());
        int dx = 0;
        int dy = 0;
        int cx = (rect.width - shape.getBounds().width) / 2;
        int cy = (rect.height - shape.getBounds().height) / 2;
        dx = rect.x + cx - shape.getBounds().x;
        dy = rect.y + cy - shape.getBounds().y;
        System.out.println(String.valueOf(dx) + "," + dy);
        g2.translate(dx, dy);
        g2.fill(shape);
        g2.translate(-dx, -dy);
    }

    public static Shape makeStringShape(String text, Font font) {
        BufferedImage dstImage = new BufferedImage(1, 1, 2);
        Graphics2D g2 = (Graphics2D)dstImage.getGraphics();
        TextLayout textLayout = new TextLayout(text, font, g2.getFontRenderContext());
        Shape shape = textLayout.getOutline(new AffineTransform());
        return shape;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

