/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.explorer;

import java.util.List;
import jp.sourceforge.akjrcp.flvtools.explorer.ExplorerView;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public class FixLayout
extends StackLayout {
    Canvas canvas;

    public FixLayout(Canvas canvas) {
        this.canvas = canvas;
    }

    protected Dimension calculateMinimumSize(IFigure figure, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - figure.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - figure.getInsets().getHeight());
        }
        Dimension d = new Dimension();
        d.width = this.canvas.getClientArea().width;
        d.height = 400;
        List children = figure.getChildren();
        int maxH = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            int h = child.getBounds().y + child.getBounds().height;
            if (h > maxH) {
                maxH = h;
            }
            ++i;
        }
        d.height = maxH;
        ExplorerView.log.info((Object)("children:" + children.size()));
        ExplorerView.log.info((Object)("d:" + d));
        return d;
    }

    protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
        Dimension d = new Dimension();
        d.width = this.canvas.getClientArea().width;
        d.height = 400;
        List children = figure.getChildren();
        int maxH = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            int h = child.getBounds().y + child.getBounds().height;
            if (h > maxH) {
                maxH = h;
            }
            ++i;
        }
        d.height = maxH;
        ExplorerView.log.info((Object)("children:" + children.size()));
        ExplorerView.log.info((Object)("d:" + d));
        return d;
    }

    public void layout(IFigure figure) {
        ExplorerView.log.info((Object)"layout");
        List children = figure.getChildren();
        int w = 320;
        int h = 240;
        int nx = 0;
        int ny = 0;
        int mx = 5;
        int my = 5;
        int basew = this.canvas.getClientArea().width;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            if (nx + w > basew) {
                nx = 0;
                ny += h + my;
            }
            child.setBounds(new Rectangle(nx, ny, w, h));
            nx += w + mx;
            ++i;
        }
    }
}

