/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.IOException;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import jp.sourceforge.akjrcp.util.SimpleProcessPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleCommandExecuter {
    public static Log log = LogFactory.getLog(SimpleCommandExecuter.class);
    protected String[] command;
    private Process process;
    private ProcessPrinter printer;
    private long waitForCloseStream = 10000L;

    public SimpleCommandExecuter(String[] command) {
        this.command = command;
        this.printer = new SimpleProcessPrinter();
    }

    public void execute() {
        Runtime runtime = Runtime.getRuntime();
        try {
            this.process = runtime.exec(this.command);
            ProcessMonitor monitor = new ProcessMonitor(this.process, this.printer);
            monitor.startMonitor();
            try {
                this.process.waitFor();
                long c = System.currentTimeMillis();
                while (System.currentTimeMillis() < c + this.waitForCloseStream) {
                    if (!monitor.isErrorClosed() || !monitor.isInputClosed()) {
                        log.warn((Object)"wait:input reading");
                        Thread.sleep(100L);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public ProcessPrinter getPrinter() {
        return this.printer;
    }

    public void setPrinter(ProcessPrinter printer) {
        this.printer = printer;
    }

    public Process getProcess() {
        return this.process;
    }
}

