/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dropsomething;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.audio.MP3AudioSettingComposite;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedDropSomething;
import jp.sourceforge.akjrcp.dropsomething.IDropSomething;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegExecuter;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.MP3FFMpegPreference;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.util.StatusBarUtils;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MP3ConvertTabBuilder
implements IDropSomething {
    private FileOverwriteControler fileOverwriteControler;
    private CTabFolder tab;

    public void createTab(ViewPart part, CTabFolder tab) {
        CTabItem tabItem1 = new CTabItem(tab, 0);
        tabItem1.setText(Messages.getString("dropsomething.mp3audio"));
        MP3ConvertTab dtab = new MP3ConvertTab((Composite)tab, 0);
        dtab.setViewPart(part);
        tabItem1.setControl((Control)dtab);
        this.tab = tab;
    }

    public class MP3ConvertTab
    extends DirectoryBasedDropSomething {
        private FFMpegExecuter ffmpegExecuter;
        private CLabel dragHere;
        private Button forceConvert;
        private Button quickCopy;
        private CCombo defaultBitrate;
        private MP3AudioSettingComposite mp3setting;
        private Button useAvisynth;
        private Image noFFMpegImage;
        private Image canConvertImage;

        public MP3ConvertTab(Composite parent, int style) {
            super(parent, style);
        }

        public Composite createControls(Composite parent) {
            this.setPreferenceKey("mp3converttab");
            this.getPreferenceStore().setDefault(String.valueOf(this.getPreferenceKey()) + "." + "quickcopy", true);
            this.getPreferenceStore().setDefault(String.valueOf(this.getPreferenceKey()) + "." + "forceconvert", false);
            this.getPreferenceStore().setDefault(String.valueOf(this.getPreferenceKey()) + "." + "audioBitrate", "128");
            this.getPreferenceStore().setDefault(String.valueOf(this.getPreferenceKey()) + "." + "useAvisynth", false);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            Group exportDir = new Group(composite, 0);
            exportDir.setToolTipText(Messages.getString("mp3convert.exportDir.tooltip"));
            exportDir.setLayout((Layout)new GridLayout());
            exportDir.setLayoutData((Object)new GridData(768));
            exportDir.setText(Messages.getString("mp3convert.exportDir"));
            this.createDirectoryInfo((Composite)exportDir);
            Group detailSetting = new Group(composite, 0);
            detailSetting.setLayout((Layout)new FillLayout());
            detailSetting.setLayoutData((Object)new GridData(1808));
            detailSetting.setText(Messages.getString("mp3convert.detail"));
            ExpandBar bar = new ExpandBar((Composite)detailSetting, 512);
            Composite copybase = new Composite((Composite)bar, 0);
            copybase.setLayout((Layout)new RowLayout());
            this.quickCopy = new Button(copybase, 32);
            this.quickCopy.setText(Messages.getString("mp3convert.quickcopy"));
            this.quickCopy.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    MP3ConvertTab.this.updateStatus();
                }
            });
            ExpandItem item0 = new ExpandItem(bar, 0, 0);
            item0.setText(Messages.getString("mp3convert.aboutcopy"));
            item0.setHeight(copybase.computeSize((int)-1, (int)-1).y);
            item0.setControl((Control)copybase);
            Composite advancedSetting = new Composite((Composite)bar, 0);
            advancedSetting.setLayout((Layout)new GridLayout(1, false));
            Composite changebase = new Composite(advancedSetting, 0);
            changebase.setLayout((Layout)new RowLayout());
            this.forceConvert = new Button(changebase, 32);
            this.forceConvert.setText(Messages.getString("mp3convert.forceconvert"));
            this.mp3setting = new MP3AudioSettingComposite(changebase, 0, false, this.getPreferenceKey());
            ExpandItem item1 = new ExpandItem(bar, 0, 1);
            item1.setText(Messages.getString("mp3convert.convertsetting"));
            item1.setHeight(advancedSetting.computeSize((int)-1, (int)-1).y);
            item1.setControl((Control)advancedSetting);
            Composite bitrateBase = new Composite((Composite)bar, 0);
            bitrateBase.setLayout((Layout)new RowLayout());
            Label label1 = new Label(bitrateBase, 0);
            label1.setText(Messages.getString("mp3convert.defaultBitrate"));
            this.defaultBitrate = new CCombo(bitrateBase, 0);
            int[] bitrates = new int[]{64, 80, 96, 112, 128, 160, 192, 224, 256, 320};
            int i = 0;
            while (i < bitrates.length) {
                this.defaultBitrate.add("" + bitrates[i]);
                ++i;
            }
            this.defaultBitrate.select(4);
            Label label = new Label(bitrateBase, 0);
            label.setText("kbps");
            ExpandItem item2 = new ExpandItem(bar, 0, 2);
            item2.setText(Messages.getString("mp3convert.optionbitrate"));
            item2.setHeight(bitrateBase.computeSize((int)-1, (int)-1).y);
            item2.setControl((Control)bitrateBase);
            this.forceConvert.addSelectionListener((SelectionListener)new SynchEnabled(this.mp3setting));
            Composite avisynthBase = new Composite((Composite)bar, 0);
            avisynthBase.setLayout((Layout)new RowLayout());
            this.useAvisynth = new Button(avisynthBase, 32);
            this.useAvisynth.setText(Messages.getString("mp3convert.useAvisynth"));
            ExpandItem item3 = new ExpandItem(bar, 0, 3);
            item3.setText(Messages.getString("mp3convert.about_useAvisynth"));
            item3.setHeight(avisynthBase.computeSize((int)-1, (int)-1).y);
            item3.setControl((Control)avisynthBase);
            this.canConvertImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.akjrcp.akj_betas", (String)"icons/dandd_mp3.png").createImage();
            this.noFFMpegImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.akjrcp.akj_betas", (String)"icons/dandd_noffmpeg.png").createImage();
            this.dragHere = new CLabel(composite, 18432);
            this.dragHere.setBackground(ColorConstants.white);
            this.dragHere.setImage(this.canConvertImage);
            this.dragHere.setAlignment(0x1000000);
            this.dragHere.setLayoutData((Object)new GridData(768));
            SavePreferenceStore sps = new SavePreferenceStore();
            this.restoreControl((Control)this.forceConvert);
            this.restoreControl((Control)this.quickCopy);
            this.restoreControl((Control)this.defaultBitrate);
            this.restoreControl((Control)this.useAvisynth);
            this.forceConvert.addSelectionListener((SelectionListener)sps);
            this.quickCopy.addSelectionListener((SelectionListener)sps);
            this.defaultBitrate.addSelectionListener((SelectionListener)sps);
            this.useAvisynth.addSelectionListener((SelectionListener)sps);
            this.mp3setting.setEnabled(this.forceConvert.getSelection());
            this.mp3setting.setPreferenceStore(this.getPreferenceStore());
            this.setCanConvert(true);
            this.updateStatus();
            PlatformUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)new SettingMonitor());
            return composite;
        }

        public void restoreControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.forceConvert) {
                this.forceConvert.setSelection(store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + "forceconvert"));
            } else if (control == this.quickCopy) {
                this.quickCopy.setSelection(store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + "quickcopy"));
            } else if (control == this.defaultBitrate) {
                String value = store.getString(String.valueOf(this.getPreferenceKey()) + "." + "defaultBitrate");
                int s = this.defaultBitrate.getItemCount();
                int i = 0;
                while (i < s) {
                    if (this.defaultBitrate.getItem(i).equals(value)) {
                        this.defaultBitrate.select(i);
                        break;
                    }
                    ++i;
                }
            } else if (control == this.useAvisynth) {
                this.useAvisynth.setSelection(store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + "useAvisynth"));
            }
        }

        public IPreferenceStore getPreferenceStore() {
            return Akj_betasPlugin.getDefault().getPreferenceStore();
        }

        public void storeControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.forceConvert) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + "forceconvert", this.forceConvert.getSelection());
            } else if (control == this.quickCopy) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + "quickcopy", this.quickCopy.getSelection());
            } else if (control == this.defaultBitrate) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + "defaultBitrate", this.defaultBitrate.getItem(this.defaultBitrate.getSelectionIndex()));
            } else if (control == this.useAvisynth) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + "useAvisynth", this.useAvisynth.getSelection());
            }
        }

        public void inconvert(File file) {
            if (this.ffmpegExecuter != null) {
                this.ffmpegExecuter.execute(new File[]{file});
            }
        }

        public void beforeConvert() {
            if (FFMpegUI.getFFmpeg() == null && !this.quickCopy.getSelection()) {
                log.warn((Object)"this never happend:must filtered by canConvert");
                return;
            }
            String ffmpegPath = FFMpegUI.getFFmpeg();
            if (ffmpegPath == null) {
                ffmpegPath = FFMpegUI.getPureFFmpeg();
            }
            MP3ConvertTabBuilder.this.fileOverwriteControler = new FileOverwriteControler(MP3ConvertTabBuilder.this.tab.getShell());
            this.ffmpegExecuter = new FFMpegExecuter();
            this.ffmpegExecuter.setIgnoreAvisynthExtensions(new String[0]);
            this.ffmpegExecuter.setExecuteListener(new FFMpegMonitor());
            MP3FFMpegPreference preference = new MP3FFMpegPreference();
            this.ffmpegExecuter.setFfmpegPreference(preference);
            preference.setFfmpegPath(ffmpegPath);
            preference.setExtension("mp3");
            this.ffmpegExecuter.setSameDirectory(this.samefolder.getSelection());
            this.ffmpegExecuter.setBackup(this.backup.getSelection());
            if (!this.samefolder.getSelection()) {
                this.ffmpegExecuter.setExportDir(this.directoryChooser.getAbsoluteFilePath());
            }
            preference.setForceConvert(this.forceConvert.getSelection());
            preference.setUseCopy(this.quickCopy.getSelection());
            preference.setDefaultBitrate(Integer.parseInt(this.defaultBitrate.getItem(this.defaultBitrate.getSelectionIndex())));
            this.ffmpegExecuter.setUseAvisynth(this.useAvisynth.getSelection());
            preference.setConvertBitrate(this.mp3setting.getBitrate());
            preference.setConvertFramerate(this.mp3setting.getFramerate());
            preference.setConvertChannel(this.mp3setting.getChannel());
        }

        public void afterConvert() {
            MP3ConvertTabBuilder.this.fileOverwriteControler = null;
        }

        public boolean isCanConvert() {
            String ffmpegPath = FFMpegUI.getFFmpegOrPureFFMpeg();
            if (!FFMpegUI.isFFMpegOrPureFFMpegAvailable(ffmpegPath)) {
                return false;
            }
            return super.isCanConvert();
        }

        public void cancelConvert() {
            this.ffmpegExecuter.cancel();
        }

        public void updateStatus() {
            String ffmpegPath = FFMpegUI.getFFmpeg();
            if (ffmpegPath == null) {
                if (this.noFFMpegImage != null) {
                    this.dragHere.setImage(this.noFFMpegImage);
                }
                this.setMessage("");
                if (this.quickCopy != null) {
                    this.setCanConvert(this.quickCopy.getSelection());
                    this.setCantConvertStatusbarMessage(Messages.getString("ffmpeg_statusbar.no_ffmpeg"));
                } else {
                    log.warn((Object)"this never called");
                    this.setCanConvert(this.getPreferenceStore().getBoolean(String.valueOf(this.getPreferenceKey()) + "." + "quickcopy"));
                }
            } else {
                if (this.canConvertImage != null) {
                    this.dragHere.setImage(this.canConvertImage);
                }
                if (this.samefolder.getSelection() || this.directoryChooser.getFile() != null) {
                    this.setMessage(Messages.getString("dropsomething.drag_folder"));
                    this.setCanConvert(true);
                } else {
                    this.setErrorMessage(Messages.getString("dropsomething.choose_folder"));
                    this.setCanConvert(false);
                }
            }
            log.info((Object)("currentStatus:" + this.isCanConvert()));
        }

        public void setMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 64, 255, 64));
                this.dragHere.setText(text);
            }
        }

        public void setErrorMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 255, 0, 0));
                this.dragHere.setText(text);
            }
        }

        public class SettingMonitor
        implements IPropertyChangeListener {
            public void propertyChange(PropertyChangeEvent event) {
                log.info((Object)event.getProperty());
                if (event.getProperty().equals("ffmpeg.ffmpeg_path")) {
                    MP3ConvertTab.this.updateStatus();
                }
            }
        }

        public class SynchEnabled
        implements SelectionListener {
            private Composite target;

            public SynchEnabled(Composite target) {
                this.target = target;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.target.setEnabled(((Button)e.getSource()).getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                this.target.setEnabled(((Button)e.getSource()).getSelection());
            }
        }

        public class SavePreferenceStore
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MP3ConvertTab.this.storeControl((Control)e.getSource());
            }
        }

        public class FFMpegMonitor
        implements DirectryBasedExecuterListener {
            public void beforeConvert() {
                System.out.println("before:");
                MP3ConvertTab.this.setProgress(0);
            }

            public void afterConvert() {
                MP3ConvertTab.this.setProgress(0);
            }

            public void startConvert(File file) {
                String ffmpegPath = MP3ConvertTab.this.ffmpegExecuter.getFfmpegPreference().getFfmpegPath();
                String codec = MP3ConvertTab.this.ffmpegExecuter.getFfmpegPreference().getAudioCodec();
                if (FFMpegUI.isPureFFMpeg(ffmpegPath) && !FFMpegUI.isPureFFMpegSupportedAudioCodec(codec)) {
                    StatusBarUtils.showStatusBar(Messages.getString("ffmpeg_statusbar.no_ffmpeg"));
                    try {
                        MP3ConvertTab.this.getProcessPrinter().printError(Messages.getString("ffmpeg_error.no_ffmpeg"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    MP3ConvertTab.this.perfomeCancel();
                    return;
                }
                log.info((Object)("set guess:" + MP3ConvertTab.this.ffmpegExecuter.getGuessSize() + "kB"));
                MP3ConvertTab.this.setProgressMaxBytes(MP3ConvertTab.this.ffmpegExecuter.getGuessSize());
            }

            public void endConvert(File file) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[complete:mp3]" + file.getAbsolutePath() + "\n\n");
                MP3ConvertTab.this.setProgress(100);
            }

            public void faildConvert(File file, String message) {
                if (FFMpegUtils.isMP4FileName(file.getName())) {
                    StatusBarUtils.showStatusBar(Messages.getString("ffmpeg_statusbar.no_ffmpeg"));
                    try {
                        MP3ConvertTab.this.getProcessPrinter().printError(Messages.getString("ffmpeg_error.no_ffmpeg_mp4"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    MP3ConvertTab.this.perfomeCancel();
                    return;
                }
                StatusBarUtils.showStatusBar(Messages.getString("ffmpeg_statusbar.faild"));
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[faild:mp3]" + message + "," + file.getAbsolutePath() + "\n\n");
            }

            public void printProcess(String line) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printError(line);
                if (FFMpegUtils.isProgressString(line)) {
                    MP3ConvertTab.this.progressBytes(FFMpegUtils.getProgressSize(line));
                }
            }

            public boolean askOverwrite(File output) {
                return FileOverwriteControler.askOverwrite(MP3ConvertTabBuilder.this.fileOverwriteControler, output);
            }
        }
    }
}

