/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

public class VersionedIdentifier {
    private String identifier = "";
    private int major = 0;
    private int minor = 0;
    private int service = 0;
    private String qualifier = "";
    private String version;
    public static final int LESS_THAN = -1;
    public static final int EQUAL = 0;
    public static final int EQUIVALENT = 1;
    public static final int COMPATIBLE = 2;
    public static final int GREATER_THAN = 3;

    public VersionedIdentifier(String id, String version) {
        this.identifier = id;
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean equalIdentifiers(VersionedIdentifier id) {
        if (id == null) {
            return this.identifier == null;
        }
        return id.identifier.equals(this.identifier);
    }

    public int compareVersion(VersionedIdentifier id) {
        if (id == null) {
            if (this.major == 0 && this.minor == 0 && this.service == 0) {
                return -1;
            }
            return 1;
        }
        if (this.major > id.major) {
            return 3;
        }
        if (this.major < id.major) {
            return -1;
        }
        if (this.minor > id.minor) {
            return 2;
        }
        if (this.minor < id.minor) {
            return -1;
        }
        if (this.service > id.service) {
            return 1;
        }
        if (this.service < id.service) {
            return -1;
        }
        return this.compareQualifiers(this.qualifier, id.qualifier);
    }

    private int compareQualifiers(String q1, String q2) {
        int result = q1.compareTo(q2);
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionedIdentifier)) {
            return false;
        }
        VersionedIdentifier other = (VersionedIdentifier)obj;
        return this.equalIdentifiers(other) && this.major == other.major && this.minor == other.minor && this.service == other.service && this.version.equals(other.version) && this.compareQualifiers(this.qualifier, other.qualifier) == 0;
    }

    public int hashCode() {
        return (String.valueOf(this.identifier) + "_" + this.version).hashCode();
    }

    public String toString() {
        return String.valueOf(this.identifier) + "_" + this.version;
    }
}

