/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.dialogs.MarkerResolutionSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.markers.internal.Messages;

public class ActionResolveMarker
extends SelectionProviderAction {
    private IWorkbenchPart part;

    public ActionResolveMarker(IWorkbenchPart part, ISelectionProvider provider) {
        super(provider, Messages.getString("resolveMarkerAction.title"));
        this.part = part;
        this.setEnabled(false);
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        IMarker marker = this.getMarker();
        if (marker == null) {
            return;
        }
        IMarkerResolution[] resolutions = this.getResolutions(marker);
        if (resolutions.length == 0) {
            MessageDialog.openInformation((Shell)this.part.getSite().getShell(), (String)Messages.getString("resolveMarkerAction.dialogTitle"), (String)Messages.getString("resolveMarkerAction.noResolutionsLabel"));
            return;
        }
        MarkerResolutionSelectionDialog d = new MarkerResolutionSelectionDialog(this.part.getSite().getShell(), resolutions);
        if (d.open() != 0) {
            return;
        }
        Object[] result = d.getResult();
        if (result != null && result.length > 0) {
            ((IMarkerResolution)result[0]).run(marker);
        }
    }

    private IMarkerResolution[] getResolutions(IMarker marker) {
        return IDE.getMarkerHelpRegistry().getResolutions(marker);
    }

    private IMarker getMarker() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.size() != 1) {
            return null;
        }
        return (IMarker)selection.getFirstElement();
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(false);
        if (selection.size() != 1) {
            return;
        }
        IMarker marker = (IMarker)selection.getFirstElement();
        if (marker == null) {
            return;
        }
        this.setEnabled(IDE.getMarkerHelpRegistry().hasResolutions(marker));
    }
}

