/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.adaptor.EclipseBundleData;
import org.eclipse.core.runtime.adaptor.EclipseElementFactory;
import org.eclipse.core.runtime.adaptor.EclipseLog;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.core.runtime.adaptor.FileManager;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.adaptor.StreamManager;
import org.eclipse.core.runtime.internal.adaptor.BasicLocation;
import org.eclipse.core.runtime.internal.adaptor.BundleLocalizationImpl;
import org.eclipse.core.runtime.internal.adaptor.BundleStopper;
import org.eclipse.core.runtime.internal.adaptor.CachedManifest;
import org.eclipse.core.runtime.internal.adaptor.EclipseBundleInstaller;
import org.eclipse.core.runtime.internal.adaptor.EclipseCommandProvider;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.core.runtime.internal.adaptor.PluginConverterImpl;
import org.eclipse.core.runtime.internal.adaptor.PluginParser;
import org.eclipse.core.runtime.internal.adaptor.URLConverterImpl;
import org.eclipse.core.runtime.internal.stats.StatsManager;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FilePath;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.AdaptorElementFactory;
import org.eclipse.osgi.framework.adaptor.core.InvalidVersion;
import org.eclipse.osgi.framework.adaptor.core.StateManager;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

public class EclipseAdaptor
extends AbstractFrameworkAdaptor {
    public static final String PROP_CLEAN = "osgi.clean";
    public static final String PROP_EXITONERROR = "eclipse.exitOnError";
    static final String F_LOG = ".log";
    public static final String PLUGIN_CLASS = "Plugin-Class";
    public static final String ECLIPSE_AUTOSTART = "Eclipse-AutoStart";
    public static final String ECLIPSE_AUTOSTART_EXCEPTIONS = "exceptions";
    public static final String SAXFACTORYNAME = "javax.xml.parsers.SAXParserFactory";
    public static final String DOMFACTORYNAME = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String RUNTIME_ADAPTOR = "org.eclipse.osgi/eclipseadaptor";
    private static final String OPTION_PLATFORM_ADMIN = "org.eclipse.osgi/eclipseadaptor/debug/platformadmin";
    private static final String OPTION_PLATFORM_ADMIN_RESOLVER = "org.eclipse.osgi/eclipseadaptor/debug/platformadmin/resolver";
    private static final String OPTION_MONITOR_PLATFORM_ADMIN = "org.eclipse.osgi/eclipseadaptor/resolver/timing";
    private static final String OPTION_RESOLVER_READER = "org.eclipse.osgi/eclipseadaptor/resolver/reader/timing";
    private static final String OPTION_CONVERTER = "org.eclipse.osgi/eclipseadaptor/converter/debug";
    private static final String OPTION_LOCATION = "org.eclipse.osgi/eclipseadaptor/debug/location";
    public static final byte BUNDLEDATA_VERSION = 16;
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    private static EclipseAdaptor instance;
    private byte cacheVersion;
    private long timeStamp = 0L;
    private String installPath = null;
    private boolean exitOnError = true;
    private BundleStopper stopper;
    private FileManager fileManager;
    private boolean reinitialize = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public EclipseAdaptor(String[] args) {
        super(args);
        instance = this;
        this.setDebugOptions();
    }

    public static EclipseAdaptor getDefault() {
        return instance;
    }

    private FrameworkLog createPerformanceLog() {
        int lastSlash;
        String logFileProp = System.getProperty("osgi.logfile");
        if (logFileProp != null && (lastSlash = logFileProp.lastIndexOf(File.separatorChar)) > 0) {
            String logFile = String.valueOf(logFileProp.substring(0, lastSlash + 1)) + "performance.log";
            return new EclipseLog(new File(logFile));
        }
        return new EclipseLog(new PrintWriter(System.err));
    }

    public void initialize(EventPublisher publisher) {
        Location installLoc;
        if (Boolean.getBoolean(PROP_CLEAN)) {
            this.cleanOSGiCache();
        }
        boolean readOnlyConfiguration = LocationManager.getConfigurationLocation().isReadOnly();
        this.fileManager = this.initFileManager(LocationManager.getOSGiConfigurationDir(), readOnlyConfiguration ? "none" : null, readOnlyConfiguration);
        this.readHeaders();
        super.initialize(publisher);
        if (System.getProperty("org.osgi.framework.bootdelegation") == null && !"none".equals(System.getProperty("osgi.java.profile.bootdelegation"))) {
            System.getProperties().put("org.osgi.framework.bootdelegation", "*");
        }
        if ((installLoc = LocationManager.getInstallLocation()) != null) {
            URL installURL = installLoc.getURL();
            this.installPath = installURL.getPath();
        }
    }

    public void initializeMetadata() {
    }

    protected void initBundleStoreRootDir() {
        File configurationLocation = LocationManager.getOSGiConfigurationDir();
        if (configurationLocation != null) {
            this.bundleStoreRootDir = new File(configurationLocation, "bundles");
            this.bundleStore = this.bundleStoreRootDir.getAbsolutePath();
        } else {
            this.bundleStore = "bundles";
            this.bundleStoreRootDir = new File(this.bundleStore);
        }
        this.properties.put("osgi.bundlestore", this.bundleStoreRootDir.getAbsolutePath());
    }

    protected FrameworkLog createFrameworkLog() {
        if (this.frameworkLog != null) {
            return this.frameworkLog;
        }
        return EclipseStarter.createFrameworkLog();
    }

    private File[] findStateFiles() {
        File lazyFile;
        File stateFile;
        block12: {
            block11: {
                if (this.reinitialize) {
                    return new File[2];
                }
                stateFile = null;
                lazyFile = null;
                try {
                    stateFile = this.fileManager.lookup(".state", false);
                    lazyFile = this.fileManager.lookup(".lazy", false);
                }
                catch (IOException ex) {
                    if (!Debug.DEBUG_GENERAL) break block11;
                    Debug.println("Error reading state file " + ex.getMessage());
                    Debug.printStackTrace(ex);
                }
            }
            if (stateFile == null || !stateFile.isFile()) {
                Location parentConfiguration = null;
                Location currentConfiguration = LocationManager.getConfigurationLocation();
                if (currentConfiguration != null && (parentConfiguration = currentConfiguration.getParentLocation()) != null) {
                    try {
                        File stateLocationDir = new File(parentConfiguration.getURL().getFile(), "org.eclipse.osgi");
                        FileManager newFileManager = this.initFileManager(stateLocationDir, "none", true);
                        stateFile = newFileManager.lookup(".state", false);
                        lazyFile = newFileManager.lookup(".lazy", false);
                    }
                    catch (IOException ex) {
                        if (Debug.DEBUG_GENERAL) {
                            Debug.println("Error reading state file " + ex.getMessage());
                            Debug.printStackTrace(ex);
                        }
                        break block12;
                    }
                }
                try {
                    if (this.canWrite()) {
                        stateFile = this.fileManager.lookup(".state", true);
                        lazyFile = this.fileManager.lookup(".lazy", true);
                    }
                }
                catch (IOException ex) {
                    if (!Debug.DEBUG_GENERAL) break block12;
                    Debug.println("Error reading state file " + ex.getMessage());
                    Debug.printStackTrace(ex);
                }
            }
        }
        return new File[]{stateFile, lazyFile};
    }

    protected StateManager createStateManager() {
        File[] stateFiles = this.findStateFiles();
        File stateFile = stateFiles[0];
        File lazyFile = stateFiles[1];
        this.stateManager = new StateManager(stateFile, lazyFile, this.context, this.timeStamp);
        this.stateManager.setInstaller(new EclipseBundleInstaller(this.context));
        State systemState = null;
        if (!this.invalidState && (systemState = this.stateManager.readSystemState()) != null) {
            return this.stateManager;
        }
        systemState = this.stateManager.createSystemState();
        Bundle[] installedBundles = this.context.getBundles();
        if (installedBundles == null) {
            return this.stateManager;
        }
        StateObjectFactory factory = this.stateManager.getFactory();
        int i = 0;
        while (i < installedBundles.length) {
            Bundle toAdd = installedBundles[i];
            try {
                Dictionary toAddManifest = toAdd.getHeaders("");
                if (toAddManifest instanceof CachedManifest) {
                    toAddManifest = ((CachedManifest)toAddManifest).getManifest();
                }
                BundleDescription newDescription = factory.createBundleDescription(systemState, toAddManifest, toAdd.getLocation(), toAdd.getBundleId());
                systemState.addBundle(newDescription);
            }
            catch (BundleException bundleException) {}
            ++i;
        }
        systemState.setTimeStamp(this.timeStamp);
        systemState.resolve();
        this.invalidState = false;
        return this.stateManager;
    }

    public void shutdownStateManager() {
        if (!this.canWrite() || !this.stateManager.saveNeeded()) {
            return;
        }
        try {
            File stateTmpFile = File.createTempFile(".state", ".new", LocationManager.getOSGiConfigurationDir());
            File lazyTmpFile = File.createTempFile(".lazy", ".new", LocationManager.getOSGiConfigurationDir());
            this.stateManager.shutdown(stateTmpFile, lazyTmpFile);
            this.fileManager.lookup(".state", true);
            this.fileManager.lookup(".lazy", true);
            this.fileManager.update(new String[]{".state", ".lazy"}, new String[]{stateTmpFile.getName(), lazyTmpFile.getName()});
        }
        catch (IOException e) {
            this.frameworkLog.log(new FrameworkEvent(2, this.context.getBundle(), e));
        }
    }

    private void cleanOSGiCache() {
        File osgiConfig = LocationManager.getOSGiConfigurationDir();
        this.rm(osgiConfig);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readHeaders() {
        InputStream bundleDataStream = this.findBundleDataFile();
        if (bundleDataStream == null) {
            return;
        }
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(bundleDataStream));
            try {
                this.cacheVersion = in.readByte();
                if (this.cacheVersion == 16) {
                    this.timeStamp = in.readLong();
                    this.initialBundleStartLevel = in.readInt();
                    this.nextId = in.readLong();
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                in.close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                in.close();
                return;
            }
        }
        catch (IOException e) {
            if (!Debug.DEBUG_GENERAL) return;
            Debug.println("Error reading framework metadata: " + e.getMessage());
            Debug.printStackTrace(e);
        }
    }

    public AdaptorElementFactory getElementFactory() {
        if (this.elementFactory == null) {
            this.elementFactory = new EclipseElementFactory();
        }
        return this.elementFactory;
    }

    public void frameworkStart(BundleContext aContext) throws BundleException {
        Class<?> clazz;
        EclipseEnvironmentInfo.getDefault();
        this.registerEndorsedXMLParser(aContext);
        PluginConverterImpl converter = new PluginConverterImpl(aContext);
        super.frameworkStart(aContext);
        Bundle bundle = aContext.getBundle();
        Location location = LocationManager.getUserLocation();
        Hashtable<String, String> locationProperties = new Hashtable<String, String>(1);
        if (location != null) {
            locationProperties.put("type", "osgi.user.area");
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            aContext.registerService(clazz2.getName(), (Object)location, locationProperties);
        }
        if ((location = LocationManager.getInstanceLocation()) != null) {
            locationProperties.put("type", "osgi.instance.area");
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            aContext.registerService(clazz3.getName(), (Object)location, locationProperties);
        }
        if ((location = LocationManager.getConfigurationLocation()) != null) {
            locationProperties.put("type", "osgi.configuration.area");
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            aContext.registerService(clazz4.getName(), (Object)location, locationProperties);
        }
        if ((location = LocationManager.getInstallLocation()) != null) {
            locationProperties.put("type", "osgi.install.area");
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            aContext.registerService(clazz5.getName(), (Object)location, locationProperties);
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz.getName(), EclipseEnvironmentInfo.getDefault(), bundle);
        Class<?> clazz6 = class$2;
        if (clazz6 == null) {
            try {
                clazz6 = class$2 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz6.getName(), this.stateManager, bundle);
        Class<?> clazz7 = class$3;
        if (clazz7 == null) {
            try {
                clazz7 = class$3 = Class.forName("org.eclipse.osgi.service.pluginconversion.PluginConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz7.getName(), converter, bundle);
        Class<?> clazz8 = class$4;
        if (clazz8 == null) {
            try {
                clazz8 = class$4 = Class.forName("org.eclipse.osgi.service.urlconversion.URLConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz8.getName(), new URLConverterImpl(), bundle);
        Class<?> clazz9 = class$5;
        if (clazz9 == null) {
            try {
                clazz9 = class$5 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz9.getName(), new EclipseCommandProvider(aContext), bundle);
        Class<?> clazz10 = class$6;
        if (clazz10 == null) {
            try {
                clazz10 = class$6 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz10.getName(), this.getFrameworkLog(), bundle);
        this.registerPerformanceLog(bundle);
        Class<?> clazz11 = class$7;
        if (clazz11 == null) {
            try {
                clazz11 = class$7 = Class.forName("org.eclipse.osgi.service.localization.BundleLocalization");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz11.getName(), new BundleLocalizationImpl(), bundle);
    }

    private void registerPerformanceLog(Bundle bundle) {
        FrameworkLog service = this.createPerformanceLog();
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String serviceName = clazz.getName();
        Hashtable serviceProperties = new Hashtable(7);
        Dictionary headers = bundle.getHeaders();
        serviceProperties.put("service.vendor", headers.get("Bundle-Vendor"));
        serviceProperties.put("service.ranking", new Integer(Integer.MIN_VALUE));
        serviceProperties.put("service.pid", String.valueOf(bundle.getBundleId() + 46L) + service.getClass().getName());
        serviceProperties.put("performance", Boolean.TRUE.toString());
        this.context.registerService(serviceName, (Object)service, serviceProperties);
    }

    private void setDebugOptions() {
        FrameworkDebugOptions options = FrameworkDebugOptions.getDefault();
        if (options == null) {
            return;
        }
        StateManager.DEBUG = options != null;
        StateManager.DEBUG_READER = options.getBooleanOption(OPTION_RESOLVER_READER, false);
        StateManager.MONITOR_PLATFORM_ADMIN = options.getBooleanOption(OPTION_MONITOR_PLATFORM_ADMIN, false);
        StateManager.DEBUG_PLATFORM_ADMIN = options.getBooleanOption(OPTION_PLATFORM_ADMIN, false);
        StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER = options.getBooleanOption(OPTION_PLATFORM_ADMIN_RESOLVER, false);
        PluginConverterImpl.DEBUG = options.getBooleanOption(OPTION_CONVERTER, false);
        BasicLocation.DEBUG = options.getBooleanOption(OPTION_LOCATION, false);
    }

    private void registerEndorsedXMLParser(BundleContext bc) {
        try {
            Class.forName(SAXFACTORYNAME);
            bc.registerService(SAXFACTORYNAME, (Object)new SaxParsingService(), new Hashtable());
            Class.forName(DOMFACTORYNAME);
            bc.registerService(DOMFACTORYNAME, (Object)new DomParsingService(), new Hashtable());
        }
        catch (ClassNotFoundException e) {
            String message = EclipseAdaptorMsg.ECLIPSE_ADAPTOR_ERROR_XML_SERVICE;
            this.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", message, 0, e, null));
        }
    }

    public boolean canWrite() {
        return !this.fileManager.isReadOnly();
    }

    public void frameworkStop(BundleContext aContext) throws BundleException {
        this.saveMetaData();
        super.frameworkStop(aContext);
        this.printStats();
        PluginParser.releaseXMLParsing();
        this.fileManager.close();
    }

    private void printStats() {
        String constraintResolution;
        String packageAdminResolution;
        FrameworkDebugOptions debugOptions = FrameworkDebugOptions.getDefault();
        if (debugOptions == null) {
            return;
        }
        String registryParsing = debugOptions.getOption("org.eclipse.core.runtime/registry/parsing/timing/value");
        if (registryParsing != null) {
            EclipseAdaptorMsg.debug("Time spent in registry parsing: " + registryParsing);
        }
        if ((packageAdminResolution = debugOptions.getOption("debug.packageadmin/timing/value")) != null) {
            System.out.println("Time spent in package admin resolve: " + packageAdminResolution);
        }
        if ((constraintResolution = debugOptions.getOption("org.eclipse.core.runtime.adaptor/resolver/timing/value")) != null) {
            System.out.println("Time spent resolving the dependency system: " + constraintResolution);
        }
    }

    private InputStream findBundleDataFile() {
        InputStream bundleDataStream;
        StreamManager streamManager;
        block8: {
            if (this.reinitialize) {
                return null;
            }
            streamManager = new StreamManager(this.fileManager);
            bundleDataStream = null;
            try {
                bundleDataStream = streamManager.getInputStream(".bundledata", 0);
            }
            catch (IOException ex) {
                if (!Debug.DEBUG_GENERAL) break block8;
                Debug.println("Error reading framework metadata: " + ex.getMessage());
                Debug.printStackTrace(ex);
            }
        }
        if (bundleDataStream == null) {
            Location currentConfiguration = LocationManager.getConfigurationLocation();
            Location parentConfiguration = null;
            if (currentConfiguration != null && (parentConfiguration = currentConfiguration.getParentLocation()) != null) {
                try {
                    File bundledataLocationDir = new File(parentConfiguration.getURL().getFile(), "org.eclipse.osgi");
                    FileManager newFileManager = this.initFileManager(bundledataLocationDir, "none", true);
                    bundleDataStream = streamManager.getInputStream(".bundledata", 0);
                    newFileManager.close();
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
            }
        }
        return bundleDataStream;
    }

    public BundleData[] getInstalledBundles() {
        InputStream bundleDataStream = this.findBundleDataFile();
        if (bundleDataStream == null) {
            return null;
        }
        try {
            BundleData[] bundleDataArray;
            byte version;
            DataInputStream in;
            block15: {
                in = new DataInputStream(new BufferedInputStream(bundleDataStream));
                version = in.readByte();
                if (version == 16) break block15;
                BundleData[] bundleDataArray2 = null;
                Object var11_7 = null;
                in.close();
                return bundleDataArray2;
            }
            try {
                in.readLong();
                in.readInt();
                in.readLong();
                int bundleCount = in.readInt();
                ArrayList<EclipseBundleData> result = new ArrayList<EclipseBundleData>(bundleCount);
                long id = -1L;
                boolean bundleDiscarded = false;
                int i = 0;
                while (i < bundleCount) {
                    block16: {
                        try {
                            id = in.readLong();
                            if (id != 0L) {
                                EclipseBundleData data = (EclipseBundleData)this.getElementFactory().createBundleData(this, id);
                                this.loadMetaDataFor(data, in, version);
                                data.initializeExistingBundle();
                                if (Debug.DEBUG_GENERAL) {
                                    Debug.println("BundleData created: " + data);
                                }
                                this.processExtension(data, (byte)1);
                                result.add(data);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            bundleDiscarded = true;
                        }
                        catch (BundleException bundleException) {
                            bundleDiscarded = true;
                        }
                        catch (IOException e) {
                            bundleDiscarded = true;
                            if (!Debug.DEBUG_GENERAL) break block16;
                            Debug.println("Error reading framework metadata: " + e.getMessage());
                            Debug.printStackTrace(e);
                        }
                    }
                    ++i;
                }
                if (bundleDiscarded) {
                    System.getProperties().put("eclipse.refreshBundles", "true");
                }
                bundleDataArray = result.toArray(new BundleData[result.size()]);
                Object var11_8 = null;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return bundleDataArray;
        }
        catch (IOException e) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Error reading framework metadata: " + e.getMessage());
                Debug.printStackTrace(e);
            }
            return null;
        }
    }

    protected void loadMetaDataFor(EclipseBundleData data, DataInputStream in, byte version) throws IOException {
        File storedPath;
        byte flag = in.readByte();
        if (flag == 0) {
            return;
        }
        data.setLocation(this.readString(in, false));
        data.setFileName(this.readString(in, false));
        data.setSymbolicName(this.readString(in, false));
        data.setVersion(this.loadVersion(in));
        data.setActivator(this.readString(in, false));
        data.setAutoStart(in.readBoolean());
        int exceptionsCount = in.readInt();
        String[] autoStartExceptions = exceptionsCount > 0 ? new String[exceptionsCount] : null;
        int i = 0;
        while (i < exceptionsCount) {
            autoStartExceptions[i] = in.readUTF();
            ++i;
        }
        data.setAutoStartExceptions(autoStartExceptions);
        data.hasPackageInfo = in.readBoolean();
        data.buddyList = this.readString(in, false);
        data.registeredBuddyList = this.readString(in, false);
        data.setPluginClass(this.readString(in, false));
        data.setClassPathString(this.readString(in, false));
        data.setNativePaths(this.readString(in, false));
        data.setExecutionEnvironment(this.readString(in, false));
        data.setDynamicImports(this.readString(in, false));
        data.setGeneration(in.readInt());
        data.setStartLevel(in.readInt());
        data.setStatus(in.readInt());
        data.setReference(in.readBoolean());
        data.setManifestTimeStamp(in.readLong());
        data.setManifestType(in.readByte());
        data.setLastModified(in.readLong());
        data.setType(in.readInt());
        if (data.isReference() && !(storedPath = new File(data.getFileName())).isAbsolute()) {
            data.setFileName(new FilePath(String.valueOf(this.installPath) + data.getFileName()).toString());
        }
    }

    private Version loadVersion(DataInputStream in) throws IOException {
        String versionString = this.readString(in, false);
        try {
            return Version.parseVersion(versionString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new InvalidVersion(versionString);
        }
    }

    public void saveMetaDataFor(EclipseBundleData data) throws IOException {
        if (!data.isAutoStartable()) {
            --this.timeStamp;
        }
    }

    public void persistInitialBundleStartLevel(int value) {
        --this.timeStamp;
    }

    public void persistNextBundleID(long value) {
    }

    protected void saveMetaDataFor(BundleData data, DataOutputStream out) throws IOException {
        if (data.getBundleID() == 0L || !(data instanceof AbstractBundleData)) {
            out.writeByte(0);
            return;
        }
        EclipseBundleData bundleData = (EclipseBundleData)data;
        out.writeByte(1);
        this.writeStringOrNull(out, bundleData.getLocation());
        String storedFileName = bundleData.isReference() ? new FilePath(this.installPath).makeRelative(new FilePath(bundleData.getFileName())) : bundleData.getFileName();
        this.writeStringOrNull(out, storedFileName);
        this.writeStringOrNull(out, bundleData.getSymbolicName());
        this.writeStringOrNull(out, bundleData.getVersion().toString());
        this.writeStringOrNull(out, bundleData.getActivator());
        out.writeBoolean(bundleData.isAutoStart());
        String[] autoStartExceptions = bundleData.getAutoStartExceptions();
        if (autoStartExceptions == null) {
            out.writeInt(0);
        } else {
            out.writeInt(autoStartExceptions.length);
            int i = 0;
            while (i < autoStartExceptions.length) {
                out.writeUTF(autoStartExceptions[i]);
                ++i;
            }
        }
        out.writeBoolean(bundleData.hasPackageInfo);
        this.writeStringOrNull(out, bundleData.buddyList);
        this.writeStringOrNull(out, bundleData.registeredBuddyList);
        this.writeStringOrNull(out, bundleData.getPluginClass());
        this.writeStringOrNull(out, bundleData.getClassPathString());
        this.writeStringOrNull(out, bundleData.getNativePathsString());
        this.writeStringOrNull(out, bundleData.getExecutionEnvironment());
        this.writeStringOrNull(out, bundleData.getDynamicImports());
        out.writeInt(bundleData.getGeneration());
        out.writeInt(bundleData.getStartLevel());
        out.writeInt(bundleData.getPersistentStatus());
        out.writeBoolean(bundleData.isReference());
        out.writeLong(bundleData.getManifestTimeStamp());
        out.writeByte(bundleData.getManifestType());
        out.writeLong(bundleData.getLastModified());
        out.writeInt(bundleData.getType());
    }

    private String readString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        return intern ? in.readUTF().intern() : in.readUTF();
    }

    private void writeStringOrNull(DataOutputStream out, String string) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }

    /*
     * Exception decompiling
     */
    public void saveMetaData() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 238->244)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BundleWatcher getBundleWatcher() {
        return StatsManager.getDefault();
    }

    protected BundleContext getContext() {
        return this.context;
    }

    public void frameworkStopping(BundleContext aContext) {
        super.frameworkStopping(aContext);
        this.stopper = new BundleStopper(this.context);
        this.stopper.stopBundles();
    }

    private boolean isFatalException(Throwable error) {
        if (error instanceof VirtualMachineError) {
            return true;
        }
        return error instanceof ThreadDeath;
    }

    /*
     * Exception decompiling
     */
    public void handleRuntimeError(Throwable error) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 139->143)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void setLog(FrameworkLog log) {
        this.frameworkLog = log;
    }

    BundleStopper getBundleStopper() {
        return this.stopper;
    }

    private FileManager initFileManager(File baseDir, String lockMode, boolean readOnly) {
        FileManager fManager = new FileManager(baseDir, lockMode, readOnly);
        try {
            fManager.open(!readOnly);
        }
        catch (IOException ex) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Error reading framework metadata: " + ex.getMessage());
                Debug.printStackTrace(ex);
            }
            String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FILEMANAGER_OPEN_ERROR, ex.getMessage());
            FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", message, 0, ex, null);
            this.getFrameworkLog().log(logEntry);
        }
        return fManager;
    }

    private class SaxParsingService
    implements ServiceFactory {
        SaxParsingService() {
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return SAXParserFactory.newInstance();
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }

    private class DomParsingService
    implements ServiceFactory {
        DomParsingService() {
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return DocumentBuilderFactory.newInstance();
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

